/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.sim;

import org.patryk3211.powergrid.electricity.sim.AbstractElectricWire;
import org.patryk3211.powergrid.electricity.sim.node.IElectricNode;

public class ElectricWire
extends AbstractElectricWire {
    protected double resistance;

    public ElectricWire(double resistance, IElectricNode node1, IElectricNode node2) {
        super(node1, node2);
        ElectricWire.validateResistance(resistance);
        this.resistance = resistance;
    }

    public void setResistance(double resistance) {
        ElectricWire.validateResistance(resistance);
        double old = this.resistance;
        this.resistance = resistance;
        if (this.network != null) {
            this.network.updateResistance(this, old);
        }
    }

    public double getResistance() {
        return this.resistance;
    }

    @Override
    public double conductance() {
        ElectricWire.validateResistance(this.resistance);
        return 1.0 / this.resistance;
    }

    private static void validateResistance(double resistance) {
        if (resistance <= 0.0) {
            throw new IllegalArgumentException("Wire resistance must be greater than zero");
        }
        if (!Double.isFinite(resistance)) {
            throw new IllegalArgumentException("Wire resistance is not finite");
        }
    }
}

