/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.sim;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.PowerGrid;
import org.patryk3211.powergrid.electricity.sim.AbstractElectricWire;
import org.patryk3211.powergrid.electricity.sim.NetworkGraph;
import org.patryk3211.powergrid.electricity.sim.OptimizingElectricalNetwork;
import org.patryk3211.powergrid.electricity.sim.node.CurrentSourceNode;
import org.patryk3211.powergrid.electricity.sim.node.FloatingNode;
import org.patryk3211.powergrid.electricity.sim.node.ICouplingNode;
import org.patryk3211.powergrid.electricity.sim.node.IElectricNode;
import org.patryk3211.powergrid.electricity.sim.node.INode;

public class GraphedElectricalNetwork
extends OptimizingElectricalNetwork {
    private final NetworkGraph graph;

    public GraphedElectricalNetwork(boolean addGMin) {
        this(new NetworkGraph(), addGMin);
    }

    public GraphedElectricalNetwork(NetworkGraph graph, boolean addGMin) {
        super(addGMin);
        this.graph = graph;
    }

    @Override
    public void addNode(INode node) {
        super.addNode(node);
        if (node instanceof IElectricNode) {
            IElectricNode enode = (IElectricNode)node;
            this.graph.addNode(enode);
        }
        if (node instanceof ICouplingNode) {
            ICouplingNode coupling = (ICouplingNode)node;
            this.graph.couple(coupling);
            for (IElectricNode coupled : coupling.coupledNodes()) {
                this.checkConnectivity(coupled, null);
                this.removeLeaf(coupled);
            }
        }
    }

    @Override
    public void removeNode(INode node) {
        super.removeNode(node);
        if (node instanceof IElectricNode) {
            IElectricNode enode = (IElectricNode)node;
            if (!this.graph.getConnectedLines(enode).isEmpty()) {
                PowerGrid.LOGGER.warn("Removed a node which had connections", new Throwable());
            }
            this.graph.removeNode(enode);
        }
        if (node instanceof ICouplingNode) {
            ICouplingNode cnode = (ICouplingNode)node;
            this.graph.decouple(cnode);
        }
    }

    private boolean circularCheck(IElectricNode node, Set<IElectricNode> checked, @Nullable MutableObject<IElectricNode> track) {
        if (node == null) {
            if (track != null) {
                track.setValue(null);
            }
            return true;
        }
        if (checked.contains(node)) {
            return true;
        }
        if (this.graph.isLeafEliminating(node)) {
            if (track != null) {
                track.setValue((Object)node);
            }
            return true;
        }
        List<IElectricNode> nodes = this.graph.getConnectedNodes(node);
        if (node instanceof CurrentSourceNode) {
            if (track != null) {
                track.setValue((Object)node);
            }
            return true;
        }
        if (nodes.size() <= 1) {
            checked.add(node);
            if (nodes.size() == 1) {
                this.circularCheck(nodes.get(0), checked, track);
            }
            return false;
        }
        if (nodes.size() >= 3) {
            if (track != null) {
                track.setValue((Object)node);
            }
            return true;
        }
        boolean failed = false;
        checked.add(node);
        for (IElectricNode nextNode : nodes) {
            if (checked.contains(nextNode) || this.circularCheck(nextNode, checked, track)) continue;
            failed = true;
        }
        return !failed;
    }

    private void checkConnectivity(IElectricNode node, Set<IElectricNode> outerChecked) {
        block11: {
            HashSet<IElectricNode> checked;
            block10: {
                if (node == null) {
                    return;
                }
                if (outerChecked == null) {
                    outerChecked = new HashSet<IElectricNode>();
                }
                if (!outerChecked.add(node)) {
                    return;
                }
                checked = new HashSet<IElectricNode>();
                if (!this.isLeaf(node)) break block10;
                MutableObject track = new MutableObject(null);
                if (this.circularCheck(node, checked, (MutableObject<IElectricNode>)track)) {
                    checked.add(node);
                    for (IElectricNode node2 : checked) {
                        this.removeLeaf(node2);
                    }
                    for (IElectricNode connected : this.graph.getConnectedNodes(node)) {
                        this.checkConnectivity(connected, outerChecked);
                    }
                } else {
                    for (IElectricNode node2 : checked) {
                        this.makeLeaf(node2, (IElectricNode)track.getValue());
                    }
                }
                break block11;
            }
            MutableObject track = new MutableObject(null);
            if (this.circularCheck(node, checked, (MutableObject<IElectricNode>)track)) break block11;
            checked.add(node);
            for (IElectricNode node2 : checked) {
                this.makeLeaf(node2, (IElectricNode)track.getValue());
            }
            for (IElectricNode connected : this.graph.getConnectedNodes(node)) {
                this.checkConnectivity(connected, outerChecked);
            }
        }
    }

    public void graphCheck() {
        HashSet checked = new HashSet();
        for (INode node : this.nodes) {
            if (node instanceof FloatingNode) continue;
        }
    }

    @Override
    protected boolean canOptimize(INode node) {
        if (node instanceof IElectricNode) {
            IElectricNode enode = (IElectricNode)node;
            return !this.graph.hasCouplings(enode);
        }
        return super.canOptimize(node);
    }

    @Override
    public void addWire(AbstractElectricWire wire) {
        this.graph.connect(wire.node1, wire.node2, wire);
        super.addWire(wire);
        this.checkConnectivity(wire.node1, null);
        this.checkConnectivity(wire.node2, null);
    }

    @Override
    public void removeWire(AbstractElectricWire wire) {
        this.graph.disconnect(wire.node1, wire.node2, wire);
        super.removeWire(wire);
        this.checkConnectivity(wire.node1, null);
        this.checkConnectivity(wire.node2, null);
    }

    public NetworkGraph getGraph() {
        return this.graph;
    }
}

