/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.sim.node;

import java.util.Collection;
import java.util.List;
import org.patryk3211.powergrid.electricity.sim.ElectricalNetwork;
import org.patryk3211.powergrid.electricity.sim.node.CouplingNode;
import org.patryk3211.powergrid.electricity.sim.node.IElectricNode;
import org.patryk3211.powergrid.electricity.sim.solver.IAdmittanceAdder;

public abstract class TransformerCoupling
extends CouplingNode {
    protected float ratio;
    protected float resistance;
    protected final Collection<IElectricNode> coupledNodes;

    protected TransformerCoupling(float ratio, float resistance, Collection<IElectricNode> coupledNodes) {
        if (resistance == 0.0f && ElectricalNetwork.LOGGER != null) {
            ElectricalNetwork.LOGGER.warn("Zero-resistance transformer couplings can cause unstable behaviour.");
        }
        this.ratio = ratio;
        this.resistance = resistance;
        this.coupledNodes = coupledNodes;
    }

    @Override
    public void couple(IAdmittanceAdder admittance) {
        admittance.add(this.index, this.index, this.resistance);
    }

    @Override
    public Collection<IElectricNode> coupledNodes() {
        return this.coupledNodes;
    }

    public abstract void setRatio(float var1);

    public void setResistance(float resistance) {
        if (this.network != null) {
            this.network.alterConductanceMatrix(this.index, this.index, resistance - this.resistance);
        }
        this.resistance = resistance;
    }

    public float getResistance() {
        return this.resistance;
    }

    public static TransformerCoupling create(float ratio, IElectricNode primary, IElectricNode secondary) {
        return new Tr1P1S(ratio, 0.0f, primary, secondary);
    }

    public static TransformerCoupling create(float ratio, float resistance, IElectricNode primary, IElectricNode secondary) {
        return new Tr1P1S(ratio, resistance, primary, secondary);
    }

    public static TransformerCoupling create(float ratio, IElectricNode primary, IElectricNode secondary1, IElectricNode secondary2) {
        return new Tr1P2S(ratio, 0.0f, primary, secondary1, secondary2);
    }

    public static TransformerCoupling create(float ratio, float resistance, IElectricNode primary, IElectricNode secondary1, IElectricNode secondary2) {
        return new Tr1P2S(ratio, resistance, primary, secondary1, secondary2);
    }

    public static TransformerCoupling create(float ratio, IElectricNode primary1, IElectricNode primary2, IElectricNode secondary1, IElectricNode secondary2) {
        return new Tr2P2S(ratio, 0.0f, primary1, primary2, secondary1, secondary2);
    }

    public static TransformerCoupling create(float ratio, float resistance, IElectricNode primary1, IElectricNode primary2, IElectricNode secondary1, IElectricNode secondary2) {
        return new Tr2P2S(ratio, resistance, primary1, primary2, secondary1, secondary2);
    }

    private static class Tr1P1S
    extends TransformerCoupling {
        private final IElectricNode primary;
        private final IElectricNode secondary;

        protected Tr1P1S(float ratio, float resistance, IElectricNode primary, IElectricNode secondary) {
            super(ratio, resistance, List.of(primary, secondary));
            this.primary = primary;
            this.secondary = secondary;
        }

        @Override
        public void couple(IAdmittanceAdder admittance) {
            super.couple(admittance);
            admittance.add(this.index, this.primary.getIndex(), this.ratio);
            admittance.add(this.index, this.secondary.getIndex(), -1.0);
            admittance.add(this.secondary.getIndex(), this.index, 1.0);
            admittance.add(this.primary.getIndex(), this.index, -this.ratio);
        }

        @Override
        public void setRatio(float ratio) {
            if (this.network != null) {
                float change = ratio - this.ratio;
                this.network.alterConductanceMatrix(this.index, this.primary.getIndex(), change);
                this.network.alterConductanceMatrix(this.primary.getIndex(), this.index, -change);
            }
            this.ratio = ratio;
        }
    }

    private static class Tr1P2S
    extends TransformerCoupling {
        private final IElectricNode primary;
        private final IElectricNode secondary1;
        private final IElectricNode secondary2;

        protected Tr1P2S(float ratio, float resistance, IElectricNode primary, IElectricNode secondary1, IElectricNode secondary2) {
            super(ratio, resistance, List.of(primary, secondary1, secondary2));
            this.primary = primary;
            this.secondary1 = secondary1;
            this.secondary2 = secondary2;
        }

        @Override
        public void couple(IAdmittanceAdder admittance) {
            super.couple(admittance);
            admittance.add(this.index, this.primary.getIndex(), this.ratio);
            admittance.add(this.index, this.secondary1.getIndex(), -1.0);
            admittance.add(this.index, this.secondary2.getIndex(), 1.0);
            admittance.add(this.secondary1.getIndex(), this.index, 1.0);
            admittance.add(this.secondary2.getIndex(), this.index, -1.0);
            admittance.add(this.primary.getIndex(), this.index, -this.ratio);
            admittance.add(this.primary.getIndex(), this.primary.getIndex(), 5.0E-9);
            admittance.add(this.secondary1.getIndex(), this.secondary1.getIndex(), 5.0E-9);
            admittance.add(this.primary.getIndex(), this.secondary1.getIndex(), -5.0E-9);
            admittance.add(this.secondary1.getIndex(), this.primary.getIndex(), -5.0E-9);
        }

        @Override
        public void setRatio(float ratio) {
            if (this.network != null) {
                float change = ratio - this.ratio;
                this.network.alterConductanceMatrix(this.index, this.primary.getIndex(), change);
                this.network.alterConductanceMatrix(this.primary.getIndex(), this.index, -change);
            }
            this.ratio = ratio;
        }
    }

    private static class Tr2P2S
    extends TransformerCoupling {
        private final IElectricNode primary1;
        private final IElectricNode primary2;
        private final IElectricNode secondary1;
        private final IElectricNode secondary2;

        protected Tr2P2S(float ratio, float resistance, IElectricNode primary1, IElectricNode primary2, IElectricNode secondary1, IElectricNode secondary2) {
            super(ratio, resistance, List.of(primary1, primary2, secondary1, secondary2));
            this.primary1 = primary1;
            this.primary2 = primary2;
            this.secondary1 = secondary1;
            this.secondary2 = secondary2;
        }

        @Override
        public void couple(IAdmittanceAdder admittance) {
            admittance.add(this.index, this.index, -this.resistance);
            admittance.add(this.index, this.primary1.getIndex(), this.ratio);
            admittance.add(this.index, this.primary2.getIndex(), -this.ratio);
            admittance.add(this.index, this.secondary2.getIndex(), 1.0);
            admittance.add(this.index, this.secondary1.getIndex(), -1.0);
            admittance.add(this.secondary2.getIndex(), this.index, 1.0);
            admittance.add(this.secondary1.getIndex(), this.index, -1.0);
            admittance.add(this.primary1.getIndex(), this.index, this.ratio);
            admittance.add(this.primary2.getIndex(), this.index, -this.ratio);
            admittance.add(this.primary2.getIndex(), this.primary2.getIndex(), 5.0E-9);
            admittance.add(this.secondary2.getIndex(), this.secondary2.getIndex(), 5.0E-9);
            admittance.add(this.primary2.getIndex(), this.secondary2.getIndex(), -5.0E-9);
            admittance.add(this.secondary2.getIndex(), this.primary2.getIndex(), -5.0E-9);
            admittance.add(this.primary1.getIndex(), this.primary1.getIndex(), 5.0E-9);
            admittance.add(this.secondary1.getIndex(), this.secondary1.getIndex(), 5.0E-9);
            admittance.add(this.primary1.getIndex(), this.secondary1.getIndex(), -5.0E-9);
            admittance.add(this.secondary1.getIndex(), this.primary1.getIndex(), -5.0E-9);
        }

        @Override
        public void setRatio(float ratio) {
            if (this.network != null) {
                float change = ratio - this.ratio;
                this.network.alterConductanceMatrix(this.index, this.primary1.getIndex(), change);
                this.network.alterConductanceMatrix(this.index, this.primary2.getIndex(), -change);
                this.network.alterConductanceMatrix(this.primary1.getIndex(), this.index, change);
                this.network.alterConductanceMatrix(this.primary2.getIndex(), this.index, -change);
            }
            this.ratio = ratio;
        }
    }
}

