/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.sim.solver;

import org.ejml.data.DMatrixRMaj;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.electricity.sim.PerformanceCounter;
import org.patryk3211.powergrid.electricity.sim.solver.DynamicallyTypedMatrix;
import org.patryk3211.powergrid.electricity.sim.solver.ISolver;

public class DirectSolver
implements ISolver {
    private static final PerformanceCounter PERF = new PerformanceCounter("DirectSolve");
    private DMatrixRMaj x;

    @Override
    public void setStateSize(int size) {
        if (this.x == null || this.x.getNumRows() != size) {
            this.x = new DMatrixRMaj(size, 1);
        }
    }

    @Override
    @Nullable
    public DMatrixRMaj solve(DynamicallyTypedMatrix A, DMatrixRMaj b, boolean acceptAll) {
        PERF.start();
        A.solve(b, this.x);
        PERF.end();
        return this.x;
    }

    @Override
    public DMatrixRMaj getLastGuess() {
        return this.x;
    }

    @Override
    public void zero() {
        if (this.x != null) {
            this.x.zero();
        }
    }

    @Override
    public void setTargetPrecision(double targetPrecision) {
    }
}

