/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.sim.special;

import org.patryk3211.powergrid.electricity.sim.AbstractElectricWire;
import org.patryk3211.powergrid.electricity.sim.node.IElectricNode;
import org.patryk3211.powergrid.electricity.sim.solver.IResidualAdder;
import org.patryk3211.powergrid.electricity.sim.solver.IStaticResidual;

public class CapacitorWire
extends AbstractElectricWire
implements IStaticResidual {
    private double capacitance;
    private double voltageInject;
    private double Ieq;

    public CapacitorWire(double capacitance, IElectricNode node1, IElectricNode node2) {
        super(node1, node2);
        this.capacitance = capacitance;
    }

    @Override
    public double conductance() {
        return 2.0 * this.capacitance / (double)0.05f;
    }

    public void setVoltage(float voltage) {
        this.voltageInject = voltage - this.potentialDifference();
    }

    @Override
    public float current() {
        return (float)((double)super.current() + this.Ieq);
    }

    @Override
    public void addStaticResidual(IResidualAdder residual) {
        double G = this.conductance();
        float V = this.potentialDifference();
        double prevCurrent = G * (double)V + this.Ieq;
        double prevPotential = (double)V + this.voltageInject;
        this.voltageInject = 0.0;
        this.Ieq = (-G * prevPotential - prevCurrent) * 0.99999;
        if (this.node1 != null) {
            residual.add(this.node1.getIndex(), -this.Ieq);
        }
        if (this.node2 != null) {
            residual.add(this.node2.getIndex(), this.Ieq);
        }
    }
}

