/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.sim.special;

import java.util.ArrayList;
import java.util.List;
import org.patryk3211.powergrid.electricity.sim.AbstractElectricWire;
import org.patryk3211.powergrid.electricity.sim.ElectricWire;
import org.patryk3211.powergrid.electricity.sim.ElectricalNetwork;
import org.patryk3211.powergrid.electricity.sim.node.IElectricNode;
import org.patryk3211.powergrid.electricity.sim.special.CapacitorWire;

public abstract class CompoundWire
extends AbstractElectricWire {
    private final List<AbstractElectricWire> wires = new ArrayList<AbstractElectricWire>();
    private double conductance;

    public CompoundWire(IElectricNode node1, IElectricNode node2) {
        super(node1, node2);
    }

    protected <T extends AbstractElectricWire> T addInternalWire(T wire) {
        this.wires.add(wire);
        return wire;
    }

    protected CapacitorWire addInternalCapacitor(double C, IElectricNode node1, IElectricNode node2) {
        return this.addInternalWire(new CapacitorWire(C, node1, node2));
    }

    protected ElectricWire addInternalResistor(double R, IElectricNode node1, IElectricNode node2) {
        return this.addInternalWire(new ElectricWire(R, node1, node2));
    }

    protected ConductanceWire addDynamicWire(IElectricNode node1, IElectricNode node2) {
        return this.addInternalWire(new ConductanceWire(node1, node2));
    }

    @Override
    public double conductance() {
        return this.conductance;
    }

    public void setConductance(double conductance) {
        if (this.network != null) {
            this.network.updateConductance(this, conductance - this.conductance);
        }
        this.conductance = conductance;
    }

    @Override
    public void setNetwork(ElectricalNetwork network) {
        super.setNetwork(network);
        if (network != null) {
            this.wires.forEach(network::addWire);
        } else {
            this.wires.forEach(wire -> {
                wire.remove();
                wire.setNetwork(null);
            });
        }
    }

    @Override
    public void remove() {
        super.remove();
        this.wires.forEach(AbstractElectricWire::remove);
    }

    public static class ConductanceWire
    extends AbstractElectricWire {
        private double conductance;

        public ConductanceWire(IElectricNode node1, IElectricNode node2) {
            super(node1, node2);
        }

        @Override
        public double conductance() {
            return this.conductance;
        }

        public void setConductance(double conductance) {
            if (this.network != null) {
                this.network.updateConductance(this, conductance - this.conductance);
            }
            this.conductance = conductance;
        }
    }
}

