/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.sim.special;

import org.patryk3211.powergrid.electricity.sim.AbstractElectricWire;
import org.patryk3211.powergrid.electricity.sim.node.IElectricNode;
import org.patryk3211.powergrid.electricity.sim.solver.ISolverHook;

public abstract class DynamicConductanceWire
extends AbstractElectricWire
implements ISolverHook {
    protected double currentConductance = 0.0;
    protected double prevConductance = 0.0;

    public DynamicConductanceWire(IElectricNode node1, IElectricNode node2) {
        super(node1, node2);
    }

    protected abstract double calculateConductance();

    @Override
    public double conductance() {
        return this.currentConductance;
    }

    @Override
    public void startIteration() {
        this.currentConductance = this.calculateConductance();
        this.network.updateConductance(this, this.currentConductance - this.prevConductance);
        this.prevConductance = this.currentConductance;
    }
}

