/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.sim.special;

import org.patryk3211.powergrid.electricity.sim.AbstractElectricWire;
import org.patryk3211.powergrid.electricity.sim.node.IElectricNode;
import org.patryk3211.powergrid.electricity.sim.solver.IResidualAdder;
import org.patryk3211.powergrid.electricity.sim.solver.IStaticResidual;

public class InductorWire
extends AbstractElectricWire
implements IStaticResidual {
    private double inductance;
    private double I;
    private double currentInject;

    public InductorWire(double inductance, IElectricNode node1, IElectricNode node2) {
        super(node1, node2);
        this.inductance = inductance;
    }

    @Override
    public double conductance() {
        return 0.05 / (2.0 * this.inductance);
    }

    @Override
    public float current() {
        return (float)((double)super.current() + this.I);
    }

    public void setCurrent(float current) {
        this.currentInject = current - this.current();
    }

    @Override
    public void addStaticResidual(IResidualAdder residual) {
        this.I = ((double)this.potentialDifference() * this.conductance() + (double)this.current()) * 0.99999 + this.currentInject;
        this.currentInject = 0.0;
        if (this.node1 != null) {
            residual.add(this.node1.getIndex(), -this.I);
        }
        if (this.node2 != null) {
            residual.add(this.node2.getIndex(), this.I);
        }
    }

    public void setInductance(float inductance) {
        double oldConductance = this.conductance();
        this.inductance = inductance;
        if (this.network != null) {
            this.network.updateConductance(this, this.conductance() - oldConductance);
        }
    }
}

