/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.socket;

import com.simibubi.create.foundation.block.IBE;
import net.createmod.catnip.math.VoxelShaper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.base.CustomProperties;
import org.patryk3211.powergrid.collections.ModdedBlockEntities;
import org.patryk3211.powergrid.electricity.base.ElectricBlock;
import org.patryk3211.powergrid.electricity.base.IDecoratedTerminal;
import org.patryk3211.powergrid.electricity.base.ISocketElectric;
import org.patryk3211.powergrid.electricity.base.ITerminalPlacement;
import org.patryk3211.powergrid.electricity.base.TerminalBoundingBox;
import org.patryk3211.powergrid.electricity.base.terminals.BlockStateTerminalCollection;
import org.patryk3211.powergrid.electricity.socket.SocketBlockEntity;

public class SocketBlock
extends ElectricBlock
implements IBE<SocketBlockEntity>,
ISocketElectric {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final IntegerProperty ROTATION = CustomProperties.ROTATION_4;
    private final TerminalBoundingBox[] TERMINALS_DOWN = new TerminalBoundingBox[]{new TerminalBoundingBox(IDecoratedTerminal.CONNECTOR, 6.0, 0.0, 3.0, 10.0, 2.0, 4.0).withColor(0xFF3B3B), new TerminalBoundingBox(IDecoratedTerminal.CONNECTOR, 6.0, 0.0, 12.0, 10.0, 2.0, 13.0).withColor(3899647)};
    private final TerminalBoundingBox SOCKET_DOWN = new TerminalBoundingBox(IDecoratedTerminal.SOCKET, 6.0, 3.0, 6.0, 10.0, 5.0, 10.0);
    private final TerminalBoundingBox SOCKET_UP = this.SOCKET_DOWN.rotateAroundX(180);
    private final TerminalBoundingBox SOCKET_NORTH = this.SOCKET_DOWN.rotateAroundX(-90);
    private final TerminalBoundingBox SOCKET_SOUTH = this.SOCKET_DOWN.rotateAroundX(90);
    private final TerminalBoundingBox SOCKET_EAST = this.SOCKET_DOWN.rotateAroundX(90).rotateAroundY(-90);
    private final TerminalBoundingBox SOCKET_WEST = this.SOCKET_DOWN.rotateAroundX(90).rotateAroundY(90);
    private static final VoxelShape SHAPE_DOWN = SocketBlock.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)4.0, (double)12.0);

    public SocketBlock(BlockBehaviour.Properties settings) {
        super(settings);
        VoxelShaper shaper = VoxelShaper.forDirectional((VoxelShape)SHAPE_DOWN, (Direction)Direction.DOWN);
        this.setTerminalCollection(BlockStateTerminalCollection.builder(this).forAllStates(state -> BlockStateTerminalCollection.each(this.TERMINALS_DOWN, terminal -> {
            Direction facing = (Direction)state.m_61143_((Property)FACING);
            terminal = switch (facing) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.DOWN -> terminal;
                case Direction.UP -> terminal.rotateAroundX(180);
                case Direction.EAST -> terminal.rotateAroundZ(-90);
                case Direction.WEST -> terminal.rotateAroundZ(90);
                case Direction.NORTH -> terminal.rotateAroundZ(90).rotateAroundY(90);
                case Direction.SOUTH -> terminal.rotateAroundZ(90).rotateAroundY(-90);
            };
            Integer rotation = (Integer)state.m_61143_((Property)ROTATION);
            terminal = terminal.rotate(facing.m_122434_(), 90 * rotation - 90);
            return terminal;
        })).withShapeMapper(state -> {
            Direction facing = (Direction)state.m_61143_((Property)FACING);
            return shaper.get(facing);
        }).build());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING, ROTATION});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction facing = ctx.m_43719_().m_122424_();
        int rotation = 0;
        if (facing.m_122434_() == Direction.Axis.Y) {
            Direction player = ctx.m_8125_();
            rotation = player.m_122416_();
        } else {
            rotation = 1;
        }
        if (ctx.m_43723_() != null && ctx.m_43723_().m_6144_()) {
            rotation = (rotation + 2) % 3;
        }
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing)).m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(rotation));
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        return SocketBlock.m_49863_((LevelReader)world, (BlockPos)pos.m_5484_(facing, 1), (Direction)facing.m_122424_());
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        return direction == facing && !this.m_7898_(state, (LevelReader)world, pos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    public BlockState getRotatedBlockState(BlockState originalState, Direction targetedFace) {
        if (targetedFace.m_122434_() == ((Direction)originalState.m_61143_((Property)FACING)).m_122434_()) {
            return (BlockState)originalState.m_61122_((Property)ROTATION);
        }
        return super.getRotatedBlockState(originalState, targetedFace);
    }

    public Class<SocketBlockEntity> getBlockEntityClass() {
        return SocketBlockEntity.class;
    }

    public BlockEntityType<? extends SocketBlockEntity> getBlockEntityType() {
        return (BlockEntityType)ModdedBlockEntities.SOCKET.get();
    }

    @Override
    public ITerminalPlacement socket(BlockState state) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> this.SOCKET_DOWN;
            case Direction.UP -> this.SOCKET_UP;
            case Direction.NORTH -> this.SOCKET_NORTH;
            case Direction.SOUTH -> this.SOCKET_SOUTH;
            case Direction.EAST -> this.SOCKET_EAST;
            case Direction.WEST -> this.SOCKET_WEST;
        };
    }
}

