/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.sparkgap;

import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.CenteredSideValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import java.util.List;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.patryk3211.powergrid.electricity.base.ElectricBlockEntity;
import org.patryk3211.powergrid.electricity.base.IElectricEntity;
import org.patryk3211.powergrid.electricity.particles.ZapParticleData;
import org.patryk3211.powergrid.electricity.sim.SwitchedWire;
import org.patryk3211.powergrid.electricity.sparkgap.SparkGapBlock;
import org.patryk3211.powergrid.electricity.sparkgap.SparkGapValueBehaviour;
import org.patryk3211.powergrid.utility.Lang;

public class SparkGapBlockEntity
extends ElectricBlockEntity {
    private SwitchedWire plasmaChannel;
    protected SparkGapValueBehaviour setting;

    public SparkGapBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.setting = new SparkGapValueBehaviour((Component)Lang.translateDirect("devices.spark_gap.voltage", new Object[0]), this, (ValueBoxTransform)new BoxTransform());
        behaviours.add((BlockEntityBehaviour)this.setting);
    }

    public void tick() {
        super.tick();
        if (this.f_58857_.f_46443_ && this.plasmaChannel.getState()) {
            Vec3 center = this.f_58858_.m_252807_().m_82492_(0.0, 0.125, 0.0);
            float offset = (1.0f + (float)(this.setting.getValue() * 3) / 18.0f) / 16.0f;
            Direction.Axis axis = (Direction.Axis)this.m_58900_().m_61143_((Property)SparkGapBlock.HORIZONTAL_AXIS);
            Vec3 end = center.m_231075_(Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE), (double)offset);
            Vec3 start = center.m_231075_(Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE), (double)offset);
            this.f_58857_.m_7106_((ParticleOptions)new ZapParticleData(end.f_82479_, end.f_82480_, end.f_82481_, true).withLife(1).withSegments(5), start.f_82479_, start.f_82480_, start.f_82481_, 0.0, 0.0, 0.0);
        }
        if (!this.plasmaChannel.getState() && Math.abs(this.plasmaChannel.potentialDifference()) > (float)this.setting.getVoltage()) {
            this.plasmaChannel.setState(true);
            this.notifyUpdate();
        } else if (this.plasmaChannel.getState() && Math.abs(this.plasmaChannel.current()) < this.setting.getCurrent()) {
            this.plasmaChannel.setState(false);
            this.notifyUpdate();
        }
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.plasmaChannel.setState(tag.m_128471_("State"));
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.m_128379_("State", this.plasmaChannel.getState());
    }

    @Override
    public void buildCircuit(IElectricEntity.CircuitBuilder builder) {
        builder.setTerminalCount(2);
        this.plasmaChannel = builder.connectSwitch(1.0f, builder.terminalNode(0), builder.terminalNode(1), false);
    }

    public static class BoxTransform
    extends CenteredSideValueBoxTransform {
        public BoxTransform() {
            super((state, dir) -> dir == Direction.UP);
        }

        protected Vec3 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)8.0, (double)8.5);
        }
    }
}

