/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.transformer;

import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.patryk3211.powergrid.collections.ModdedBlockEntities;
import org.patryk3211.powergrid.electricity.base.IDecoratedTerminal;
import org.patryk3211.powergrid.electricity.base.ITerminalPlacement;
import org.patryk3211.powergrid.electricity.base.TerminalBoundingBox;
import org.patryk3211.powergrid.electricity.transformer.TransformerBlock;
import org.patryk3211.powergrid.electricity.transformer.TransformerBlockEntity;
import org.patryk3211.powergrid.electricity.transformer.TransformerMediumBlockEntity;
import org.patryk3211.powergrid.utility.PlayerUtilities;

public class TransformerMediumBlock
extends TransformerBlock
implements IBE<TransformerMediumBlockEntity> {
    public static final EnumProperty<Direction.Axis> HORIZONTAL_AXIS = BlockStateProperties.f_61364_;
    public static final IntegerProperty PART = IntegerProperty.m_61631_((String)"part", (int)0, (int)3);
    private static final TerminalBoundingBox TERMINAL_Z_1 = new TerminalBoundingBox(IDecoratedTerminal.CONNECTOR, 0.0, 9.0, 6.0, 5.0, 16.0, 10.0);
    private static final TerminalBoundingBox TERMINAL_Z_2 = new TerminalBoundingBox(IDecoratedTerminal.CONNECTOR, 11.0, 9.0, 6.0, 16.0, 16.0, 10.0);
    private static final TerminalBoundingBox TERMINAL_X_1 = TERMINAL_Z_1.rotateAroundY(Rotation.CLOCKWISE_90);
    private static final TerminalBoundingBox TERMINAL_X_2 = TERMINAL_Z_2.rotateAroundY(Rotation.CLOCKWISE_90);
    private static final VoxelShape SHAPE_Z_BOTTOM = TransformerMediumBlock.m_49796_((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_X_BOTTOM = TransformerMediumBlock.m_49796_((double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0, (double)14.0);
    private static final VoxelShape SHAPE_Z_TOP = Shapes.m_83124_((VoxelShape)TransformerMediumBlock.m_49796_((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)12.0, (double)16.0), (VoxelShape[])new VoxelShape[]{TERMINAL_Z_1.getShape(), TERMINAL_Z_2.getShape()});
    private static final VoxelShape SHAPE_X_TOP = Shapes.m_83124_((VoxelShape)TransformerMediumBlock.m_49796_((double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)12.0, (double)14.0), (VoxelShape[])new VoxelShape[]{TERMINAL_X_1.getShape(), TERMINAL_X_2.getShape()});

    public TransformerMediumBlock(BlockBehaviour.Properties settings) {
        super(settings, 240);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)COILS, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{HORIZONTAL_AXIS, PART, COILS});
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction.Axis)state.m_61143_(HORIZONTAL_AXIS)) {
            case Direction.Axis.Z -> {
                switch ((Integer)state.m_61143_((Property)PART)) {
                    case 0: 
                    case 1: {
                        yield SHAPE_Z_BOTTOM;
                    }
                    case 2: 
                    case 3: {
                        yield SHAPE_Z_TOP;
                    }
                }
                throw new IllegalStateException();
            }
            case Direction.Axis.X -> {
                switch ((Integer)state.m_61143_((Property)PART)) {
                    case 0: 
                    case 1: {
                        yield SHAPE_X_BOTTOM;
                    }
                    case 2: 
                    case 3: {
                        yield SHAPE_X_TOP;
                    }
                }
                throw new IllegalStateException();
            }
            default -> throw new IllegalStateException();
        };
    }

    public void m_6786_(LevelAccessor world, BlockPos pos, BlockState state) {
        super.m_6786_(world, pos, state);
        Direction.Axis axis = (Direction.Axis)state.m_61143_(HORIZONTAL_AXIS);
        int x = 0;
        int y = 0;
        switch ((Integer)state.m_61143_((Property)PART)) {
            case 0: {
                x = 1;
                y = 1;
                break;
            }
            case 1: {
                x = -1;
                y = 1;
                break;
            }
            case 2: {
                x = 1;
                y = -1;
                break;
            }
            case 3: {
                x = -1;
                y = -1;
            }
        }
        world.m_46961_(pos.m_5487_(axis, x), false);
        world.m_46961_(pos.m_5487_(Direction.Axis.Y, y), false);
        world.m_46961_(pos.m_5487_(axis, x).m_5487_(Direction.Axis.Y, y), false);
    }

    @Override
    public int terminalCount() {
        return 2;
    }

    @Override
    public ITerminalPlacement terminal(BlockState state, int index) {
        Integer part = (Integer)state.m_61143_((Property)PART);
        if (part == 0 || part == 1) {
            return null;
        }
        return switch ((Direction.Axis)state.m_61143_(HORIZONTAL_AXIS)) {
            case Direction.Axis.Z -> {
                switch (index) {
                    case 0: 
                    case 2: {
                        yield TERMINAL_Z_1;
                    }
                    case 1: 
                    case 3: {
                        yield TERMINAL_Z_2;
                    }
                }
                yield null;
            }
            case Direction.Axis.X -> {
                switch (index) {
                    case 0: 
                    case 2: {
                        yield TERMINAL_X_1;
                    }
                    case 1: 
                    case 3: {
                        yield TERMINAL_X_2;
                    }
                }
                yield null;
            }
            default -> null;
        };
    }

    @Override
    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        return InteractionResult.PASS;
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            if (PlayerUtilities.cancelBreak(world, pos, player)) {
                return InteractionResult.SUCCESS;
            }
            Direction.Axis axis = (Direction.Axis)state.m_61143_(HORIZONTAL_AXIS);
            int x = 0;
            int y = 0;
            switch ((Integer)state.m_61143_((Property)PART)) {
                case 0: {
                    x = 1;
                    y = 1;
                    break;
                }
                case 1: {
                    x = -1;
                    y = 1;
                    break;
                }
                case 2: {
                    x = 1;
                    y = -1;
                    break;
                }
                case 3: {
                    x = -1;
                    y = -1;
                }
            }
            if (player != null && !player.m_7500_()) {
                Block.m_49874_((BlockState)state, (ServerLevel)serverLevel, (BlockPos)pos, (BlockEntity)world.m_7702_(pos), (Entity)player, (ItemStack)context.m_43722_()).forEach(itemStack -> player.m_150109_().m_150079_(itemStack));
            }
            state.m_222967_(serverLevel, pos, ItemStack.f_41583_, true);
            BiConsumer<Integer, Integer> processOffset = (offsetX, offsetY) -> {
                BlockPos offsetPos = pos.m_5487_(axis, offsetX.intValue()).m_5487_(Direction.Axis.Y, offsetY.intValue());
                world.m_46961_(offsetPos, false);
            };
            processOffset.accept(0, 0);
            processOffset.accept(x, 0);
            processOffset.accept(0, y);
            processOffset.accept(x, y);
            IWrenchable.playRemoveSound((Level)world, (BlockPos)pos);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public int terminalIndexAt(BlockState state, Vec3 pos) {
        int index = super.terminalIndexAt(state, pos);
        if (index >= 0 && (Integer)state.m_61143_((Property)PART) == 3) {
            return index + 2;
        }
        return index;
    }

    @Override
    public Optional<TransformerBlockEntity> getBlockEntity(Level world, BlockPos pos, BlockState state) {
        Direction.Axis axis = (Direction.Axis)state.m_61143_(HORIZONTAL_AXIS);
        BlockPos bePos = switch ((Integer)state.m_61143_((Property)PART)) {
            case 0 -> pos;
            case 1 -> pos.m_5487_(axis, -1);
            case 2 -> pos.m_5487_(Direction.Axis.Y, -1);
            case 3 -> pos.m_5487_(axis, -1).m_5487_(Direction.Axis.Y, -1);
            default -> throw new IllegalStateException();
        };
        return Optional.ofNullable((TransformerBlockEntity)this.getBlockEntity((BlockGetter)world, bePos));
    }

    @Override
    protected boolean isInitiator(BlockPos pos, BlockState state, BlockPos initiator) {
        int x;
        BlockPos p1 = pos.m_5487_(Direction.Axis.Y, switch ((Integer)state.m_61143_((Property)PART)) {
            case 0 -> {
                x = 1;
                yield 1;
            }
            case 1 -> {
                x = -1;
                yield 1;
            }
            case 2 -> {
                x = 1;
                yield 0;
            }
            case 3 -> {
                x = -1;
                yield 0;
            }
            default -> throw new IllegalStateException();
        });
        BlockPos p2 = p1.m_5487_((Direction.Axis)state.m_61143_(HORIZONTAL_AXIS), x);
        return initiator.equals((Object)p1) || initiator.equals((Object)p2);
    }

    public Class<TransformerMediumBlockEntity> getBlockEntityClass() {
        return TransformerMediumBlockEntity.class;
    }

    public BlockEntityType<? extends TransformerMediumBlockEntity> getBlockEntityType() {
        return (BlockEntityType)ModdedBlockEntities.TRANSFORMER_MEDIUM.get();
    }

    @Override
    public boolean accepts(ItemStack wireStack) {
        return true;
    }
}

