/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.wire;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.patryk3211.powergrid.electricity.GlobalElectricNetworks;
import org.patryk3211.powergrid.electricity.WorldNetworks;
import org.patryk3211.powergrid.electricity.base.ElectricBehaviour;
import org.patryk3211.powergrid.electricity.base.IElectric;
import org.patryk3211.powergrid.electricity.base.ITerminalPlacement;
import org.patryk3211.powergrid.electricity.sim.ElectricalNetwork;
import org.patryk3211.powergrid.electricity.sim.node.INode;
import org.patryk3211.powergrid.electricity.sim.node.OwnedFloatingNode;
import org.patryk3211.powergrid.electricity.wire.BaseWireEntity;
import org.patryk3211.powergrid.electricity.wire.IWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.WireEndpointType;
import org.patryk3211.powergrid.electricity.wire.WireEntity;

public class BlockWireEndpoint
implements IWireEndpoint {
    private BlockPos pos;
    private int terminal;

    public BlockWireEndpoint() {
        this(null, 0);
    }

    public BlockWireEndpoint(BlockPos pos, int terminal) {
        this.pos = pos;
        this.terminal = terminal;
    }

    @Override
    public WireEndpointType type() {
        return WireEndpointType.BLOCK;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public int getTerminal() {
        return this.terminal;
    }

    @Override
    public void read(CompoundTag nbt) {
        int[] posArr = nbt.m_128465_("Pos");
        this.pos = new BlockPos(posArr[0], posArr[1], posArr[2]);
        this.terminal = nbt.m_128451_("Terminal");
    }

    @Override
    public void write(CompoundTag nbt) {
        nbt.m_128385_("Pos", new int[]{this.pos.m_123341_(), this.pos.m_123342_(), this.pos.m_123343_()});
        nbt.m_128405_("Terminal", this.terminal);
    }

    public IElectric getElectricBlock(Level world) {
        if (!world.m_7232_(SectionPos.m_123171_((int)this.pos.m_123341_()), SectionPos.m_123171_((int)this.pos.m_123343_()))) {
            return null;
        }
        return IElectric.getAt(world, this.pos);
    }

    public ElectricBehaviour getElectricBehaviour(Level world) {
        if (!world.m_7232_(SectionPos.m_123171_((int)this.pos.m_123341_()), SectionPos.m_123171_((int)this.pos.m_123343_()))) {
            return null;
        }
        IElectric electric = this.getElectricBlock(world);
        if (electric == null) {
            return null;
        }
        BlockState state = world.m_8055_(this.pos);
        return electric.getBehaviour(world, this.pos, state);
    }

    @Override
    @NotNull
    public Vec3 getExactPosition(Level world) {
        return IElectric.getTerminalPos(world, this.pos, this.terminal);
    }

    @Override
    public OwnedFloatingNode getNode(Level world) {
        ElectricBehaviour behaviour = this.getElectricBehaviour(world);
        if (behaviour == null) {
            WorldNetworks global = GlobalElectricNetworks.getWorldNetworks(world);
            return global.globalExternalNodes.get(this);
        }
        return behaviour.getTerminal(this.terminal);
    }

    @Override
    public void joinNetwork(Level world, ElectricalNetwork network) {
        ElectricBehaviour behaviour = this.getElectricBehaviour(world);
        if (behaviour == null) {
            OwnedFloatingNode node = GlobalElectricNetworks.getWorldNetworks((Level)world).globalExternalNodes.get(this);
            if (node != null) {
                network.addNode((INode)node);
            }
            return;
        }
        behaviour.joinNetwork(network);
    }

    @Override
    public boolean isValid(Level world) {
        if (!world.m_7232_(SectionPos.m_123171_((int)this.pos.m_123341_()), SectionPos.m_123171_((int)this.pos.m_123343_()))) {
            return false;
        }
        ElectricBehaviour behaviour = this.getElectricBehaviour(world);
        if (behaviour == null) {
            return false;
        }
        return behaviour.hasTerminal(this.terminal);
    }

    @Override
    public <T extends BaseWireEntity> boolean canAcceptType(Class<T> clazz) {
        return WireEntity.class.isAssignableFrom(clazz);
    }

    @Override
    public void assignWireEntity(BaseWireEntity entity) {
        ElectricBehaviour behaviour = this.getElectricBehaviour(entity.m_9236_());
        if (behaviour == null) {
            return;
        }
        behaviour.addConnection(this, entity);
    }

    @Override
    public void removeWireEntity(BaseWireEntity entity) {
        ElectricBehaviour behaviour = this.getElectricBehaviour(entity.m_9236_());
        if (behaviour == null) {
            return;
        }
        behaviour.removeConnection(this, entity);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof BlockWireEndpoint) {
            BlockWireEndpoint other = (BlockWireEndpoint)obj;
            return this.pos.equals((Object)other.pos) && this.terminal == other.terminal;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.pos, this.terminal);
    }

    public String toString() {
        return String.format("Block(pos=%s, n=%d)", this.pos, this.terminal);
    }

    public ITerminalPlacement getTerminalPlacement(Level world) {
        IElectric electric = this.getElectricBlock(world);
        BlockState state = world.m_8055_(this.pos);
        return electric.terminal(state, this.terminal);
    }

    @Override
    public IWireEndpoint makeOffset(BlockPos offset) {
        return new BlockWireEndpoint(this.pos.m_121955_((Vec3i)offset), this.terminal);
    }
}

