/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.wire;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.collections.ModdedEntities;
import org.patryk3211.powergrid.collections.ModdedItems;
import org.patryk3211.powergrid.electricity.wire.ClientWireInteractions;
import org.patryk3211.powergrid.electricity.wire.IWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.JunctionWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.WireEntity;
import org.patryk3211.powergrid.electricity.wire.WireItem;
import org.patryk3211.powergrid.utility.BlockTrace;
import org.patryk3211.powergrid.utility.IComplexRaycast;

public class BlockWireEntity
extends WireEntity
implements IComplexRaycast {
    public AABB mainBoundingBox;
    public final List<AABB> boundingBoxes = new ArrayList<AABB>();
    public final List<Point> segments = new ArrayList<Point>();
    private float totalLength = 0.0f;
    private boolean particlesSpawned = false;

    public BlockWireEntity(EntityType<?> type, Level world) {
        super(type, world);
    }

    public static BlockWireEntity create(Level world, IWireEndpoint endpoint1, ItemStack item, List<Point> segments) {
        if (!(item.m_41720_() instanceof WireItem)) {
            throw new IllegalArgumentException("ItemStack must be of a WireItem");
        }
        BlockWireEntity entity = new BlockWireEntity((EntityType)ModdedEntities.BLOCK_WIRE.get(), world);
        entity.setItem((WireItem)item.m_41720_(), item.m_41613_());
        Vec3 pos = BlockTrace.alignPosition(endpoint1.getExactPosition(world));
        entity.m_20343_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        entity.segments.addAll(segments);
        entity.bakeBoundingBoxes();
        entity.setEndpoint1(endpoint1);
        entity.m_146922_(0.0f);
        entity.m_146926_(0.0f);
        entity.m_146867_();
        entity.m_20090_();
        if (entity.getWireItem().canBeColored()) {
            entity.setColor(4275249);
        }
        return entity;
    }

    public static BlockWireEntity create(Level world, Vec3 pos, ItemStack item, List<Point> segments) {
        if (!(item.m_41720_() instanceof WireItem)) {
            throw new IllegalArgumentException("ItemStack must be of a WireItem");
        }
        BlockWireEntity entity = new BlockWireEntity((EntityType)ModdedEntities.BLOCK_WIRE.get(), world);
        entity.setItem((WireItem)item.m_41720_(), item.m_41613_());
        entity.m_20343_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        entity.segments.addAll(segments);
        entity.bakeBoundingBoxes();
        entity.m_146922_(0.0f);
        entity.m_146926_(0.0f);
        entity.m_146867_();
        entity.m_20090_();
        if (entity.getWireItem().canBeColored()) {
            entity.setColor(4275249);
        }
        return entity;
    }

    protected AABB m_142242_() {
        if (this.mainBoundingBox != null) {
            return this.mainBoundingBox.m_82383_(this.m_20182_());
        }
        return super.m_142242_();
    }

    public void bakeBoundingBoxes() {
        this.boundingBoxes.clear();
        this.totalLength = 0.0f;
        Vec3 currentPos = Vec3.f_82478_;
        double minX = 0.0;
        double minY = 0.0;
        double minZ = 0.0;
        double maxX = 0.0;
        double maxY = 0.0;
        double maxZ = 0.0;
        for (Point segment : this.segments) {
            segment.start = currentPos.m_82549_(this.m_20182_());
            Vec3 nextPos = currentPos.m_82549_(segment.vector());
            if (nextPos.f_82479_ > maxX) {
                maxX = nextPos.f_82479_;
            }
            if (nextPos.f_82480_ > maxY) {
                maxY = nextPos.f_82480_;
            }
            if (nextPos.f_82481_ > maxZ) {
                maxZ = nextPos.f_82481_;
            }
            if (nextPos.f_82479_ < minX) {
                minX = nextPos.f_82479_;
            }
            if (nextPos.f_82480_ < minY) {
                minY = nextPos.f_82480_;
            }
            if (nextPos.f_82481_ < minZ) {
                minZ = nextPos.f_82481_;
            }
            this.boundingBoxes.add(new AABB(currentPos, nextPos).m_82400_(0.0625));
            currentPos = nextPos;
            this.totalLength += segment.length();
        }
        this.mainBoundingBox = new AABB(minX, minY, minZ, maxX, maxY, maxZ).m_82400_(0.0625);
        this.m_20011_(this.m_142242_());
    }

    public float getTotalLength() {
        return this.totalLength;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        Level world = this.m_9236_();
        float temperature = this.getTemperature();
        Vec3 pos = this.m_20182_();
        if (this.isOverheated()) {
            if (world.f_46443_ && !this.particlesSpawned) {
                for (Point segment : this.segments) {
                    Vec3 dir = segment.vector();
                    int pointCount = Math.round(segment.length() / 0.25f);
                    for (int i = 0; i < pointCount; ++i) {
                        float r = (float)i / (float)pointCount;
                        double x = segment.start.f_82479_ + dir.f_82479_ * (double)r;
                        double y = segment.start.f_82480_ + dir.f_82480_ * (double)r;
                        double z = segment.start.f_82481_ + dir.f_82481_ * (double)r;
                        world.m_7106_((ParticleOptions)ParticleTypes.f_123744_, x, y, z, 0.0, 0.0, 0.0);
                    }
                }
                this.particlesSpawned = true;
            }
        } else if (temperature >= this.overheatTemperature - 50.0f && world.f_46443_) {
            Point segment = this.segments.get(this.f_19796_.m_188503_(this.segments.size()));
            Vec3 dir = segment.vector();
            float r = this.f_19796_.m_188501_();
            double x = segment.start.f_82479_ + dir.f_82479_ * (double)r;
            double y = segment.start.f_82480_ + dir.f_82480_ * (double)r;
            double z = segment.start.f_82481_ + dir.f_82481_ * (double)r;
            world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 0.0, (double)0.05f, 0.0);
        }
    }

    @Nullable
    public ItemEntity m_5552_(ItemStack stack, float yOffset) {
        if (stack.m_41619_()) {
            return null;
        }
        if (this.m_9236_().f_46443_) {
            return null;
        }
        Vec3 center = this.mainBoundingBox.m_82399_();
        ItemEntity itemEntity = new ItemEntity(this.m_9236_(), this.m_20185_() + center.f_82479_, this.m_20186_() + (double)yOffset + center.f_82480_, this.m_20189_() + center.f_82481_, stack);
        itemEntity.m_32060_();
        this.m_9236_().m_7967_((Entity)itemEntity);
        return itemEntity;
    }

    @Override
    protected void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.segments.clear();
        ListTag segmentList = nbt.m_128437_("Segments", 10);
        for (Tag segment : segmentList) {
            Point point = new Point((CompoundTag)segment);
            this.segments.add(point);
        }
        this.bakeBoundingBoxes();
    }

    @Override
    protected void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        ListTag segmentList = new ListTag();
        for (Point segment : this.segments) {
            segmentList.add((Object)segment.serialize());
        }
        nbt.m_128365_("Segments", (Tag)segmentList);
    }

    @Override
    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (item instanceof WireItem) {
            WireItem wire = (WireItem)item;
            if (player.m_9236_().f_46443_) {
                return ClientWireInteractions.attachWire(this);
            }
            return InteractionResult.CONSUME;
        }
        if (stack.m_41720_() == ModdedItems.WIRE_CUTTER.get()) {
            if (player.m_6144_()) {
                return super.m_6096_(player, hand);
            }
            if (player.m_9236_().f_46443_) {
                return ClientWireInteractions.segmentCut(this);
            }
            return InteractionResult.CONSUME;
        }
        return super.m_6096_(player, hand);
    }

    @Override
    @Nullable
    public Vec3 raycast(Vec3 min, Vec3 max) {
        Vec3 closestHit = null;
        min = min.m_82546_(this.m_20182_());
        max = max.m_82546_(this.m_20182_());
        double distance = max.m_82557_(min);
        for (AABB bb : this.boundingBoxes) {
            double hitDistance;
            Optional hit = bb.m_82371_(min, max);
            if (hit.isEmpty() || !((hitDistance = ((Vec3)hit.get()).m_82557_(min)) < distance)) continue;
            distance = hitDistance;
            closestHit = ((Vec3)hit.get()).m_82549_(this.m_20182_());
        }
        return closestHit;
    }

    @Override
    public void endpointRemoved(IWireEndpoint endpoint) {
        Point removedSegment;
        if (endpoint.equals(this.getEndpoint2())) {
            removedSegment = this.segments.remove(this.segments.size() - 1);
            this.setEndpoint2(null);
        } else if (endpoint.equals(this.getEndpoint1())) {
            removedSegment = this.segments.remove(0);
            this.m_146884_(this.m_20182_().m_82549_(removedSegment.vector()));
            this.setEndpoint1(null);
        } else {
            return;
        }
        int items = (int)removedSegment.length();
        if (items > 0 && !this.m_9236_().f_46443_) {
            Vec3 start = removedSegment.start;
            Vec3 vector = removedSegment.vector();
            if (this.getWireCount() <= items) {
                --items;
            }
            ItemEntity itemEntity = new ItemEntity(this.m_9236_(), start.f_82479_ + vector.f_82479_, start.f_82480_ + vector.f_82480_, start.f_82481_ + vector.f_82481_, new ItemStack((ItemLike)this.getWireItem(), items));
            itemEntity.m_32060_();
            this.m_9236_().m_7967_((Entity)itemEntity);
            this.incrementWireCount(-items);
        }
        this.dropWire();
        this.sendExtraData();
    }

    public BlockWireEntity flip() {
        BlockWireEntity entity = new BlockWireEntity((EntityType)ModdedEntities.BLOCK_WIRE.get(), this.m_9236_());
        entity.setItem(this.getWireItem(), this.getWireCount());
        entity.setEndpoint1(this.getEndpoint2());
        entity.setEndpoint2(this.getEndpoint1());
        entity.m_20088_().m_135381_(TEMPERATURE, (Object)Float.valueOf(this.getTemperature()));
        entity.setColor(this.getColor());
        Vec3 pos = this.m_20182_();
        for (int i = 0; i < this.segments.size(); ++i) {
            Point segment = this.segments.get(i);
            pos = pos.m_82549_(segment.vector());
            Direction dir = segment.direction.m_122424_();
            int length = segment.gridLength;
            if (length <= 0) continue;
            entity.segments.add(0, new Point(dir, length));
        }
        entity.m_20343_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        entity.bakeBoundingBoxes();
        entity.m_146922_(0.0f);
        entity.m_146926_(0.0f);
        entity.m_146867_();
        entity.m_20090_();
        this.m_146870_();
        ServerLevel serverWorld = (ServerLevel)this.m_9236_();
        serverWorld.m_8860_((Entity)entity);
        return entity;
    }

    public void extend(List<Point> points, int newItems, boolean notify) {
        if (this.m_9236_().f_46443_) {
            return;
        }
        this.incrementWireCount(newItems);
        this.segments.addAll(points);
        this.bakeBoundingBoxes();
        if (notify) {
            this.sendExtraData();
        }
    }

    public void extend(List<Point> points, int newItems) {
        this.extend(points, newItems, true);
    }

    public JunctionWireEndpoint split(int segmentIndex, int segmentPoint) {
        Level world = this.m_9236_();
        if (world.f_46443_) {
            return null;
        }
        Point segment = this.segments.get(segmentIndex);
        Vec3 junctionPos = segment.start.m_231075_(segment.direction, (double)((float)segmentPoint / 16.0f));
        JunctionWireEndpoint junction = new JunctionWireEndpoint(junctionPos);
        BlockWireEntity wire2 = new BlockWireEntity((EntityType)ModdedEntities.BLOCK_WIRE.get(), world);
        wire2.setColor(this.getColor());
        wire2.setItem(this.getWireItem(), 0);
        Point splitSegment = new Point(segment.direction, segment.gridLength - segmentPoint);
        wire2.segments.add(splitSegment);
        this.segments.set(segmentIndex, new Point(segment.direction, segmentPoint - 1));
        float movedLength = splitSegment.length();
        int removeCount = this.segments.size() - segmentIndex - 1;
        for (int i = 0; i < removeCount; ++i) {
            Point removed = this.segments.remove(segmentIndex + 1);
            wire2.segments.add(removed);
            movedLength += removed.length();
        }
        wire2.m_20343_(junctionPos.f_82479_, junctionPos.f_82480_, junctionPos.f_82481_);
        wire2.bakeBoundingBoxes();
        this.bakeBoundingBoxes();
        wire2.m_146922_(0.0f);
        wire2.m_146926_(0.0f);
        wire2.m_146867_();
        wire2.m_20090_();
        int items = (int)movedLength;
        wire2.incrementWireCount(items);
        wire2.m_20088_().m_135381_(TEMPERATURE, (Object)Float.valueOf(this.getTemperature()));
        wire2.setEndpoint2(this.getEndpoint2());
        wire2.setEndpoint1(junction);
        this.setEndpoint2(junction);
        ServerLevel serverWorld = (ServerLevel)world;
        serverWorld.m_8860_((Entity)wire2);
        this.sendExtraData();
        return junction;
    }

    public static class Point {
        public Vec3 start;
        public final Direction direction;
        public final int gridLength;

        public Point(Direction direction, int gridLength) {
            this.direction = direction;
            this.gridLength = gridLength;
        }

        public Point(CompoundTag tag) {
            this.direction = Direction.m_122376_((int)tag.m_128451_("Direction"));
            this.gridLength = tag.m_128451_("Length");
        }

        public CompoundTag serialize() {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("Direction", this.direction.m_122411_());
            tag.m_128405_("Length", this.gridLength);
            return tag;
        }

        public float length() {
            return (float)this.gridLength / 16.0f;
        }

        public Vec3 vector() {
            float length = this.length();
            return switch (this.direction) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.EAST -> new Vec3((double)length, 0.0, 0.0);
                case Direction.WEST -> new Vec3((double)(-length), 0.0, 0.0);
                case Direction.UP -> new Vec3(0.0, (double)length, 0.0);
                case Direction.DOWN -> new Vec3(0.0, (double)(-length), 0.0);
                case Direction.SOUTH -> new Vec3(0.0, 0.0, (double)length);
                case Direction.NORTH -> new Vec3(0.0, 0.0, (double)(-length));
            };
        }

        public static Point x(float length) {
            return new Point(length >= 0.0f ? Direction.EAST : Direction.WEST, (int)(Math.abs(length) * 16.0f));
        }

        public static Point y(float length) {
            return new Point(length >= 0.0f ? Direction.UP : Direction.DOWN, (int)(Math.abs(length) * 16.0f));
        }

        public static Point z(float length) {
            return new Point(length >= 0.0f ? Direction.SOUTH : Direction.NORTH, (int)(Math.abs(length) * 16.0f));
        }
    }
}

