/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.wire;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.patryk3211.powergrid.electricity.wire.CurveParameters;
import org.patryk3211.powergrid.electricity.wire.HangingWireEntity;

@OnlyIn(value=Dist.CLIENT)
public class HangingWireRenderer
extends EntityRenderer<HangingWireEntity> {
    public static final boolean RAINBOW_WIRES = false;
    public static final double SEGMENT_SIZE = 0.5;

    public HangingWireRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    @NotNull
    public ResourceLocation getTextureLocation(HangingWireEntity entity) {
        return entity.getWireItem().getWireTexture();
    }

    public void render(HangingWireEntity entity, float yaw, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light) {
        if (entity.renderParams == null) {
            return;
        }
        if (entity.isOverheated()) {
            return;
        }
        VertexConsumer buffer = Minecraft.m_91405_() ? vertexConsumers.m_6299_(RenderType.m_110452_((ResourceLocation)this.getTextureLocation(entity))) : vertexConsumers.m_6299_(RenderType.m_110458_((ResourceLocation)this.getTextureLocation(entity)));
        assert (entity.renderParams instanceof CurveParameters);
        CurveParameters rp = (CurveParameters)entity.renderParams;
        float thicknessOffset = (float)entity.m_19879_() / 16.0f;
        int color = entity.getColor() | 0xFF000000;
        Vec3 pos = entity.m_20182_();
        Level world = entity.m_9236_();
        rp.runForSegments((x1, y1, z1, x2, y2, z2, offset, length) -> {
            BlockPos blockPos = BlockPos.m_274561_((double)((double)(x1 + x2) * 0.5 + pos.f_82479_), (double)((double)(y1 + y2) * 0.5 + pos.f_82480_), (double)((double)(z1 + z2) * 0.5 + pos.f_82481_));
            int sky = world.m_45517_(LightLayer.SKY, blockPos);
            int block = world.m_45517_(LightLayer.BLOCK, blockPos);
            HangingWireRenderer.renderSegment(matrices, buffer, x1, y1, z1, x2, y2, z2, rp.cross1, rp.cross2, LightTexture.m_109885_((int)block, (int)sky), color, rp.thickness, thicknessOffset, length, offset);
        });
    }

    public static void renderFromPositions(PoseStack matrices, VertexConsumer buffer, Vec3 t1, Vec3 t2, double horizontalCoefficient, double verticalCoefficient, double thickness, int light, int color) {
        float x = (float)(t1.f_82479_ + t2.f_82479_) * 0.5f;
        float y = (float)t1.f_82480_;
        float z = (float)(t1.f_82481_ + t2.f_82481_) * 0.5f;
        CurveParameters curve = new CurveParameters(t1, t2, horizontalCoefficient, verticalCoefficient, thickness);
        curve.runForSegments((x1, y1, z1, x2, y2, z2, offset, length) -> HangingWireRenderer.renderSegment(matrices, buffer, x1 + x, y1 + y, z1 + z, x2 + x, y2 + y, z2 + z, curve.cross1, curve.cross2, light, color, curve.thickness, 0.0f, length, offset));
    }

    public static void renderFromPositions(PoseStack matrices, VertexConsumer buffer, Vec3 t1, Vec3 t2, double horizontalCoefficient, double verticalCoefficient, double thickness, BlockAndTintGetter lightProvider, int color) {
        float x = (float)(t1.f_82479_ + t2.f_82479_) * 0.5f;
        float y = (float)t1.f_82480_;
        float z = (float)(t1.f_82481_ + t2.f_82481_) * 0.5f;
        CurveParameters curve = new CurveParameters(t1, t2, horizontalCoefficient, verticalCoefficient, thickness);
        curve.runForSegments((x1, y1, z1, x2, y2, z2, offset, length) -> {
            BlockPos blockPos = BlockPos.m_274561_((double)((double)(x1 + x2) * 0.5 + (double)x), (double)((double)(y1 + y2) * 0.5 + (double)y), (double)((double)(z1 + z2) * 0.5 + (double)z));
            int sky = lightProvider.m_45517_(LightLayer.SKY, blockPos);
            int block = lightProvider.m_45517_(LightLayer.BLOCK, blockPos);
            HangingWireRenderer.renderSegment(matrices, buffer, x1 + x, y1 + y, z1 + z, x2 + x, y2 + y, z2 + z, curve.cross1, curve.cross2, LightTexture.m_109885_((int)block, (int)sky), color, curve.thickness, 0.0f, length, offset);
        });
    }

    public static void renderSegment(PoseStack ms, VertexConsumer buffer, float x1, float y1, float z1, float x2, float y2, float z2, Vec3 cross1, Vec3 cross2, int light, int color, float thickness, float thicknessOffset, float uvLength, float lengthOffset) {
        if (!Minecraft.m_91405_()) {
            HangingWireRenderer.quad(ms.m_85850_(), buffer, light, color, (double)x1 + cross1.f_82479_, (double)y1 + cross1.f_82480_, (double)z1 + cross1.f_82481_, (double)x1 - cross1.f_82479_, (double)y1 - cross1.f_82480_, (double)z1 - cross1.f_82481_, (double)x2 + cross1.f_82479_, (double)y2 + cross1.f_82480_, (double)z2 + cross1.f_82481_, (double)x2 - cross1.f_82479_, (double)y2 - cross1.f_82480_, (double)z2 - cross1.f_82481_, thickness, thicknessOffset, uvLength, lengthOffset);
            HangingWireRenderer.quad(ms.m_85850_(), buffer, light, color, (double)x1 + cross2.f_82479_, (double)y1 + cross2.f_82480_, (double)z1 + cross2.f_82481_, (double)x1 - cross2.f_82479_, (double)y1 - cross2.f_82480_, (double)z1 - cross2.f_82481_, (double)x2 + cross2.f_82479_, (double)y2 + cross2.f_82480_, (double)z2 + cross2.f_82481_, (double)x2 - cross2.f_82479_, (double)y2 - cross2.f_82480_, (double)z2 - cross2.f_82481_, thickness, thicknessOffset, uvLength, lengthOffset);
        } else {
            HangingWireRenderer.quad(ms.m_85850_(), buffer, light, color, (double)x1 + cross1.f_82479_, (double)y1 + cross1.f_82480_, (double)z1 + cross1.f_82481_, (double)x1 - cross2.f_82479_, (double)y1 - cross2.f_82480_, (double)z1 - cross2.f_82481_, (double)x2 + cross1.f_82479_, (double)y2 + cross1.f_82480_, (double)z2 + cross1.f_82481_, (double)x2 - cross2.f_82479_, (double)y2 - cross2.f_82480_, (double)z2 - cross2.f_82481_, cross1.f_82479_ - cross2.f_82479_, cross1.f_82480_ - cross2.f_82480_, cross1.f_82481_ - cross2.f_82481_, thickness, thicknessOffset, uvLength, lengthOffset);
            HangingWireRenderer.quad(ms.m_85850_(), buffer, light, color, (double)x1 - cross1.f_82479_, (double)y1 - cross1.f_82480_, (double)z1 - cross1.f_82481_, (double)x1 + cross2.f_82479_, (double)y1 + cross2.f_82480_, (double)z1 + cross2.f_82481_, (double)x2 - cross1.f_82479_, (double)y2 - cross1.f_82480_, (double)z2 - cross1.f_82481_, (double)x2 + cross2.f_82479_, (double)y2 + cross2.f_82480_, (double)z2 + cross2.f_82481_, cross2.f_82479_ - cross1.f_82479_, cross2.f_82480_ - cross1.f_82480_, cross2.f_82481_ - cross1.f_82481_, thickness, thicknessOffset, uvLength, lengthOffset);
            HangingWireRenderer.quad(ms.m_85850_(), buffer, light, color, (double)x1 + cross2.f_82479_, (double)y1 + cross2.f_82480_, (double)z1 + cross2.f_82481_, (double)x1 + cross1.f_82479_, (double)y1 + cross1.f_82480_, (double)z1 + cross1.f_82481_, (double)x2 + cross2.f_82479_, (double)y2 + cross2.f_82480_, (double)z2 + cross2.f_82481_, (double)x2 + cross1.f_82479_, (double)y2 + cross1.f_82480_, (double)z2 + cross1.f_82481_, cross1.f_82479_ + cross2.f_82479_, cross1.f_82480_ + cross2.f_82480_, cross1.f_82481_ + cross2.f_82481_, thickness, thicknessOffset, uvLength, lengthOffset);
            HangingWireRenderer.quad(ms.m_85850_(), buffer, light, color, (double)x1 - cross2.f_82479_, (double)y1 - cross2.f_82480_, (double)z1 - cross2.f_82481_, (double)x1 - cross1.f_82479_, (double)y1 - cross1.f_82480_, (double)z1 - cross1.f_82481_, (double)x2 - cross2.f_82479_, (double)y2 - cross2.f_82480_, (double)z2 - cross2.f_82481_, (double)x2 - cross1.f_82479_, (double)y2 - cross1.f_82480_, (double)z2 - cross1.f_82481_, -cross1.f_82479_ - cross2.f_82479_, -cross1.f_82480_ - cross2.f_82480_, -cross1.f_82481_ - cross2.f_82481_, thickness, thicknessOffset, uvLength, lengthOffset);
            HangingWireRenderer.quad(ms.m_85850_(), buffer, light, color, (double)x1 + cross1.f_82479_, (double)y1 + cross1.f_82480_, (double)z1 + cross1.f_82481_, (double)x1 + cross2.f_82479_, (double)y1 + cross2.f_82480_, (double)z1 + cross2.f_82481_, (double)x1 - cross2.f_82479_, (double)y1 - cross2.f_82480_, (double)z1 - cross2.f_82481_, (double)x1 - cross1.f_82479_, (double)y1 - cross1.f_82480_, (double)z1 - cross1.f_82481_, x1 - x2, y1 - y2, z1 - z2, thickness, thicknessOffset, thickness, thicknessOffset);
            HangingWireRenderer.quad(ms.m_85850_(), buffer, light, color, (double)x2 + cross1.f_82479_, (double)y2 + cross1.f_82480_, (double)z2 + cross1.f_82481_, (double)x2 + cross2.f_82479_, (double)y2 + cross2.f_82480_, (double)z2 + cross2.f_82481_, (double)x2 - cross2.f_82479_, (double)y2 - cross2.f_82480_, (double)z2 - cross2.f_82481_, (double)x2 - cross1.f_82479_, (double)y2 - cross1.f_82480_, (double)z2 - cross1.f_82481_, x2 - x1, y2 - y1, z2 - z1, thickness, thicknessOffset, thickness, thicknessOffset);
        }
    }

    public static void quad(PoseStack.Pose matrix, VertexConsumer buffer, int light, int color, double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3, double x4, double y4, double z4, float thickness, float thicknessOffset, float uvLength, float lengthOffset) {
        buffer.m_252986_(matrix.m_252922_(), (float)x1, (float)y1, (float)z1).m_193479_(color).m_7421_(lengthOffset, thicknessOffset).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix.m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix.m_252922_(), (float)x2, (float)y2, (float)z2).m_193479_(color).m_7421_(lengthOffset, thicknessOffset + thickness).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix.m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix.m_252922_(), (float)x4, (float)y4, (float)z4).m_193479_(color).m_7421_(lengthOffset + uvLength, thicknessOffset + thickness).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix.m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix.m_252922_(), (float)x3, (float)y3, (float)z3).m_193479_(color).m_7421_(lengthOffset + uvLength, thicknessOffset).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix.m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public static void quad(PoseStack.Pose matrix, VertexConsumer buffer, int light, int color, double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3, double x4, double y4, double z4, double nX, double nY, double nZ, float thickness, float thicknessOffset, float uvLength, float lengthOffset) {
        double nLen = Math.sqrt(nX * nX + nY * nY + nZ * nZ);
        buffer.m_252986_(matrix.m_252922_(), (float)x1, (float)y1, (float)z1).m_193479_(color).m_7421_(lengthOffset, thicknessOffset).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix.m_252943_(), (float)(nX /= nLen), (float)(nY /= nLen), (float)(nZ /= nLen)).m_5752_();
        buffer.m_252986_(matrix.m_252922_(), (float)x2, (float)y2, (float)z2).m_193479_(color).m_7421_(lengthOffset, thicknessOffset + thickness).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix.m_252943_(), (float)nX, (float)nY, (float)nZ).m_5752_();
        buffer.m_252986_(matrix.m_252922_(), (float)x4, (float)y4, (float)z4).m_193479_(color).m_7421_(lengthOffset + uvLength, thicknessOffset + thickness).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix.m_252943_(), (float)nX, (float)nY, (float)nZ).m_5752_();
        buffer.m_252986_(matrix.m_252922_(), (float)x3, (float)y3, (float)z3).m_193479_(color).m_7421_(lengthOffset + uvLength, thicknessOffset).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix.m_252943_(), (float)nX, (float)nY, (float)nZ).m_5752_();
    }
}

