/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.wire;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.patryk3211.powergrid.electricity.info.Current;
import org.patryk3211.powergrid.electricity.info.IHaveElectricProperties;
import org.patryk3211.powergrid.electricity.info.Range;
import org.patryk3211.powergrid.electricity.info.Resistance;

public interface IWire
extends IHaveElectricProperties {
    public float getResistance();

    public float getMaximumLength();

    public float getDissipationFactor();

    public float getThermalMass();

    public boolean canBeColored();

    @Override
    default public void appendProperties(ItemStack stack, Player player, List<Component> tooltip) {
        Resistance.series(this.getResistance(), player, tooltip);
        Current.max(this.getResistance(), this.getDissipationFactor() * 150.0f, player, tooltip);
        Range.max((int)this.getMaximumLength(), tooltip);
    }

    public static boolean holdsWire(Player player) {
        ItemStack stack1 = player.m_21205_();
        if (stack1 != null && !stack1.m_41619_() && stack1.m_41720_() instanceof IWire) {
            return true;
        }
        ItemStack stack2 = player.m_21206_();
        return stack2 != null && !stack2.m_41619_() && stack2.m_41720_() instanceof IWire;
    }
}

