/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.wire;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.patryk3211.powergrid.electricity.sim.ElectricalNetwork;
import org.patryk3211.powergrid.electricity.sim.node.OwnedFloatingNode;
import org.patryk3211.powergrid.electricity.wire.BaseWireEntity;
import org.patryk3211.powergrid.electricity.wire.WireEndpointType;

public interface IWireEndpoint {
    public WireEndpointType type();

    public void read(CompoundTag var1);

    public void write(CompoundTag var1);

    @NotNull
    public Vec3 getExactPosition(Level var1);

    default public boolean isValid(Level world) {
        return true;
    }

    default public <T extends BaseWireEntity> boolean canAcceptType(Class<T> clazz) {
        return false;
    }

    default public OwnedFloatingNode getNode(Level world) {
        throw new IllegalStateException("Cannot fetch node");
    }

    default public void joinNetwork(Level world, ElectricalNetwork network) {
        throw new IllegalStateException("Cannot join network");
    }

    default public void assignWireEntity(BaseWireEntity entity) {
        throw new IllegalStateException("Cannot assign a wire entity");
    }

    default public void removeWireEntity(BaseWireEntity entity) {
        throw new IllegalStateException("Cannot remove a wire entity");
    }

    default public CompoundTag serialize() {
        return this.type().serialize(this);
    }

    default public IWireEndpoint makeOffset(BlockPos offset) {
        return null;
    }
}

