/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.wire;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.AllSpecialTextures;
import java.util.List;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.outliner.Outliner;
import net.createmod.catnip.render.BindableTexture;
import net.createmod.catnip.render.SuperRenderTypeBuffer;
import net.createmod.catnip.theme.Color;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.electricity.base.IElectric;
import org.patryk3211.powergrid.electricity.base.ITerminalPlacement;
import org.patryk3211.powergrid.electricity.wire.BlockWireEntity;
import org.patryk3211.powergrid.electricity.wire.BlockWireEntityEndpoint;
import org.patryk3211.powergrid.electricity.wire.BlockWireRenderer;
import org.patryk3211.powergrid.electricity.wire.HangingWireRenderer;
import org.patryk3211.powergrid.electricity.wire.IWire;
import org.patryk3211.powergrid.electricity.wire.IWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.WireEndpointType;
import org.patryk3211.powergrid.electricity.wire.WireItem;
import org.patryk3211.powergrid.electricity.wire.powercord.CordItem;
import org.patryk3211.powergrid.electricity.wire.powercord.CordRenderer;
import org.patryk3211.powergrid.electricity.wire.powercord.ICordEndpoint;
import org.patryk3211.powergrid.utility.BlockTrace;
import org.patryk3211.powergrid.utility.Lang;
import org.patryk3211.powergrid.utility.PlacementOverlay;

@OnlyIn(value=Dist.CLIENT)
public class WirePreview {
    private static final boolean DEBUG_BLOCK_TRACING = false;
    public static final Object outlineSlot = new Object();

    @Nullable
    public static ItemStack getUsedWireStack(Player player) {
        ItemStack stack1 = player.m_21205_();
        ItemStack stack2 = player.m_21206_();
        if (stack1 != null && stack1.m_41720_() instanceof IWire && stack1.m_41782_()) {
            return stack1;
        }
        if (stack2 != null && stack2.m_41720_() instanceof IWire && stack2.m_41782_()) {
            return stack2;
        }
        return null;
    }

    private static void renderCord(SuperRenderTypeBuffer buffer, PoseStack matrixStack, ClientLevel world, LocalPlayer player, HitResult target, ItemStack wireStack) {
        IWireEndpoint endpoint = WireEndpointType.deserialize(wireStack.m_41783_());
        if (!(endpoint instanceof ICordEndpoint)) {
            return;
        }
        ICordEndpoint cordEndpoint = (ICordEndpoint)endpoint;
        CordRenderer.renderPreview(cordEndpoint, player.m_7398_(AnimationTickHolder.getPartialTicks()), matrixStack, (MultiBufferSource)buffer, (Level)world, (CordItem)wireStack.m_41720_(), -12501967);
    }

    public static void render(SuperRenderTypeBuffer buffer, PoseStack matrixStack, ClientLevel world, LocalPlayer player, HitResult target) {
        boolean isBlockWire;
        BlockWireEntityEndpoint bwe;
        BlockWireEntity entity;
        ItemStack wireStack = WirePreview.getUsedWireStack((Player)player);
        if (wireStack == null) {
            return;
        }
        Item item = wireStack.m_41720_();
        if (!(item instanceof WireItem)) {
            return;
        }
        WireItem wireItem = (WireItem)item;
        if (wireStack.m_41720_() instanceof CordItem) {
            WirePreview.renderCord(buffer, matrixStack, world, player, target, wireStack);
            return;
        }
        if (target.m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        CompoundTag tag = wireStack.m_41783_();
        VertexConsumer consumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)wireItem.getWireTexture()));
        float thickness = wireItem.getWireThickness();
        IWireEndpoint endpoint = WireEndpointType.deserialize(tag);
        if (endpoint == null) {
            return;
        }
        Vec3 currentPos = endpoint.getExactPosition((Level)world);
        Direction continueDir = null;
        if (endpoint instanceof BlockWireEntityEndpoint && (entity = (bwe = (BlockWireEntityEndpoint)endpoint).getEntity((Level)world)) != null) {
            List<BlockWireEntity.Point> segments = entity.segments;
            if (segments.isEmpty()) {
                return;
            }
            if (bwe.getEnd()) {
                BlockWireEntity.Point last = segments.get(segments.size() - 1);
                continueDir = last.direction;
            } else {
                BlockWireEntity.Point first = segments.get(0);
                continueDir = first.direction.m_122424_();
            }
        }
        Vec3 hitPoint = target.m_82450_();
        ITerminalPlacement hitTerminal = null;
        if (target.m_6662_() == HitResult.Type.BLOCK) {
            BlockPos pos;
            ITerminalPlacement terminal;
            BlockHitResult blockTarget = (BlockHitResult)target;
            BlockState state = world.m_8055_(blockTarget.m_82425_());
            IElectric electric = IElectric.getAt((Level)world, blockTarget.m_82425_());
            if (electric != null && (terminal = electric.terminalAt(state, hitPoint.m_82492_((double)(pos = blockTarget.m_82425_()).m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()))) != null) {
                hitPoint = terminal.getOrigin().m_82520_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
                hitTerminal = terminal;
            }
        }
        float length = 0.0f;
        boolean bl = isBlockWire = endpoint.type() != WireEndpointType.BLOCK;
        if (isBlockWire || hitTerminal == null) {
            BlockTrace.TraceResult points;
            Pair<BlockTrace.TraceState, BlockTrace.TraceResult> output = BlockTrace.findPathWithState((Level)world, currentPos = BlockTrace.alignPosition(currentPos), hitPoint, hitTerminal, continueDir);
            if (output != null && (points = (BlockTrace.TraceResult)output.getSecond()) != null) {
                for (BlockWireEntity.Point p : points.points()) {
                    Vec3 nextPos = currentPos.m_82549_(p.vector());
                    int color = points.reachedTarget() ? -2136277078 : -2130728278;
                    BlockWireRenderer.renderSegment(matrixStack, consumer, 0xF000F0, color, currentPos, p.direction, thickness, p.length(), 0);
                    currentPos = nextPos;
                    length += p.length();
                }
            }
        } else {
            length = (float)currentPos.m_82554_(hitPoint);
            int color = length < wireItem.getMaximumLength() ? -2136277078 : -2130728278;
            HangingWireRenderer.renderFromPositions(matrixStack, consumer, currentPos, hitPoint, 1.01, 1.2, (double)thickness, 0xF000F0, color);
        }
        if (!player.m_7500_()) {
            int requiredItemCount = Math.max(Math.round(length), 1);
            PlacementOverlay.setItemRequirement(wireStack.m_41720_(), requiredItemCount, wireStack.m_41613_() >= requiredItemCount);
        }
    }

    public static Component distanceOverlay(Player player) {
        ItemStack wireStack = WirePreview.getUsedWireStack(player);
        if (wireStack == null) {
            return null;
        }
        Item item = wireStack.m_41720_();
        if (!(item instanceof WireItem)) {
            return null;
        }
        WireItem wire = (WireItem)item;
        CompoundTag tag = wireStack.m_41783_();
        IWireEndpoint endpoint = WireEndpointType.deserialize(tag);
        if (endpoint == null) {
            return null;
        }
        Vec3 currentPos = endpoint.getExactPosition(player.m_9236_());
        HitResult target = Minecraft.m_91087_().f_91077_;
        if (target == null || target.m_6662_() != HitResult.Type.BLOCK) {
            return null;
        }
        Vec3 hitPoint = target.m_82450_();
        double distance = hitPoint.m_82554_(currentPos);
        return Lang.translate("gui.endpoint_distance", new Object[0]).add(Lang.numberConstant(distance).style(distance < (double)wire.getMaximumLength() ? ChatFormatting.GREEN : ChatFormatting.RED)).style(ChatFormatting.WHITE).component();
    }

    public static void notifyOfBlock(BlockPos pos) {
        Outliner.getInstance().showAABB(outlineSlot, new AABB(pos), 50).colored(Color.RED.brighter()).withFaceTexture((BindableTexture)AllSpecialTextures.CHECKERED).lineWidth(0.05f);
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)AllSoundEvents.DENY.getMainEvent(), (float)1.0f));
    }
}

