/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.wire.powercord;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.electricity.wire.BlockWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.IWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.WireEndpointType;
import org.patryk3211.powergrid.electricity.wire.powercord.ICordEndpoint;

public class AutoCordEndpoint
implements ICordEndpoint {
    private BlockPos pos;
    private int terminal1;
    private int terminal2;
    private Vec3 placement;
    private Direction plugFacing;

    public AutoCordEndpoint() {
        this(null, -1, -1, null, null);
    }

    public AutoCordEndpoint(BlockPos pos, int terminal1, int terminal2, Vec3 placement, @Nullable Direction plugFacing) {
        this.pos = pos;
        this.terminal1 = terminal1;
        this.terminal2 = terminal2;
        this.placement = placement;
        this.plugFacing = plugFacing;
    }

    @Override
    public IWireEndpoint makeOffset(BlockPos offset) {
        return new AutoCordEndpoint(this.pos.m_121955_((Vec3i)offset), this.terminal1, this.terminal2, this.placement.m_82520_((double)offset.m_123341_(), (double)offset.m_123342_(), (double)offset.m_123343_()), this.plugFacing);
    }

    @Override
    public BlockWireEndpoint getEndpoint1() {
        return new BlockWireEndpoint(this.pos, this.terminal1);
    }

    @Override
    public BlockWireEndpoint getEndpoint2() {
        return new BlockWireEndpoint(this.pos, this.terminal2);
    }

    @Override
    public WireEndpointType type() {
        return WireEndpointType.AUTO_CORD;
    }

    @Override
    public void read(CompoundTag nbt) {
        this.pos = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("Position"));
        this.terminal1 = nbt.m_128451_("Terminal1");
        this.terminal2 = nbt.m_128451_("Terminal2");
        this.placement = new Vec3((double)nbt.m_128457_("X"), (double)nbt.m_128457_("Y"), (double)nbt.m_128457_("Z"));
        this.plugFacing = nbt.m_128441_("Plug") ? Direction.values()[nbt.m_128445_("Plug")] : null;
    }

    @Override
    public void write(CompoundTag nbt) {
        nbt.m_128365_("Position", (Tag)NbtUtils.m_129224_((BlockPos)this.pos));
        nbt.m_128405_("Terminal1", this.terminal1);
        nbt.m_128405_("Terminal2", this.terminal2);
        nbt.m_128350_("X", (float)this.placement.f_82479_);
        nbt.m_128350_("Y", (float)this.placement.f_82480_);
        nbt.m_128350_("Z", (float)this.placement.f_82481_);
        if (this.plugFacing != null) {
            nbt.m_128344_("Plug", (byte)this.plugFacing.ordinal());
        }
    }

    @Override
    @NotNull
    public Vec3 getExactPosition(Level world) {
        return this.placement;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AutoCordEndpoint) {
            AutoCordEndpoint other = (AutoCordEndpoint)obj;
            return Objects.equals(this.pos, other.pos) && this.terminal1 == other.terminal1 && this.terminal2 == other.terminal2;
        }
        return false;
    }

    public BlockPos getPosition() {
        return this.pos;
    }

    @Nullable
    public Direction getPlugFacing() {
        return this.plugFacing;
    }
}

