/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.wire.powercord;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.patryk3211.powergrid.PowerGrid;
import org.patryk3211.powergrid.electricity.base.ElectricBehaviour;
import org.patryk3211.powergrid.electricity.base.IElectric;
import org.patryk3211.powergrid.electricity.base.ISocketElectric;
import org.patryk3211.powergrid.electricity.sim.node.OwnedFloatingNode;
import org.patryk3211.powergrid.electricity.wire.BlockWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.IWire;
import org.patryk3211.powergrid.electricity.wire.IWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.WireEndpointType;
import org.patryk3211.powergrid.electricity.wire.WireItem;
import org.patryk3211.powergrid.electricity.wire.powercord.CordEntity;
import org.patryk3211.powergrid.electricity.wire.powercord.IAcceptCord;
import org.patryk3211.powergrid.electricity.wire.powercord.ICordEndpoint;
import org.patryk3211.powergrid.electricity.wire.powercord.ICordPlacementHandler;
import org.patryk3211.powergrid.electricity.wire.powercord.SplitCordEndpoint;
import org.patryk3211.powergrid.utility.Lang;
import org.patryk3211.powergrid.utility.PlayerUtilities;

public class CordItem
extends WireItem {
    public static final List<ICordPlacementHandler> PLACEMENT_HANDLERS = new ArrayList<ICordPlacementHandler>();

    public CordItem(Item.Properties settings) {
        super(settings);
    }

    private static InteractionResult connect(ICordEndpoint endpoint1, ICordEndpoint endpoint2, UseOnContext context) {
        Level level = context.m_43725_();
        if (!endpoint1.isValid(level) || !endpoint2.isValid(level)) {
            IElectric.sendMessage(context, (Component)Lang.translate("message.connection_failed", new Object[0]).style(ChatFormatting.RED).component());
            PowerGrid.LOGGER.error("Connection failed, at least one endpoint is not valid");
            return InteractionResult.FAIL;
        }
        OwnedFloatingNode node1 = endpoint1.getEndpoint1().getNode(level);
        OwnedFloatingNode node2 = endpoint2.getEndpoint1().getNode(level);
        if (node1 == null || node2 == null || node1 == node2) {
            IElectric.sendMessage(context, (Component)Lang.translate("message.connection_failed", new Object[0]).style(ChatFormatting.RED).component());
            PowerGrid.LOGGER.error("Connection failed, nodes: ({}, {})", (Object)node1, (Object)node2);
            return InteractionResult.FAIL;
        }
        node1 = endpoint1.getEndpoint2().getNode(level);
        node2 = endpoint2.getEndpoint2().getNode(level);
        if (node1 == null || node2 == null || node1 == node2) {
            IElectric.sendMessage(context, (Component)Lang.translate("message.connection_failed", new Object[0]).style(ChatFormatting.RED).component());
            PowerGrid.LOGGER.error("Connection failed, nodes: ({}, {})", (Object)node1, (Object)node2);
            return InteractionResult.FAIL;
        }
        IWireEndpoint e11 = endpoint1.getEndpoint1();
        IWireEndpoint e21 = endpoint2.getEndpoint1();
        if (e11 instanceof BlockWireEndpoint) {
            BlockWireEndpoint be1 = (BlockWireEndpoint)e11;
            if (e21 instanceof BlockWireEndpoint) {
                BlockWireEndpoint be2 = (BlockWireEndpoint)e21;
                ElectricBehaviour behaviour1 = be1.getElectricBehaviour(level);
                ElectricBehaviour behaviour2 = be2.getElectricBehaviour(level);
                if (behaviour1.hasConnection(be1, be2) || behaviour2.hasConnection(be2, be1)) {
                    IElectric.sendMessage(context, (Component)Lang.translate("message.connection_exists", new Object[0]).style(ChatFormatting.RED).component());
                    return InteractionResult.FAIL;
                }
            }
        }
        IWireEndpoint e12 = endpoint1.getEndpoint2();
        IWireEndpoint e22 = endpoint2.getEndpoint2();
        if (e12 instanceof BlockWireEndpoint) {
            BlockWireEndpoint be1 = (BlockWireEndpoint)e12;
            if (e22 instanceof BlockWireEndpoint) {
                BlockWireEndpoint be2 = (BlockWireEndpoint)e22;
                ElectricBehaviour behaviour1 = be1.getElectricBehaviour(level);
                ElectricBehaviour behaviour2 = be2.getElectricBehaviour(level);
                if (behaviour1.hasConnection(be1, be2) || behaviour2.hasConnection(be2, be1)) {
                    IElectric.sendMessage(context, (Component)Lang.translate("message.connection_exists", new Object[0]).style(ChatFormatting.RED).component());
                    return InteractionResult.FAIL;
                }
            }
        }
        Vec3 terminal1Pos = endpoint1.getExactPosition(level);
        Vec3 terminal2Pos = endpoint2.getExactPosition(level);
        ItemStack stack = context.m_43722_();
        assert (stack.m_41720_() instanceof IWire);
        IWire item = (IWire)stack.m_41720_();
        CompoundTag tag = stack.m_41783_();
        assert (tag != null);
        float distance = (float)terminal1Pos.m_82554_(terminal2Pos);
        if (distance > item.getMaximumLength()) {
            IElectric.sendMessage(context, (Component)Lang.translate("message.connection_too_long", new Object[0]).style(ChatFormatting.RED).component());
            return InteractionResult.FAIL;
        }
        int requiredItemCount = Math.max(Math.round(distance), 1);
        if (!PlayerUtilities.hasEnoughItems(context.m_43723_(), stack, requiredItemCount)) {
            IElectric.sendMessage(context, (Component)Lang.translate("message.connection_missing_items", new Object[0]).style(ChatFormatting.RED).component());
            return InteractionResult.FAIL;
        }
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        ServerLevel serverWorld = (ServerLevel)level;
        CordEntity entity = CordEntity.create((Level)serverWorld, endpoint1, endpoint2, new ItemStack(stack.m_220173_(), requiredItemCount), null);
        if (context.m_43723_() != null) {
            Item item2;
            ItemStack offItem = context.m_43723_().m_21206_();
            if (item.canBeColored() && (item2 = offItem.m_41720_()) instanceof DyeItem) {
                DyeItem dye = (DyeItem)item2;
                entity.setColor(dye.m_41089_());
            }
        }
        if (!serverWorld.m_8860_((Entity)entity)) {
            PowerGrid.LOGGER.error("Failed to spawn new connection wire entity.");
            IElectric.sendMessage(context, (Component)Lang.translate("message.connection_failed", new Object[0]).style(ChatFormatting.RED).component());
            return InteractionResult.FAIL;
        }
        if (context.m_43723_() == null || !context.m_43723_().m_7500_()) {
            stack.m_41774_(requiredItemCount);
        }
        return InteractionResult.SUCCESS;
    }

    private static InteractionResult addEndpoint(UseOnContext context, ICordEndpoint endpoint) {
        ItemStack stack = context.m_43722_();
        IWireEndpoint firstPoint = WireEndpointType.deserialize(stack.m_41783_());
        if (firstPoint == null) {
            stack.m_41751_(endpoint.serialize());
            IElectric.sendMessage(context, (Component)Lang.translate("message.cord_next", new Object[0]).style(ChatFormatting.GRAY).component());
            return InteractionResult.SUCCESS;
        }
        if (firstPoint instanceof ICordEndpoint) {
            ICordEndpoint firstCordPoint = (ICordEndpoint)firstPoint;
            InteractionResult result = CordItem.connect(firstCordPoint, endpoint, context);
            stack.m_41751_(null);
            return result;
        }
        IElectric.sendMessage(context, (Component)Lang.translate("message.connection_failed", new Object[0]).style(ChatFormatting.RED).component());
        stack.m_41751_(null);
        return InteractionResult.FAIL;
    }

    @Override
    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        BlockState state = context.m_43725_().m_8055_(context.m_8083_());
        IElectric electric = IElectric.getAt(context.m_43725_(), context.m_8083_());
        if (electric != null) {
            ItemStack stack = context.m_43722_();
            BlockPos pos = context.m_8083_();
            int terminal = electric.terminalIndexAt(state, context.m_43720_().m_82492_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()));
            if (terminal >= 0) {
                if (stack.m_41782_() && stack.m_41783_().m_128441_("Half")) {
                    IWireEndpoint endpointHalf = WireEndpointType.deserialize(stack.m_41737_("Half"));
                    if (!(endpointHalf instanceof BlockWireEndpoint)) {
                        return InteractionResult.FAIL;
                    }
                    BlockWireEndpoint bwe = (BlockWireEndpoint)endpointHalf;
                    BlockWireEndpoint endpoint2 = new BlockWireEndpoint(pos, terminal);
                    Vec3 p1 = endpointHalf.getExactPosition(context.m_43725_());
                    Vec3 p2 = endpoint2.getExactPosition(context.m_43725_());
                    if (p1.m_82557_(p2) > 4.0) {
                        IElectric.sendMessage(context, (Component)Lang.translate("message.split_cord_too_far", new Object[0]).style(ChatFormatting.RED).component());
                        return InteractionResult.FAIL;
                    }
                    SplitCordEndpoint splitEndpoint = new SplitCordEndpoint(bwe, endpoint2);
                    return CordItem.addEndpoint(context, splitEndpoint);
                }
                BlockWireEndpoint endpoint = new BlockWireEndpoint(pos, terminal);
                CompoundTag tag = endpoint.serialize();
                stack.m_41784_().m_128365_("Half", (Tag)tag);
                IElectric.sendMessage(context, (Component)Lang.translate("message.connection_next", new Object[0]).style(ChatFormatting.GRAY).component());
                return InteractionResult.SUCCESS;
            }
        }
        for (ICordPlacementHandler handler : PLACEMENT_HANDLERS) {
            InteractionResultHolder<ICordEndpoint> result = handler.place(state, context);
            if (result.m_19089_() == InteractionResult.PASS) continue;
            if (result.m_19089_().m_19077_()) {
                return CordItem.addEndpoint(context, (ICordEndpoint)result.m_19095_());
            }
            return result.m_19089_();
        }
        return InteractionResult.PASS;
    }

    static {
        PLACEMENT_HANDLERS.add(new ISocketElectric.Handler());
        PLACEMENT_HANDLERS.add(new IAcceptCord.Handler());
    }
}

