/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.wire.powercord;

import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.electricity.base.IDecoratedTerminal;
import org.patryk3211.powergrid.electricity.base.ITerminalPlacement;
import org.patryk3211.powergrid.electricity.base.TerminalBoundingBox;
import org.patryk3211.powergrid.electricity.wire.powercord.AutoCordEndpoint;
import org.patryk3211.powergrid.electricity.wire.powercord.ICordEndpoint;
import org.patryk3211.powergrid.electricity.wire.powercord.ICordPlacementHandler;

public interface IAcceptCord {
    default public boolean renderPlug() {
        return false;
    }

    @Nullable
    default public AutoCordEndpoint getEndpoint(UseOnContext context) {
        if (!this.renderPlug()) {
            return new AutoCordEndpoint(context.m_8083_(), 0, 1, context.m_43720_(), null);
        }
        Direction facing = context.m_43719_();
        Vec3 loc = context.m_43720_();
        loc = loc.m_231075_(facing, 0.1875);
        return new AutoCordEndpoint(context.m_8083_(), 0, 1, loc, facing);
    }

    @Nullable
    default public ITerminalPlacement cordTerminal(BlockState state, Level level, BlockHitResult hit) {
        if (!this.renderPlug()) {
            VoxelShape shape = state.m_60808_((BlockGetter)level, hit.m_82425_());
            AABB bb = shape.m_83215_();
            return new TerminalBoundingBox(IDecoratedTerminal.CORD, bb);
        }
        Direction facing = hit.m_82434_();
        Vec3 loc = hit.m_82450_().m_82546_(Vec3.m_82528_((Vec3i)hit.m_82425_())).m_82490_(16.0);
        Vec3 size = switch (facing.m_122434_()) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> new Vec3(1.0, 1.5, 1.5);
            case Direction.Axis.Y -> new Vec3(1.5, 1.0, 1.5);
            case Direction.Axis.Z -> new Vec3(1.5, 1.5, 1.0);
        };
        return new TerminalBoundingBox(IDecoratedTerminal.CORD, loc.f_82479_ - size.f_82479_, loc.f_82480_ - size.f_82480_, loc.f_82481_ - size.f_82481_, loc.f_82479_ + size.f_82479_, loc.f_82480_ + size.f_82480_, loc.f_82481_ + size.f_82481_);
    }

    public static class Handler
    implements ICordPlacementHandler {
        @Override
        @NotNull
        public InteractionResultHolder<ICordEndpoint> place(BlockState state, UseOnContext context) {
            IAcceptCord cordAcceptor;
            AutoCordEndpoint endpoint;
            Block block = state.m_60734_();
            if (block instanceof IAcceptCord && (endpoint = (cordAcceptor = (IAcceptCord)block).getEndpoint(context)) != null) {
                return InteractionResultHolder.m_19090_((Object)endpoint);
            }
            return InteractionResultHolder.m_19098_(null);
        }

        @Override
        @Nullable
        public ITerminalPlacement terminal(BlockState state, Level level, BlockHitResult hit) {
            Block block = state.m_60734_();
            if (block instanceof IAcceptCord) {
                IAcceptCord cordAcceptor = (IAcceptCord)block;
                return cordAcceptor.cordTerminal(state, level, hit);
            }
            return null;
        }
    }
}

