/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.equipment.portablebattery;

import com.simibubi.create.AllEnchantments;
import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.patryk3211.powergrid.collections.ModdedConfigs;
import org.patryk3211.powergrid.equipment.portablebattery.PortableBatteryItem;
import org.patryk3211.powergrid.utility.ClientSideAccess;

public class BatteryUtils {
    public static int getMaxCharge(ItemStack stack) {
        return BatteryUtils.getMaxCharge(EnchantmentHelper.m_44843_((Enchantment)((Enchantment)AllEnchantments.CAPACITY.get()), (ItemStack)stack));
    }

    public static int getMaxCharge(int level) {
        return (Integer)ModdedConfigs.server().electricity.portableBatteryBaseCapacity.get() + (Integer)ModdedConfigs.server().electricity.portableBatteryEnchantCapacity.get() * level;
    }

    public static int getCurrentCharge(ItemStack stack) {
        if (!stack.m_41782_()) {
            return 0;
        }
        CompoundTag nbt = stack.m_41783_();
        return nbt.m_128451_("Charge");
    }

    public static boolean drawEnergy(Player player, int fe) {
        if (player.m_150110_().f_35937_) {
            return true;
        }
        ItemStack stack = player.m_6844_(EquipmentSlot.CHEST);
        if (stack.m_41619_() || !(stack.m_41720_() instanceof PortableBatteryItem)) {
            return false;
        }
        int charge = BatteryUtils.getCurrentCharge(stack);
        if (charge < fe) {
            return false;
        }
        stack.m_41783_().m_128405_("Charge", charge - fe);
        return true;
    }

    public static ItemStack getBattery(Player player) {
        ItemStack stack = player.m_6844_(EquipmentSlot.CHEST);
        if (!(stack.m_41720_() instanceof PortableBatteryItem)) {
            return null;
        }
        return stack;
    }

    public static boolean isBarVisible(ItemStack stack, int fePerUse) {
        if (fePerUse == 0) {
            return false;
        }
        return EnvExecutor.getInEnv((Env)Env.CLIENT, () -> ClientSideAccess::player).map(player -> {
            ItemStack battery = BatteryUtils.getBattery(player);
            if (battery != null && BatteryUtils.getCurrentCharge(battery) >= fePerUse) {
                return true;
            }
            return stack.m_41768_();
        }).orElse(false);
    }

    public static int getBarWidth(ItemStack stack, int fePerUse) {
        if (fePerUse == 0) {
            return 13;
        }
        return EnvExecutor.getInEnv((Env)Env.CLIENT, () -> ClientSideAccess::player).map(player -> {
            ItemStack battery = BatteryUtils.getBattery(player);
            if (battery == null || BatteryUtils.getCurrentCharge(battery) < fePerUse) {
                return Math.round(13.0f - (float)stack.m_41773_() / (float)stack.m_41776_() * 13.0f);
            }
            return battery.m_150948_();
        }).orElse(13);
    }

    public static int getBarColor(ItemStack stack, int fePerUse) {
        if (fePerUse == 0) {
            return 0;
        }
        return EnvExecutor.getInEnv((Env)Env.CLIENT, () -> ClientSideAccess::player).map(player -> {
            ItemStack battery = BatteryUtils.getBattery(player);
            if (battery == null || BatteryUtils.getCurrentCharge(battery) < fePerUse) {
                return Mth.m_14169_((float)(Math.max(0.0f, 1.0f - (float)stack.m_41773_() / (float)stack.m_41776_()) / 3.0f), (float)1.0f, (float)1.0f);
            }
            return battery.m_150949_();
        }).orElse(0);
    }
}

