/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.equipment.portablebattery;

import com.simibubi.create.AllEnchantments;
import com.simibubi.create.api.schematic.requirement.SpecialBlockItemRequirement;
import com.simibubi.create.content.equipment.armor.BacktankItem;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.simibubi.create.foundation.block.IBE;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.patryk3211.powergrid.collections.ModdedBlockEntities;
import org.patryk3211.powergrid.collections.ModdedConfigs;
import org.patryk3211.powergrid.electricity.base.HorizontalElectricBlock;
import org.patryk3211.powergrid.electricity.base.IDecoratedTerminal;
import org.patryk3211.powergrid.electricity.base.TerminalBoundingBox;
import org.patryk3211.powergrid.electricity.base.terminals.BlockStateTerminalCollection;
import org.patryk3211.powergrid.electricity.wire.IWire;
import org.patryk3211.powergrid.equipment.portablebattery.BatteryUtils;
import org.patryk3211.powergrid.equipment.portablebattery.PortableBatteryBlockEntity;
import org.patryk3211.powergrid.utility.PlayerUtilities;

public class PortableBatteryBlock
extends HorizontalElectricBlock
implements IBE<PortableBatteryBlockEntity>,
SpecialBlockItemRequirement {
    private static final VoxelShape SHAPE = Shapes.m_83110_((VoxelShape)PortableBatteryBlock.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)9.0, (double)12.0), (VoxelShape)PortableBatteryBlock.m_49796_((double)5.0, (double)9.0, (double)5.0, (double)11.0, (double)12.0, (double)11.0));
    private static final TerminalBoundingBox[] TERMINALS_NORTH = new TerminalBoundingBox[]{new TerminalBoundingBox(IDecoratedTerminal.CONNECTOR, 4.5, 9.5, 6.5, 6.5, 12.5, 9.5), new TerminalBoundingBox(IDecoratedTerminal.CONNECTOR, 9.5, 9.5, 6.5, 11.5, 12.5, 9.5)};

    public PortableBatteryBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.setTerminalCollection(BlockStateTerminalCollection.builder(this).forAllStates(state -> BlockStateTerminalCollection.each(TERMINALS_NORTH, terminal -> terminal.rotateAroundY((int)(180.0f - ((Direction)state.m_61143_((Property)HORIZONTAL_FACING)).m_122435_())))).withShapeMapper(state -> SHAPE).build());
    }

    public int capacity() {
        return (Integer)ModdedConfigs.server().electricity.portableBatteryBaseCapacity.get();
    }

    public Class<PortableBatteryBlockEntity> getBlockEntityClass() {
        return PortableBatteryBlockEntity.class;
    }

    public BlockEntityType<? extends PortableBatteryBlockEntity> getBlockEntityType() {
        return (BlockEntityType)ModdedBlockEntities.PORTABLE_BATTERY.get();
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        List stacks = super.m_49635_(state, builder);
        return stacks;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (player == null) {
            return InteractionResult.PASS;
        }
        if (PlayerUtilities.isFake(player)) {
            return InteractionResult.PASS;
        }
        if (player.m_6144_()) {
            return InteractionResult.PASS;
        }
        Item heldItem = player.m_21205_().m_41720_();
        if (heldItem instanceof BlockItem || heldItem instanceof IWire) {
            return InteractionResult.PASS;
        }
        if (!player.m_6844_(EquipmentSlot.CHEST).m_41619_()) {
            return InteractionResult.PASS;
        }
        if (!world.f_46443_) {
            world.m_5594_(null, pos, SoundEvents.f_12019_, SoundSource.PLAYERS, 0.75f, 1.0f);
            player.m_8061_(EquipmentSlot.CHEST, this.m_7397_((BlockGetter)world, pos, state));
            world.m_46961_(pos, false);
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.m_6402_(worldIn, pos, state, placer, stack);
        if (worldIn.f_46443_) {
            return;
        }
        if (stack == null) {
            return;
        }
        this.withBlockEntityDo((BlockGetter)worldIn, pos, be -> {
            int level = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)AllEnchantments.CAPACITY.get()), (ItemStack)stack);
            be.setCapacityEnchantLevel(level);
            be.setCharge(BatteryUtils.getCurrentCharge(stack));
            CompoundTag vanillaTag = stack.m_41784_();
            if (stack.m_41788_()) {
                be.setName(stack.m_41786_());
            }
            be.setTags(vanillaTag);
            be.m_6596_();
        });
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        return this.getBlockEntityOptional((BlockGetter)world, pos).map(PortableBatteryBlockEntity::getComparatorOutput).orElse(0);
    }

    public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
        return false;
    }

    public ItemStack m_7397_(BlockGetter world, BlockPos pos, BlockState state) {
        Item item = this.m_5456_();
        if (item instanceof BacktankItem.BacktankBlockItem) {
            BacktankItem.BacktankBlockItem placeable = (BacktankItem.BacktankBlockItem)item;
            item = placeable.getActualItem();
        }
        Optional be = this.getBlockEntityOptional(world, pos);
        CompoundTag vanillaTag = be.map(PortableBatteryBlockEntity::getVanillaTag).orElse(new CompoundTag());
        Integer charge = be.map(PortableBatteryBlockEntity::getCharge).orElse(0);
        ItemStack stack = new ItemStack((ItemLike)item, 1);
        vanillaTag.m_128405_("Charge", charge.intValue());
        stack.m_41751_(vanillaTag);
        return stack;
    }

    public ItemRequirement getRequiredItems(BlockState state, BlockEntity blockEntity) {
        Item item = this.m_5456_();
        if (item instanceof BacktankItem.BacktankBlockItem) {
            BacktankItem.BacktankBlockItem placeable = (BacktankItem.BacktankBlockItem)item;
            item = placeable.getActualItem();
        }
        return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, item);
    }
}

