/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.equipment.zapper;

import com.simibubi.create.content.equipment.zapper.ShootableGadgetItemMethods;
import com.simibubi.create.foundation.item.CustomArmPoseItem;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.PowerGridClient;
import org.patryk3211.powergrid.collections.ModdedConfigs;
import org.patryk3211.powergrid.collections.ModdedPackets;
import org.patryk3211.powergrid.equipment.portablebattery.BatteryUtils;
import org.patryk3211.powergrid.equipment.zapper.ElectroZapperS2CPacket;
import org.patryk3211.powergrid.equipment.zapper.ZapProjectileEntity;
import org.patryk3211.powergrid.utility.Lang;

public class ElectroZapperItem
extends ProjectileWeaponItem
implements CustomArmPoseItem {
    public static final int MAX_DAMAGE = 50;

    public ElectroZapperItem(Item.Properties settings) {
        super(settings.m_41503_(50));
    }

    public Predicate<ItemStack> m_6437_() {
        return $ -> false;
    }

    public boolean isZapper(ItemStack stack) {
        return stack.m_41720_() instanceof ElectroZapperItem;
    }

    public int m_6615_() {
        return 15;
    }

    public boolean m_6777_(BlockState state, Level world, BlockPos pos, Player miner) {
        return false;
    }

    public boolean m_142522_(ItemStack stack) {
        return BatteryUtils.isBarVisible(stack, ElectroZapperItem.fePerUse());
    }

    public int m_142158_(ItemStack stack) {
        return BatteryUtils.getBarWidth(stack, ElectroZapperItem.fePerUse());
    }

    public int m_142159_(ItemStack stack) {
        return BatteryUtils.getBarColor(stack, ElectroZapperItem.fePerUse());
    }

    public static int fePerUse() {
        return (Integer)ModdedConfigs.server().electricity.electroZapperFePerShot.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void clientUse(InteractionHand hand) {
        PowerGridClient.ELECTRO_ZAPPER_RENDER_HANDLER.dontAnimateItem(hand);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        ItemStack stack = user.m_21120_(hand);
        if (world.f_46443_) {
            ElectroZapperItem.clientUse(hand);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        Vec3 barrelPos = ShootableGadgetItemMethods.getGunBarrelVec((Player)user, (hand == InteractionHand.MAIN_HAND ? 1 : 0) != 0, (Vec3)new Vec3(0.25, (double)-0.15f, 1.0));
        Vec3 correction = ShootableGadgetItemMethods.getGunBarrelVec((Player)user, (hand == InteractionHand.MAIN_HAND ? 1 : 0) != 0, (Vec3)new Vec3(0.0, 0.0, 0.0)).m_82546_(user.m_20182_().m_82520_(0.0, (double)user.m_20192_(), 0.0));
        Vec3 lookVec = user.m_20154_();
        Vec3 motion = lookVec.m_82549_(correction).m_82541_().m_82490_(4.0);
        ZapProjectileEntity projectile = ZapProjectileEntity.create(world, barrelPos, motion, (float)lookVec.f_82480_, (float)lookVec.f_82479_);
        projectile.m_5602_((Entity)user);
        world.m_7967_((Entity)projectile);
        ShootableGadgetItemMethods.applyCooldown((Player)user, (ItemStack)stack, (InteractionHand)hand, this::isZapper, (int)10);
        Function<Boolean, ElectroZapperS2CPacket> factory = b -> new ElectroZapperS2CPacket(barrelPos, lookVec.m_82541_(), stack, hand, 1.0f, (boolean)b);
        ModdedPackets.sendToClientsTracking(factory.apply(false), (Entity)user);
        ModdedPackets.sendToClient(factory.apply(true), (ServerPlayer)user);
        if (!BatteryUtils.drawEnergy(user, ElectroZapperItem.fePerUse())) {
            stack.m_41622_(1, (LivingEntity)user, $ -> {});
        }
        return InteractionResultHolder.m_19090_((Object)user.m_21120_(hand));
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag context) {
        tooltip.add((Component)Component.m_237119_());
        tooltip.add((Component)Component.m_237115_((String)"powergrid.electrozapper.bolt").m_7220_((Component)Component.m_237113_((String)":")).m_130940_(ChatFormatting.GRAY));
        MutableComponent spacing = Component.m_237113_((String)" ");
        float damageF = 8.0f;
        MutableComponent damage = Component.m_237113_((String)(damageF == (float)Mth.m_14143_((float)damageF) ? "" + Mth.m_14143_((float)damageF) : "" + damageF));
        MutableComponent reloadTicks = Component.m_237113_((String)"10");
        tooltip.add((Component)spacing.m_6879_().m_7220_((Component)Lang.translateDirect("electrozapper.bolt.damage", damage).m_130940_(ChatFormatting.DARK_GREEN)));
        tooltip.add((Component)spacing.m_6879_().m_7220_((Component)Lang.translateDirect("electrozapper.bolt.reload", reloadTicks).m_130940_(ChatFormatting.DARK_GREEN)));
        super.m_7373_(stack, world, tooltip, context);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable HumanoidModel.ArmPose getArmPose(ItemStack stack, AbstractClientPlayer player, InteractionHand hand) {
        if (!player.f_20911_) {
            return HumanoidModel.ArmPose.CROSSBOW_HOLD;
        }
        return null;
    }

    public boolean onEntitySwing(ItemStack itemStack, LivingEntity livingEntity) {
        return true;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || newStack.m_41720_() != oldStack.m_41720_();
    }
}

