/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.equipment.zapper;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.patryk3211.powergrid.PowerGrid;
import org.patryk3211.powergrid.equipment.zapper.ZapProjectileEntity;

@OnlyIn(value=Dist.CLIENT)
public class ZapProjectileRenderer
extends EntityRenderer<ZapProjectileEntity> {
    public static final ResourceLocation TEXTURE = PowerGrid.texture("entity/zap_projectile");

    public ZapProjectileRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    public void render(ZapProjectileEntity entity, float yaw, float tickDelta, PoseStack matrices, MultiBufferSource consumers, int light) {
        VertexConsumer buffer = consumers.m_6299_(RenderType.m_110446_((ResourceLocation)this.getTextureLocation(entity)));
        Matrix3f normalMatrix = matrices.m_85850_().m_252943_();
        PoseTransformStack stack = TransformStack.of((PoseStack)matrices);
        stack.pushPose();
        stack.translate(0.0f, 0.125f, 0.0f);
        stack.rotateYDegrees(-yaw);
        stack.rotateXDegrees(-entity.m_5686_(tickDelta));
        float UNIT = 0.0625f;
        float HALF_UNIT = 0.03125f;
        for (int i = 0; i < 4; ++i) {
            stack.rotateZDegrees(90.0f);
            Matrix4f positionMatrix = matrices.m_85850_().m_252922_();
            light = 0xF000F0;
            this.vertex(positionMatrix, normalMatrix, buffer, -0.03125f, -0.03125f, -0.15625f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, light);
            this.vertex(positionMatrix, normalMatrix, buffer, -0.03125f, -0.03125f, 0.15625f, 0.3125f, 0.0f, 0.0f, 0.0f, 1.0f, light);
            this.vertex(positionMatrix, normalMatrix, buffer, 0.03125f, 0.03125f, 0.15625f, 0.3125f, 0.0625f, 0.0f, 0.0f, 1.0f, light);
            this.vertex(positionMatrix, normalMatrix, buffer, 0.03125f, 0.03125f, -0.15625f, 0.0f, 0.0625f, 0.0f, 0.0f, 1.0f, light);
        }
        stack.popPose();
    }

    public ResourceLocation getTextureLocation(ZapProjectileEntity entity) {
        return TEXTURE;
    }

    public void vertex(Matrix4f positionMatrix, Matrix3f normalMatrix, VertexConsumer vertexConsumer, float x, float y, float z, float u, float v, float normalX, float normalZ, float normalY, int light) {
        vertexConsumer.m_252986_(positionMatrix, x, y, z).m_6122_(255, 255, 255, 255).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normalMatrix, normalX, normalY, normalZ).m_5752_();
    }
}

