/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.kinetics.generator.inductionrotor;

import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableObject;
import org.patryk3211.powergrid.collections.ModdedConfigs;
import org.patryk3211.powergrid.config.ResistanceValues;
import org.patryk3211.powergrid.electricity.GlobalElectricNetworks;
import org.patryk3211.powergrid.electricity.base.ElectricBehaviour;
import org.patryk3211.powergrid.electricity.base.IElectricEntity;
import org.patryk3211.powergrid.electricity.base.ProxyElectricBehaviour;
import org.patryk3211.powergrid.electricity.base.ThermalBehaviour;
import org.patryk3211.powergrid.electricity.particles.SparkParticleData;
import org.patryk3211.powergrid.electricity.sim.AbstractElectricWire;
import org.patryk3211.powergrid.electricity.sim.node.VoltageSourceCoupling;
import org.patryk3211.powergrid.electricity.sim.special.GeneratorCoupling;
import org.patryk3211.powergrid.electricity.sim.special.TransmissionLinePart;
import org.patryk3211.powergrid.kinetics.generator.inductionrotor.IBrushPlacement;
import org.patryk3211.powergrid.kinetics.generator.inductionrotor.InductionRotorBlockEntity;
import org.patryk3211.powergrid.kinetics.generator.rotor.RotorBlockEntity;

public class CommutatorBlockEntity
extends RotorBlockEntity
implements IElectricEntity {
    protected ElectricBehaviour electricBehaviour;
    protected ThermalBehaviour thermalBehaviour;
    protected GeneratorCoupling source;
    private float resistance = 0.0f;
    private boolean updateBehaviour = true;
    private final Set<InductionRotorBlockEntity> rotors = new HashSet<InductionRotorBlockEntity>();

    public CommutatorBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    @Override
    public float inertia() {
        return ModdedConfigs.server().kinetics.generatorControls.generatorCommutatorInertia.getF();
    }

    @Override
    public void buildCircuit(IElectricEntity.CircuitBuilder builder) {
        builder.setTerminalCount(2);
        this.source = builder.addInternalNode(GeneratorCoupling.class, builder.terminalNode(0), builder.terminalNode(1), Float.valueOf(this.resistance), this.rotorBehaviour);
    }

    private void assemblyChanged() {
        this.source = null;
        this.updateBehaviour = true;
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.rotorBehaviour.setChangeCallback(this::assemblyChanged);
    }

    protected void applyPower(AbstractElectricWire wire) {
        if (this.thermalBehaviour != null) {
            this.thermalBehaviour.applyWirePower(wire);
        }
    }

    @Override
    public void remove() {
        super.remove();
        if (this.electricBehaviour != null) {
            this.electricBehaviour.remove();
        }
    }

    public VoltageSourceCoupling getAssemblySource() {
        ElectricBehaviour electricBehaviour = this.electricBehaviour;
        if (electricBehaviour instanceof ProxyElectricBehaviour) {
            ProxyElectricBehaviour proxy = (ProxyElectricBehaviour)electricBehaviour;
            Optional<ElectricBehaviour> opt = proxy.getMainBehaviour();
            if (opt.isEmpty()) {
                return null;
            }
            SmartBlockEntity smartBlockEntity = opt.get().blockEntity;
            if (smartBlockEntity instanceof CommutatorBlockEntity) {
                CommutatorBlockEntity commutator = (CommutatorBlockEntity)smartBlockEntity;
                return commutator.source;
            }
            return null;
        }
        return this.source;
    }

    public float getCurrent() {
        return -this.getAssemblySource().getCurrent();
    }

    public float getPower() {
        VoltageSourceCoupling source = this.getAssemblySource();
        return -source.getCurrent() * source.getVoltage();
    }

    public void tick() {
        assert (this.f_58857_ != null);
        super.tick();
        if (this.updateBehaviour) {
            this.rotors.clear();
            this.resistance = 0.0f;
            MutableObject proxyTarget = new MutableObject(null);
            this.rotorBehaviour.forEachSegment(segment -> {
                SmartBlockEntity patt0$temp = segment.blockEntity;
                if (patt0$temp instanceof InductionRotorBlockEntity) {
                    InductionRotorBlockEntity rotor = (InductionRotorBlockEntity)patt0$temp;
                    this.resistance += ResistanceValues.get(rotor.m_58900_().m_60734_());
                    this.rotors.add(rotor);
                } else {
                    SmartBlockEntity patt1$temp = segment.blockEntity;
                    if (patt1$temp instanceof CommutatorBlockEntity) {
                        CommutatorBlockEntity commutator = (CommutatorBlockEntity)patt1$temp;
                        if (commutator.source != null) {
                            proxyTarget.setValue((Object)commutator.f_58858_);
                        }
                    }
                }
            });
            Object wires = null;
            ElectricBehaviour oldBehaviour = this.electricBehaviour;
            if (this.electricBehaviour != null) {
                wires = GlobalElectricNetworks.getWorldNetworks(this.f_58857_).findConnectedWires(this.electricBehaviour);
                this.electricBehaviour.pause();
            }
            this.electricBehaviour = proxyTarget.getValue() != null ? new ProxyElectricBehaviour(this, () -> ((MutableObject)proxyTarget).getValue()) : new ElectricBehaviour(this);
            if (oldBehaviour != null) {
                this.electricBehaviour.inheritConnections(oldBehaviour);
            }
            this.attachBehaviourLate(this.electricBehaviour);
            this.updateBehaviour = false;
            if (wires != null) {
                wires.forEach(TransmissionLinePart::refreshEndpointNodes);
            }
        }
        float totalField = 0.0f;
        if (this.source != null) {
            for (InductionRotorBlockEntity rotor : this.rotors) {
                totalField += rotor.calculateField();
            }
            this.source.tick(totalField);
        }
        if (this.f_58857_.f_46443_) {
            float angular = this.rotorBehaviour.getAngularVelocityRadians();
            float current = this.getCurrent();
            Block block = this.m_58900_().m_60734_();
            if (!(block instanceof IBrushPlacement)) {
                return;
            }
            IBrushPlacement brushes = (IBrushPlacement)block;
            RandomSource r = this.f_58857_.f_46441_;
            for (float chance = Math.min(Math.abs(angular / 32.0f * current / 4.0f), 5.0f); chance > 0.0f; chance -= 1.0f) {
                if (!(r.m_188501_() < chance)) continue;
                boolean secondBrush = r.m_188499_();
                Vec3 pos = this.m_58899_().m_252807_();
                Vec3 brushOffset = brushes.brushOffset(this.m_58900_()).m_272010_(r, 0.0625f);
                pos = secondBrush ? pos.m_82549_(brushOffset) : pos.m_82546_(brushOffset);
                int velocityDir = angular < 0.0f ^ secondBrush ? 1 : -1;
                Vec3 velocity = brushes.sparkVelocity(this.m_58900_(), angular).m_272010_(r, 0.0625f);
                this.f_58857_.m_7106_((ParticleOptions)new SparkParticleData(r.m_216332_(1, 3), false, true), pos.f_82479_, pos.f_82480_, pos.f_82481_, velocity.f_82479_ * (double)velocityDir, velocity.f_82480_ * (double)velocityDir, velocity.f_82481_ * (double)velocityDir);
            }
        }
    }
}

