/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.kinetics.generator.inductionrotor;

import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.patryk3211.powergrid.collections.ModdedConfigs;
import org.patryk3211.powergrid.kinetics.generator.inductionrotor.InductionRotorBlock;
import org.patryk3211.powergrid.kinetics.generator.rotor.RotorBlockEntity;
import org.patryk3211.powergrid.kinetics.generator.winding.WindingBlock;
import org.patryk3211.powergrid.kinetics.generator.winding.WindingBlockEntity;

public class InductionRotorBlockEntity
extends RotorBlockEntity {
    public float field;

    public InductionRotorBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    @Override
    public float inertia() {
        return ModdedConfigs.server().kinetics.generatorControls.generatorInductionRotorInertia.getF();
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
    }

    public float calculateField() {
        assert (this.f_58857_ != null);
        this.field = 0.0f;
        BlockState state = this.m_58900_();
        for (Direction dir : Direction.values()) {
            BlockEntity be;
            WindingBlock winding;
            Direction.Axis magnetic;
            BlockState otherState;
            Block block;
            if (dir.m_122434_() == state.m_61143_((Property)InductionRotorBlock.AXIS) || !((block = (otherState = this.f_58857_.m_8055_(this.f_58858_.m_121945_(dir))).m_60734_()) instanceof WindingBlock) || (magnetic = (winding = (WindingBlock)block).getMagneticAxis(otherState)) != dir.m_122434_() || !((be = this.f_58857_.m_7702_(this.f_58858_.m_121945_(dir))) instanceof WindingBlockEntity)) continue;
            WindingBlockEntity wbe = (WindingBlockEntity)be;
            this.field += wbe.fieldStrength() * 0.25f;
        }
        return this.field;
    }

    public float step(float current) {
        assert (this.f_58857_ != null);
        BlockState state = this.m_58900_();
        for (Direction dir : Direction.values()) {
            BlockEntity be;
            WindingBlock winding;
            Direction.Axis magnetic;
            BlockState otherState;
            Block block;
            if (dir.m_122434_() == state.m_61143_((Property)InductionRotorBlock.AXIS) || !((block = (otherState = this.f_58857_.m_8055_(this.f_58858_.m_121945_(dir))).m_60734_()) instanceof WindingBlock) || (magnetic = (winding = (WindingBlock)block).getMagneticAxis(otherState)) != dir.m_122434_() || !((be = this.f_58857_.m_7702_(this.f_58858_.m_121945_(dir))) instanceof WindingBlockEntity)) continue;
            WindingBlockEntity wbe = (WindingBlockEntity)be;
            this.field += wbe.fieldStrength() * 0.25f;
        }
        float voltage = this.field * this.rotorBehaviour.getAngularVelocityRadians();
        float torque = -this.field * current;
        float Pe = current * voltage;
        torque = Pe > 0.0f ? this.rotorBehaviour.limitForce(torque) : (torque *= 0.9f);
        this.rotorBehaviour.applyTickForce(torque);
        return voltage;
    }
}

