/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.kinetics.generator.rotor;

import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.patryk3211.powergrid.kinetics.generator.IRotorAssemblyPart;
import org.patryk3211.powergrid.kinetics.generator.rotor.RotorBehaviour;

public abstract class AbstractRotorBlock
extends Block
implements IRotorAssemblyPart,
IWrenchable,
IRotate {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61365_;

    public AbstractRotorBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public boolean m_7420_(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        Level world = context.m_43725_();
        InteractionResult result = super.onWrenched(state, context);
        if (!result.m_19077_()) {
            return result;
        }
        RotorBehaviour behaviour = (RotorBehaviour)BlockEntityBehaviour.get((BlockGetter)world, (BlockPos)context.m_8083_(), RotorBehaviour.TYPE);
        if (behaviour != null) {
            behaviour.checkConnectivity(null);
        }
        return result;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{AXIS});
    }

    public static boolean hasPositive(LevelReader world, BlockPos pos, Direction.Axis axis) {
        IRotorAssemblyPart assembly;
        BlockState state = world.m_8055_(switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> pos.m_122029_();
            case Direction.Axis.Y -> pos.m_7494_();
            case Direction.Axis.Z -> pos.m_122019_();
        });
        Block block = state.m_60734_();
        return block instanceof IRotorAssemblyPart && (assembly = (IRotorAssemblyPart)block).canConnect(state, Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE));
    }

    public static boolean hasNegative(LevelReader world, BlockPos pos, Direction.Axis axis) {
        IRotorAssemblyPart assembly;
        BlockState state = world.m_8055_(switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> pos.m_122024_();
            case Direction.Axis.Y -> pos.m_7495_();
            case Direction.Axis.Z -> pos.m_122012_();
        });
        Block block = state.m_60734_();
        return block instanceof IRotorAssemblyPart && (assembly = (IRotorAssemblyPart)block).canConnect(state, Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Direction.Axis preferredAxis = null;
        for (Direction.Axis axis : Direction.Axis.f_122448_) {
            if (!AbstractRotorBlock.hasPositive((LevelReader)world, pos, axis) && !AbstractRotorBlock.hasNegative((LevelReader)world, pos, axis)) continue;
            if (preferredAxis != null) {
                preferredAxis = null;
                break;
            }
            preferredAxis = axis;
        }
        if (preferredAxis == null) {
            preferredAxis = context.m_7820_().m_122434_();
        }
        return (BlockState)this.m_49966_().m_61124_(AXIS, (Comparable)preferredAxis);
    }

    @Override
    public boolean canConnect(BlockState state, Direction dir) {
        return state.m_61143_(AXIS) == dir.m_122434_();
    }

    @NotNull
    public Direction.Axis getAssemblyRotationAxis(BlockState state) {
        return (Direction.Axis)state.m_61143_(AXIS);
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return false;
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return null;
    }
}

