/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.kinetics.generator.rotor;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import org.patryk3211.powergrid.kinetics.generator.rotor.AbstractRotorBlock;
import org.patryk3211.powergrid.kinetics.generator.rotor.RotorBehaviour;
import org.patryk3211.powergrid.kinetics.generator.rotor.RotorBlockEntity;

public class RotorRenderer
extends SafeBlockEntityRenderer<RotorBlockEntity> {
    public RotorRenderer(BlockEntityRendererProvider.Context context) {
    }

    protected void renderSafe(RotorBlockEntity rotor, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int light, int overlay) {
        if (VisualizationManager.supportsVisualization((LevelAccessor)rotor.m_58904_())) {
            return;
        }
        BlockState state = rotor.m_58900_();
        Direction.Axis axis = ((AbstractRotorBlock)state.m_60734_()).getAssemblyRotationAxis(state);
        SuperByteBuffer rotorModel = this.getModelForState(state);
        float rotorAngle = RotorRenderer.getRotorAngle(rotor, partialTicks);
        rotorModel.light(light);
        rotorModel.rotateCentered(rotorAngle, Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis));
        rotorModel.renderInto(matrixStack, buffer.m_6299_(RenderType.m_110451_()));
    }

    public static float getRotorAngle(SmartBlockEntity rotor, float partialTicks) {
        RotorBehaviour behaviour = (RotorBehaviour)rotor.getBehaviour(RotorBehaviour.TYPE);
        float rotorAngle = behaviour.getAngle() + behaviour.getAngularVelocity() * 0.3f * partialTicks;
        rotorAngle = rotorAngle / 180.0f * (float)Math.PI;
        return rotorAngle;
    }

    protected SuperByteBuffer getModelForState(BlockState state) {
        return CachedBuffers.block((BlockState)state);
    }
}

