/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.kinetics.generator.winding;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.createmod.catnip.math.VoxelShaper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.base.CustomProperties;
import org.patryk3211.powergrid.collections.ModdedBlockEntities;
import org.patryk3211.powergrid.collections.ModdedItems;
import org.patryk3211.powergrid.electricity.base.ElectricBlock;
import org.patryk3211.powergrid.electricity.deviceconnector.IAcceptConnector;
import org.patryk3211.powergrid.kinetics.generator.housing.GeneratorHousing;
import org.patryk3211.powergrid.kinetics.generator.housing.VerticalGeneratorHousing;
import org.patryk3211.powergrid.kinetics.generator.winding.IWindingConnectable;
import org.patryk3211.powergrid.kinetics.generator.winding.WindingBlockEntity;
import org.patryk3211.powergrid.utility.PlayerUtilities;

public class WindingBlock
extends ElectricBlock
implements IBE<WindingBlockEntity>,
IAcceptConnector,
IWindingConnectable {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61365_;
    public static final IntegerProperty PART = IntegerProperty.m_61631_((String)"part", (int)0, (int)2);
    public static final BooleanProperty ALONG_FIRST_AXIS = CustomProperties.ALONG_FIRST_AXIS;
    public static final BooleanProperty CASE_RIGHT = BooleanProperty.m_61465_((String)"right");
    public static final BooleanProperty CASE_LEFT = BooleanProperty.m_61465_((String)"left");
    private static final VoxelShaper HORIZONTAL_END_SHAPER = VoxelShaper.forDirectional((VoxelShape)Shapes.m_83110_((VoxelShape)WindingBlock.m_49796_((double)2.0, (double)3.0, (double)3.0, (double)14.0, (double)13.0, (double)16.0), (VoxelShape)WindingBlock.m_49796_((double)0.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0)), (Direction)Direction.SOUTH);
    private static final VoxelShaper VERTICAL_END_SHAPER = VoxelShaper.forDirectional((VoxelShape)Shapes.m_83110_((VoxelShape)WindingBlock.m_49796_((double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)14.0, (double)16.0), (VoxelShape)WindingBlock.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0)), (Direction)Direction.SOUTH);
    private static final VoxelShaper HORIZONTAL_MIDDLE_SHAPER = VoxelShaper.forAxis((VoxelShape)WindingBlock.m_49796_((double)2.0, (double)3.0, (double)0.0, (double)14.0, (double)13.0, (double)16.0), (Direction.Axis)Direction.Axis.Z);
    private static final VoxelShaper VERTICAL_MIDDLE_SHAPER = VoxelShaper.forAxis((VoxelShape)WindingBlock.m_49796_((double)3.0, (double)2.0, (double)0.0, (double)13.0, (double)14.0, (double)16.0), (Direction.Axis)Direction.Axis.Z);

    public WindingBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Integer part = (Integer)state.m_61143_((Property)PART);
        if (part == 0 || part == 2) {
            Direction dir = Direction.m_122387_((Direction.Axis)((Direction.Axis)state.m_61143_(AXIS)), (Direction.AxisDirection)(part == 0 ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE));
            Boolean along = (Boolean)state.m_61143_((Property)ALONG_FIRST_AXIS);
            VoxelShaper shaper = along != false ? VERTICAL_END_SHAPER : HORIZONTAL_END_SHAPER;
            return shaper.get(dir);
        }
        Boolean along = (Boolean)state.m_61143_((Property)ALONG_FIRST_AXIS);
        VoxelShaper shaper = along != false ? VERTICAL_MIDDLE_SHAPER : HORIZONTAL_MIDDLE_SHAPER;
        return shaper.get((Direction.Axis)state.m_61143_(AXIS));
    }

    private void walkForward(LevelAccessor world, BlockPos pos, Direction.Axis axis, BiConsumer<BlockPos, BlockState> callback) {
        boolean last = false;
        while (!last) {
            BlockState state = world.m_8055_(pos = pos.m_5487_(axis, 1));
            if (!state.m_60713_((Block)this)) {
                return;
            }
            if ((Integer)state.m_61143_((Property)PART) == 2) {
                last = true;
            }
            callback.accept(pos, state);
        }
    }

    public void walkBackward(LevelAccessor world, BlockPos pos, Direction.Axis axis, BiConsumer<BlockPos, BlockState> callback) {
        boolean last = false;
        while (!last) {
            BlockState state = world.m_8055_(pos = pos.m_5487_(axis, -1));
            if (!state.m_60713_((Block)this)) {
                return;
            }
            if ((Integer)state.m_61143_((Property)PART) == 0) {
                last = true;
            }
            callback.accept(pos, state);
        }
    }

    public void walk(LevelAccessor world, BlockPos pos, BiConsumer<BlockPos, BlockState> callback) {
        BlockState state = world.m_8055_(pos);
        if (!state.m_60713_((Block)this)) {
            return;
        }
        callback.accept(pos, state);
        Direction.Axis axis = (Direction.Axis)state.m_61143_(AXIS);
        switch ((Integer)state.m_61143_((Property)PART)) {
            case 0: {
                this.walkForward(world, pos, axis, callback);
                break;
            }
            case 1: {
                this.walkForward(world, pos, axis, callback);
                this.walkBackward(world, pos, axis, callback);
                break;
            }
            case 2: {
                this.walkBackward(world, pos, axis, callback);
            }
        }
    }

    public void m_6240_(Level world, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack tool) {
        super.m_6240_(world, player, pos, state, blockEntity, tool);
        if ((Integer)state.m_61143_((Property)PART) != 1) {
            WindingBlock.m_49840_((Level)world, (BlockPos)pos, (ItemStack)AllBlocks.SHAFT.asStack());
        }
    }

    public void m_6786_(LevelAccessor world, BlockPos pos, BlockState state) {
        super.m_6786_(world, pos, state);
        if (world.m_5776_()) {
            return;
        }
        Direction.Axis axis = (Direction.Axis)state.m_61143_(AXIS);
        BiConsumer<BlockPos, BlockState> breakBlock = (pos1, state1) -> {
            world.m_46961_(pos1, true);
            if ((Integer)state1.m_61143_((Property)PART) != 1) {
                world.m_7731_(pos1, (BlockState)AllBlocks.SHAFT.getDefaultState().m_61124_(AXIS, (Comparable)this.getMagneticAxis((BlockState)state1)), 3);
            }
        };
        switch ((Integer)state.m_61143_((Property)PART)) {
            case 0: {
                this.walkForward(world, pos, axis, breakBlock);
                break;
            }
            case 1: {
                this.walkForward(world, pos, axis, breakBlock);
                this.walkBackward(world, pos, axis, breakBlock);
                break;
            }
            case 2: {
                this.walkBackward(world, pos, axis, breakBlock);
            }
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{AXIS, PART, ALONG_FIRST_AXIS, CASE_RIGHT, CASE_LEFT});
    }

    public static boolean canConnect(BlockState thisState, boolean positive, BlockState state) {
        Block block = state.m_60734_();
        if (block instanceof WindingBlock) {
            WindingBlock windingBlock = (WindingBlock)block;
            if (state.m_61143_(AXIS) == thisState.m_61143_(AXIS) && state.m_61143_((Property)ALONG_FIRST_AXIS) == thisState.m_61143_((Property)ALONG_FIRST_AXIS)) {
                return true;
            }
        } else {
            WindingBlock windingBlock;
            if (state.m_60734_() instanceof GeneratorHousing) {
                windingBlock = (WindingBlock)thisState.m_60734_();
                Direction.Axis parallelAxis = windingBlock.getParallelCheckAxis(thisState);
                if (parallelAxis.m_122479_()) {
                    Direction expectedFacing = Direction.m_122387_((Direction.Axis)parallelAxis, (Direction.AxisDirection)(positive ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE));
                    return state.m_61143_(GeneratorHousing.HORIZONTAL_FACING) == expectedFacing;
                }
                boolean expectUp = !positive;
                return (Boolean)state.m_61143_((Property)GeneratorHousing.UP) == expectUp;
            }
            if (state.m_60734_() instanceof VerticalGeneratorHousing) {
                windingBlock = (WindingBlock)thisState.m_60734_();
                Direction.Axis parallelAxis = windingBlock.getParallelCheckAxis(thisState);
                if (parallelAxis.m_122478_()) {
                    return false;
                }
                Direction expectedFacing = Direction.m_122387_((Direction.Axis)parallelAxis, (Direction.AxisDirection)(positive ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE));
                Direction housingFacing = (Direction)state.m_61143_(GeneratorHousing.HORIZONTAL_FACING);
                return housingFacing == expectedFacing || housingFacing.m_122428_() == expectedFacing;
            }
        }
        return false;
    }

    @Override
    public boolean canConnect(BlockState state, Direction side) {
        return this.getParallelCheckAxis(state) == side.m_122434_();
    }

    @Override
    public Direction getOtherSide(BlockState state, Direction sideIn) {
        return sideIn.m_122424_();
    }

    public void updateCase(BlockState state, LevelAccessor world, BlockPos pos) {
        Direction.Axis axis = this.getParallelCheckAxis(state);
        BlockState stateN = world.m_8055_(pos.m_5487_(axis, -1));
        boolean left = WindingBlock.canConnect(state, false, stateN);
        BlockState stateP = world.m_8055_(pos.m_5487_(axis, 1));
        boolean right = WindingBlock.canConnect(state, true, stateP);
        BlockState newState = (BlockState)((BlockState)state.m_61124_((Property)CASE_LEFT, (Comparable)Boolean.valueOf(left))).m_61124_((Property)CASE_RIGHT, (Comparable)Boolean.valueOf(right));
        if (newState != state) {
            world.m_7731_(pos, newState, 2);
        }
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block sourceBlock, BlockPos sourcePos, boolean notify) {
        super.m_6861_(state, world, pos, sourceBlock, sourcePos, notify);
        this.updateCase(state, (LevelAccessor)world, pos);
        BlockPos dir = sourcePos.m_121996_((Vec3i)pos);
        if (Direction.m_122378_((int)dir.m_123341_(), (int)dir.m_123342_(), (int)dir.m_123343_()).m_122434_() == state.m_61143_(AXIS)) {
            return;
        }
        this.withBlockEntityDo((BlockGetter)world, pos, be -> be.onNeighborChanged(sourcePos));
    }

    public void m_7742_(BlockState state, LevelAccessor world, BlockPos pos, int flags, int maxUpdateDepth) {
        super.m_7742_(state, world, pos, flags, maxUpdateDepth);
        this.updateCase(state, world, pos);
    }

    @Nullable
    public BlockPos getMainBlockPos(Level world, BlockPos pos) {
        if (!world.m_46749_(pos)) {
            return null;
        }
        BlockState state = world.m_8055_(pos);
        if (!state.m_60713_((Block)this)) {
            return null;
        }
        Direction.Axis axis = (Direction.Axis)state.m_61143_(AXIS);
        switch ((Integer)state.m_61143_((Property)PART)) {
            case 0: {
                return pos;
            }
            case 1: 
            case 2: {
                do {
                    if (!world.m_46749_(pos = pos.m_5487_(axis, -1))) {
                        return null;
                    }
                    state = world.m_8055_(pos);
                    if (state.m_60713_((Block)this)) continue;
                    return null;
                } while ((Integer)state.m_61143_((Property)PART) != 0);
                return pos;
            }
        }
        return null;
    }

    public Optional<WindingBlockEntity> getMainBlockEntity(Level world, BlockPos pos) {
        BlockPos mainPos = this.getMainBlockPos(world, pos);
        if (mainPos != null) {
            return world.m_141902_(mainPos, (BlockEntityType)ModdedBlockEntities.WINDING.get());
        }
        return Optional.empty();
    }

    public Direction.Axis getParallelCheckAxis(BlockState state) {
        Boolean along = (Boolean)state.m_61143_((Property)ALONG_FIRST_AXIS);
        return switch ((Direction.Axis)state.m_61143_(AXIS)) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> {
                if (along.booleanValue()) {
                    yield Direction.Axis.Z;
                }
                yield Direction.Axis.Y;
            }
            case Direction.Axis.Y -> {
                if (along.booleanValue()) {
                    yield Direction.Axis.X;
                }
                yield Direction.Axis.Z;
            }
            case Direction.Axis.Z -> along != false ? Direction.Axis.X : Direction.Axis.Y;
        };
    }

    public Direction.Axis getMagneticAxis(BlockState state) {
        Boolean along = (Boolean)state.m_61143_((Property)ALONG_FIRST_AXIS);
        return switch ((Direction.Axis)state.m_61143_(AXIS)) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> {
                if (along.booleanValue()) {
                    yield Direction.Axis.Y;
                }
                yield Direction.Axis.Z;
            }
            case Direction.Axis.Y -> {
                if (along.booleanValue()) {
                    yield Direction.Axis.Z;
                }
                yield Direction.Axis.X;
            }
            case Direction.Axis.Z -> along != false ? Direction.Axis.Y : Direction.Axis.X;
        };
    }

    public Class<WindingBlockEntity> getBlockEntityClass() {
        return WindingBlockEntity.class;
    }

    public BlockEntityType<? extends WindingBlockEntity> getBlockEntityType() {
        return (BlockEntityType)ModdedBlockEntities.WINDING.get();
    }

    @Override
    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        Integer part = (Integer)state.m_61143_((Property)PART);
        Direction.Axis axis = (Direction.Axis)state.m_61143_(AXIS);
        switch (part) {
            case 0: {
                if ((Integer)world.m_8055_(pos.m_5487_(axis, 1)).m_61143_((Property)PART) == 1) break;
                return InteractionResult.FAIL;
            }
            case 1: {
                return InteractionResult.FAIL;
            }
            case 2: {
                if ((Integer)world.m_8055_(pos.m_5487_(axis, -1)).m_61143_((Property)PART) == 1) break;
                return InteractionResult.FAIL;
            }
        }
        if (!(world instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ServerLevel serverWorld = (ServerLevel)world;
        if (player != null && !player.m_7500_()) {
            Block.m_49874_((BlockState)((BlockState)state.m_61124_((Property)PART, (Comparable)Integer.valueOf(1))), (ServerLevel)serverWorld, (BlockPos)pos, (BlockEntity)world.m_7702_(pos), (Entity)player, (ItemStack)context.m_43722_()).forEach(stack -> player.m_150109_().m_150079_(stack));
        }
        ((BlockState)state.m_61124_((Property)PART, (Comparable)Integer.valueOf(1))).m_222967_(serverWorld, pos, ItemStack.f_41583_, true);
        world.m_46597_(pos, Blocks.f_50016_.m_49966_());
        BlockPos newPos = pos.m_5487_(axis, 1 - part);
        world.m_46597_(newPos, state);
        if ((Integer)state.m_61143_((Property)PART) == 0) {
            this.withBlockEntityDo((BlockGetter)world, newPos, WindingBlockEntity::makeMain);
        }
        IWrenchable.playRemoveSound((Level)world, (BlockPos)pos);
        return InteractionResult.SUCCESS;
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        if (!(world instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ServerLevel serverLevel = (ServerLevel)world;
        if (PlayerUtilities.cancelBreak(world, pos, player)) {
            return InteractionResult.SUCCESS;
        }
        this.walk((LevelAccessor)world, pos, (pos1, state1) -> {
            if (player != null && !player.m_7500_()) {
                Block.m_49874_((BlockState)state1, (ServerLevel)serverLevel, (BlockPos)pos1, (BlockEntity)world.m_7702_(pos1), (Entity)player, (ItemStack)context.m_43722_()).forEach(stack -> player.m_150109_().m_150079_(stack));
                if (pos.equals(pos1) && (Integer)state1.m_61143_((Property)PART) != 1) {
                    player.m_150109_().m_150079_(AllBlocks.SHAFT.asStack());
                }
            }
            state1.m_222967_(serverLevel, pos1, ItemStack.f_41583_, true);
            world.m_46961_(pos1, false);
            if (!pos.equals(pos1) && (Integer)state1.m_61143_((Property)PART) != 1) {
                world.m_46597_(pos1, (BlockState)AllBlocks.SHAFT.getDefaultState().m_61124_(AXIS, (Comparable)this.getMagneticAxis((BlockState)state1)));
            }
        });
        IWrenchable.playRemoveSound((Level)world, (BlockPos)pos);
        return InteractionResult.SUCCESS;
    }

    public ItemStack m_7397_(BlockGetter world, BlockPos pos, BlockState state) {
        return ModdedItems.COPPER_COIL.asStack();
    }

    @Override
    public boolean canConnect(LevelReader world, BlockPos pos, BlockState state, Direction side) {
        return side.m_122434_() == this.getMagneticAxis(state) && (Integer)state.m_61143_((Property)PART) != 1;
    }

    @Override
    public boolean isPolarized() {
        return true;
    }
}

