/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.kinetics.generator.winding;

import com.simibubi.create.AllBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.patryk3211.powergrid.collections.ModdedBlocks;
import org.patryk3211.powergrid.kinetics.generator.winding.WindingBlock;
import org.patryk3211.powergrid.utility.PlayerUtilities;

public class WindingItem
extends Item {
    public WindingItem(Item.Properties settings) {
        super(settings);
    }

    public boolean m_5812_(ItemStack stack) {
        return super.m_5812_(stack) || stack.m_41782_();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        ItemStack stack = user.m_21120_(hand);
        if (user.m_6144_()) {
            stack.m_41751_(null);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return super.m_7203_(world, user, hand);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos pos = context.m_8083_();
        Level world = context.m_43725_();
        ItemStack stack = context.m_43722_();
        if (context.m_43723_() != null && context.m_43723_().m_6144_()) {
            stack.m_41751_(null);
            return InteractionResult.SUCCESS;
        }
        BlockState hitState = world.m_8055_(pos);
        if (hitState.m_60713_((Block)ModdedBlocks.WINDING.get())) {
            Direction side = context.m_43719_();
            if (hitState.m_61143_((Property)BlockStateProperties.f_61365_) != side.m_122434_()) {
                return InteractionResult.FAIL;
            }
            BlockPos newPos = pos.m_121945_(side);
            if (!world.m_8055_(newPos).m_247087_()) {
                return InteractionResult.FAIL;
            }
            if (!world.f_46443_) {
                stack.m_41774_(1);
                world.m_46597_(pos, (BlockState)hitState.m_61124_((Property)WindingBlock.PART, (Comparable)Integer.valueOf(1)));
                world.m_46597_(newPos, hitState);
                world.m_5594_(null, pos, hitState.m_60827_().m_56777_(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return InteractionResult.SUCCESS;
        }
        if (!hitState.m_60713_((Block)AllBlocks.SHAFT.get())) {
            return InteractionResult.FAIL;
        }
        if (stack.m_41782_()) {
            CompoundTag tag = stack.m_41783_();
            int[] posArray = tag.m_128465_("Position");
            BlockPos firstPos = new BlockPos(posArray[0], posArray[1], posArray[2]);
            if (firstPos.equals((Object)pos)) {
                return InteractionResult.FAIL;
            }
            BlockState firstState = world.m_8055_(firstPos);
            if (!firstState.m_60713_((Block)AllBlocks.SHAFT.get())) {
                stack.m_41751_(null);
                return InteractionResult.FAIL;
            }
            Direction.Axis axis = (Direction.Axis)hitState.m_61143_((Property)BlockStateProperties.f_61365_);
            if (axis != firstState.m_61143_((Property)BlockStateProperties.f_61365_)) {
                return InteractionResult.FAIL;
            }
            Direction.Axis placementAxis = WindingItem.getPlacementAxis(pos, firstPos);
            if (placementAxis == axis) {
                return InteractionResult.FAIL;
            }
            boolean isAlongFirst = WindingItem.isAlongFirst(placementAxis, axis);
            BlockState baseState = (BlockState)((BlockState)((BlockState)ModdedBlocks.WINDING.getDefaultState().m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)placementAxis)).m_61124_((Property)WindingBlock.ALONG_FIRST_AXIS, (Comparable)Boolean.valueOf(isAlongFirst))).m_61124_((Property)WindingBlock.PART, (Comparable)Integer.valueOf(1));
            int length = WindingItem.getPlacementDelta(pos, firstPos);
            if (!PlayerUtilities.hasEnoughItems(context.m_43723_(), stack, Math.abs(length) + 1)) {
                return InteractionResult.FAIL;
            }
            if (length > 0) {
                for (i = 1; i < length; ++i) {
                    if (world.m_8055_(firstPos.m_5487_(placementAxis, i)).m_247087_()) continue;
                    return InteractionResult.FAIL;
                }
            } else {
                for (i = -1; i > length; --i) {
                    if (world.m_8055_(firstPos.m_5487_(placementAxis, i)).m_247087_()) continue;
                    return InteractionResult.FAIL;
                }
            }
            if (world.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            Direction offsetDir = Direction.m_122387_((Direction.Axis)placementAxis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
            BlockPos start = length > 0 ? firstPos : pos;
            length = Math.abs(length);
            for (int i = 0; i <= length; ++i) {
                if (i == 0) {
                    world.m_46597_(start.m_5484_(offsetDir, i), (BlockState)baseState.m_61124_((Property)WindingBlock.PART, (Comparable)Integer.valueOf(0)));
                    continue;
                }
                if (i == length) {
                    world.m_46597_(start.m_5484_(offsetDir, i), (BlockState)baseState.m_61124_((Property)WindingBlock.PART, (Comparable)Integer.valueOf(2)));
                    continue;
                }
                world.m_46597_(start.m_5484_(offsetDir, i), baseState);
            }
            stack.m_41751_(null);
            PlayerUtilities.removeItems(context.m_43723_(), stack, length + 1);
            world.m_5594_(null, pos, baseState.m_60827_().m_56777_(), SoundSource.BLOCKS, 1.0f, 1.0f);
        } else {
            if (world.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            CompoundTag tag = new CompoundTag();
            tag.m_128385_("Position", new int[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()});
            stack.m_41751_(tag);
        }
        return InteractionResult.SUCCESS;
    }

    private static boolean isAlongFirst(Direction.Axis placementAxis, Direction.Axis shaftAxis) {
        if (placementAxis.m_122479_() && shaftAxis.m_122479_()) {
            return false;
        }
        if (placementAxis.m_122479_() && shaftAxis.m_122478_()) {
            return true;
        }
        return shaftAxis == Direction.Axis.Z;
    }

    @NotNull
    public static Direction.Axis getPlacementAxis(BlockPos pos, BlockPos firstPos) {
        int dX = pos.m_123341_() - firstPos.m_123341_();
        int dY = pos.m_123342_() - firstPos.m_123342_();
        int dZ = pos.m_123343_() - firstPos.m_123343_();
        int lenX = Math.abs(dX);
        int lenY = Math.abs(dY);
        int lenZ = Math.abs(dZ);
        if (lenX > lenY && lenX > lenZ) {
            return Direction.Axis.X;
        }
        if (lenY > lenZ) {
            return Direction.Axis.Y;
        }
        return Direction.Axis.Z;
    }

    public static int getPlacementDelta(BlockPos pos, BlockPos firstPos) {
        int dX = pos.m_123341_() - firstPos.m_123341_();
        int dY = pos.m_123342_() - firstPos.m_123342_();
        int dZ = pos.m_123343_() - firstPos.m_123343_();
        int lenX = Math.abs(dX);
        int lenY = Math.abs(dY);
        int lenZ = Math.abs(dZ);
        if (lenX > lenY && lenX > lenZ) {
            return dX;
        }
        if (lenY > lenZ) {
            return dY;
        }
        return dZ;
    }
}

