/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.kinetics.motor;

import com.simibubi.create.api.stress.BlockStressValues;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.CenteredSideValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.List;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.collections.ModdedConfigs;
import org.patryk3211.powergrid.electricity.base.ElectricBehaviour;
import org.patryk3211.powergrid.electricity.base.IElectricEntity;
import org.patryk3211.powergrid.electricity.base.ThermalBehaviour;
import org.patryk3211.powergrid.electricity.sim.AbstractElectricWire;
import org.patryk3211.powergrid.electricity.sim.ElectricWire;
import org.patryk3211.powergrid.kinetics.motor.ConstantSpeedMotorBlock;
import org.patryk3211.powergrid.kinetics.motor.ElectricMotorBlock;
import org.patryk3211.powergrid.kinetics.motor.SpeedScrollValueBehaviour;
import org.patryk3211.powergrid.mixin.KineticBlockEntityAccessor;
import org.patryk3211.powergrid.utility.Lang;

public class ConstantSpeedMotorBlockEntity
extends GeneratingKineticBlockEntity
implements IElectricEntity {
    public static final int AVERAGING_TICKS = 5;
    protected ElectricBehaviour electricBehaviour;
    @Nullable
    protected ThermalBehaviour thermalBehaviour;
    private SpeedScrollValueBehaviour scrollValue;
    private ElectricWire coil;
    private float generatedSU = 0.0f;
    private float avgSpeed;

    public ConstantSpeedMotorBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
        this.setLazyTickRate(5);
    }

    public float torque() {
        return (float)(BlockStressValues.getCapacity((Block)this.m_58900_().m_60734_()) * (double)ModdedConfigs.server().kinetics.torqueForStress.getF());
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.electricBehaviour = new ElectricBehaviour(this);
        behaviours.add(this.electricBehaviour);
        float maxPower = 256.0f * this.torque() / 60.0f;
        float baseFactor = ThermalBehaviour.dissipationFactor(maxPower, 150.0f);
        this.thermalBehaviour = ThermalBehaviour.simple((SmartBlockEntity)this, 3.5f, baseFactor);
        if (this.thermalBehaviour != null) {
            behaviours.add(this.thermalBehaviour);
        }
        Integer max = (Integer)AllConfigs.server().kinetics.maxRotationSpeed.get();
        this.scrollValue = new SpeedScrollValueBehaviour((Component)Lang.translateDirect("devices.motor.speed", new Object[0]), (SmartBlockEntity)this, (ValueBoxTransform)new Box());
        this.scrollValue.between(0, max);
        this.scrollValue.value = 16;
        this.scrollValue.withCallback(i -> this.updateGeneratedRotation());
        behaviours.add((BlockEntityBehaviour)this.scrollValue);
    }

    protected void applyPower(AbstractElectricWire wire) {
        if (this.thermalBehaviour != null) {
            this.thermalBehaviour.applyWirePower(wire);
        }
    }

    public void remove() {
        super.remove();
        if (this.electricBehaviour != null) {
            this.electricBehaviour.remove();
        }
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.generatedSU = compound.m_128457_("GeneratedStress");
        this.updateGeneratedRotation();
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128350_("GeneratedStress", this.generatedSU);
    }

    public void lazyTick() {
        assert (this.f_58857_ != null);
        super.lazyTick();
        int newSpeed = (int)(this.avgSpeed / 5.0f);
        this.avgSpeed = 0.0f;
        if (!this.f_58857_.f_46443_ || this.isVirtual()) {
            if (newSpeed > 256) {
                newSpeed = 256;
            }
            if (newSpeed < -256) {
                newSpeed = -256;
            }
            if ((float)(newSpeed *= (int)BlockStressValues.getCapacity((Block)this.m_58900_().m_60734_())) != this.generatedSU) {
                this.generatedSU = newSpeed;
                this.updateGeneratedRotation();
            }
        }
    }

    public void tick() {
        assert (this.f_58857_ != null);
        this.applyPower(this.coil);
        if (!this.f_58857_.f_46443_ || this.isVirtual()) {
            float speedFromPower = this.coil.power() / this.torque() * 60.0f;
            this.avgSpeed += speedFromPower * Math.signum(this.coil.current());
        }
        super.tick();
    }

    public void applyNewSpeed(float prevSpeed, float speed) {
        super.applyNewSpeed(prevSpeed, speed);
        if (Math.signum(prevSpeed) == Math.signum(speed)) {
            for (KineticBlockEntity entry : this.getOrCreateNetwork().members.keySet()) {
                ((KineticBlockEntityAccessor)entry).setFlickerTally(Math.max(entry.getFlickerScore() - 5, 0));
            }
        }
    }

    public float getGeneratedSpeed() {
        if (Math.abs(this.generatedSU) < 64.0f) {
            return 0.0f;
        }
        return ConstantSpeedMotorBlockEntity.convertToDirection((float)(this.scrollValue.getValue() * (this.generatedSU < 0.0f ? -1 : 1)), (Direction)((Direction)this.m_58900_().m_61143_((Property)ElectricMotorBlock.FACING)));
    }

    public float calculateAddedStressCapacity() {
        if (Math.abs(this.generatedSU) < 64.0f) {
            return 0.0f;
        }
        return Math.abs(this.generatedSU) / (float)this.scrollValue.getValue();
    }

    @Override
    public void buildCircuit(IElectricEntity.CircuitBuilder builder) {
        builder.setTerminalCount(2);
        this.coil = builder.connect(this.resistance(), builder.terminalNode(0), builder.terminalNode(1));
    }

    public static class Box
    extends CenteredSideValueBoxTransform {
        public Box() {
            super((state, dir) -> {
                Direction facing = (Direction)state.m_61143_((Property)ConstantSpeedMotorBlock.FACING);
                if (facing.m_122434_() == Direction.Axis.Y) {
                    return dir.m_122434_() == Direction.Axis.Z;
                }
                return dir == Direction.UP;
            });
        }

        protected Vec3 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)8.0, (double)12.5);
        }
    }
}

