/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.kinetics.servo;

import com.simibubi.create.api.stress.BlockStressValues;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.foundation.block.IBE;
import java.util.List;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.patryk3211.powergrid.collections.ModdedBlockEntities;
import org.patryk3211.powergrid.collections.ModdedConfigs;
import org.patryk3211.powergrid.electricity.base.DirectionalElectricBlock;
import org.patryk3211.powergrid.electricity.base.IDecoratedTerminal;
import org.patryk3211.powergrid.electricity.base.TerminalBoundingBox;
import org.patryk3211.powergrid.electricity.info.IHaveElectricProperties;
import org.patryk3211.powergrid.electricity.info.Resistance;
import org.patryk3211.powergrid.electricity.info.Voltage;
import org.patryk3211.powergrid.kinetics.base.ElectricKineticBlock;
import org.patryk3211.powergrid.kinetics.servo.ServoBlockEntity;

public class ServoBlock
extends ElectricKineticBlock
implements IBE<ServoBlockEntity>,
IHaveElectricProperties {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    private static final TerminalBoundingBox[] TERMINALS_NORTH = new TerminalBoundingBox[]{new TerminalBoundingBox(IDecoratedTerminal.POSITIVE, 4.0, 12.0, 14.0, 6.0, 14.0, 16.0).withColor(0xFF3B3B), new TerminalBoundingBox(IDecoratedTerminal.NEGATIVE, 10.0, 12.0, 14.0, 12.0, 14.0, 16.0).withColor(3899647), new TerminalBoundingBox(IDecoratedTerminal.CONTROL, 7.0, 12.0, 14.0, 9.0, 14.0, 16.0).withColor(43520)};
    private static final VoxelShape NORTH_SHAPE = ServoBlock.m_49796_((double)2.0, (double)3.0, (double)1.0, (double)14.0, (double)13.0, (double)15.0);

    public ServoBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.setTerminalCollection(DirectionalElectricBlock.directionalNorthTerminals((Block)this, TERMINALS_NORTH, NORTH_SHAPE));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING});
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.m_61143_((Property)FACING)).m_122434_();
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face == state.m_61143_((Property)FACING);
    }

    public Direction getPreferredFacing(BlockPlaceContext context) {
        Direction prefferedSide = null;
        for (Direction side : Iterate.directions) {
            BlockState blockState = context.m_43725_().m_8055_(context.m_8083_().m_121945_(side));
            if (!(blockState.m_60734_() instanceof IRotate) || !((IRotate)blockState.m_60734_()).hasShaftTowards((LevelReader)context.m_43725_(), context.m_8083_().m_121945_(side), blockState, side.m_122424_())) continue;
            if (prefferedSide != null && prefferedSide.m_122434_() != side.m_122434_()) {
                prefferedSide = null;
                break;
            }
            prefferedSide = side;
        }
        return prefferedSide == null ? null : prefferedSide.m_122424_();
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction preferred = this.getPreferredFacing(context);
        if (preferred == null || context.m_43723_() != null && context.m_43723_().m_6144_()) {
            Direction nearestLookingDirection = context.m_7820_();
            return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)(context.m_43723_() != null && context.m_43723_().m_6144_() ? nearestLookingDirection : nearestLookingDirection.m_122424_()));
        }
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)preferred.m_122424_());
    }

    public Class<ServoBlockEntity> getBlockEntityClass() {
        return ServoBlockEntity.class;
    }

    public BlockEntityType<? extends ServoBlockEntity> getBlockEntityType() {
        return (BlockEntityType)ModdedBlockEntities.SERVO.get();
    }

    @Override
    public void appendProperties(ItemStack stack, Player player, List<Component> tooltip) {
        Resistance.series(this.resistance("on"), player, tooltip);
        double torque = BlockStressValues.getCapacity((Block)this) * (double)ModdedConfigs.server().kinetics.torqueForStress.getF();
        double maxPower = 32.0 * torque / 60.0;
        Voltage.max((int)Math.sqrt(maxPower * (double)this.resistance("on")), player, tooltip);
    }
}

