/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.kinetics.servo;

import com.simibubi.create.api.stress.BlockStressValues;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.collections.ModdedConfigs;
import org.patryk3211.powergrid.electricity.base.ElectricBehaviour;
import org.patryk3211.powergrid.electricity.base.IElectricEntity;
import org.patryk3211.powergrid.electricity.base.ThermalBehaviour;
import org.patryk3211.powergrid.electricity.sim.AbstractElectricWire;
import org.patryk3211.powergrid.electricity.sim.ElectricWire;
import org.patryk3211.powergrid.kinetics.motor.ElectricMotorBlock;
import org.patryk3211.powergrid.mixin.KineticBlockEntityAccessor;

public class ServoBlockEntity
extends GeneratingKineticBlockEntity
implements IElectricEntity {
    public static final float MAX_SPEED = 32.0f;
    protected ElectricBehaviour electricBehaviour;
    @Nullable
    protected ThermalBehaviour thermalBehaviour;
    private float generatedSpeed;
    private float currentAngle;
    private float maxSpeed;
    private float currentTarget;
    private ElectricWire coil;
    private ElectricWire control;
    private float avgSpeed;
    private float avgTarget;

    public ServoBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.setLazyTickRate(5);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.electricBehaviour = new ElectricBehaviour(this);
        behaviours.add(this.electricBehaviour);
        float maxPower = 32.0f * this.torque() / 60.0f;
        float baseFactor = ThermalBehaviour.dissipationFactor(maxPower, 150.0f);
        this.thermalBehaviour = ThermalBehaviour.simple((SmartBlockEntity)this, 3.5f, baseFactor);
        if (this.thermalBehaviour != null) {
            behaviours.add(this.thermalBehaviour);
        }
    }

    public float torque() {
        return (float)(BlockStressValues.getCapacity((Block)this.m_58900_().m_60734_()) * (double)ModdedConfigs.server().kinetics.torqueForStress.getF());
    }

    public void lazyTick() {
        float newTarget;
        super.lazyTick();
        if (this.f_58857_.f_46443_) {
            return;
        }
        this.currentTarget = newTarget = Mth.m_14036_((float)(this.avgTarget / 5.0f / 5.0f * 360.0f), (float)-360.0f, (float)360.0f);
        this.avgTarget = 0.0f;
        this.maxSpeed = Math.min(this.avgSpeed / 5.0f, 32.0f);
        this.avgSpeed = 0.0f;
        if (this.maxSpeed == 0.0f && this.generatedSpeed != 0.0f) {
            this.generatedSpeed = 0.0f;
            this.updateGeneratedRotation();
            this.notifyUpdate();
        }
    }

    public void tick() {
        this.applyPower(this.coil);
        if (!this.f_58857_.f_46443_ || this.isVirtual()) {
            float speedFromPower = this.coil.power() / this.torque() * 60.0f;
            this.avgSpeed += speedFromPower;
            this.avgTarget += this.control.potentialDifference();
        }
        super.tick();
        if (!this.f_58857_.f_46443_ || this.isVirtual()) {
            float dT;
            float speed;
            float rotation = (this.currentTarget - this.currentAngle) / 360.0f;
            if (Math.abs(rotation) < 0.01f) {
                rotation = 0.0f;
            }
            if ((speed = Mth.m_14036_((float)(rotation / (dT = 0.05f) * 60.0f), (float)(-this.maxSpeed), (float)this.maxSpeed)) != this.generatedSpeed) {
                this.generatedSpeed = speed;
                this.updateGeneratedRotation();
                this.notifyUpdate();
            }
            if (this.generatedSpeed != 0.0f) {
                this.coil.setResistance(this.resistance("on"));
            } else {
                this.coil.setResistance(this.resistance("idle"));
            }
            this.currentAngle += this.generatedSpeed / 60.0f * dT * 360.0f;
        }
    }

    protected void applyPower(AbstractElectricWire wire) {
        if (this.thermalBehaviour != null) {
            this.thermalBehaviour.applyWirePower(wire);
        }
    }

    public void remove() {
        super.remove();
        if (this.electricBehaviour != null) {
            this.electricBehaviour.remove();
        }
    }

    @Override
    public void buildCircuit(IElectricEntity.CircuitBuilder builder) {
        builder.setTerminalCount(3);
        this.coil = builder.connect(this.resistance("idle"), builder.terminalNode(0), builder.terminalNode(1));
        this.control = builder.connect(1000.0f, builder.terminalNode(2), builder.terminalNode(1));
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.generatedSpeed = compound.m_128457_("GeneratedSpeed");
        this.currentAngle = compound.m_128457_("Angle");
        if (this.generatedSpeed != 0.0f) {
            this.coil.setResistance(this.resistance("on"));
        } else {
            this.coil.setResistance(this.resistance("idle"));
        }
        this.updateGeneratedRotation();
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128350_("GeneratedSpeed", this.generatedSpeed);
        compound.m_128350_("Angle", this.currentAngle);
    }

    public float getGeneratedSpeed() {
        return ServoBlockEntity.convertToDirection((float)this.generatedSpeed, (Direction)((Direction)this.m_58900_().m_61143_((Property)ElectricMotorBlock.FACING)));
    }

    public void applyNewSpeed(float prevSpeed, float speed) {
        super.applyNewSpeed(prevSpeed, speed);
        if (Math.signum(prevSpeed) == Math.signum(speed)) {
            for (KineticBlockEntity entry : this.getOrCreateNetwork().members.keySet()) {
                ((KineticBlockEntityAccessor)entry).setFlickerTally(Math.max(entry.getFlickerScore() - 5, 0));
            }
        }
    }
}

