/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.mixin.client;

import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.utility.IComplexRaycast;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ProjectileUtil.class})
public abstract class ComplexEntityRaycastMixin {
    @Unique
    @Nullable
    private static Vec3 powerGrid$complexRaycast(Entity entity, Vec3 min, Vec3 max, double distance) {
        assert (entity instanceof IComplexRaycast);
        IComplexRaycast checker = (IComplexRaycast)entity;
        AABB entityBB = entity.m_20191_().m_82400_((double)entity.m_6143_());
        Optional potentialHit = entityBB.m_82371_(min, max);
        if (entityBB.m_82390_(min)) {
            return checker.raycast(min, max);
        }
        if (potentialHit.isPresent() && min.m_82557_((Vec3)potentialHit.get()) < distance) {
            return checker.raycast(min, max);
        }
        return null;
    }

    @Inject(method={"getEntityHitResult(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/AABB;Ljava/util/function/Predicate;D)Lnet/minecraft/world/phys/EntityHitResult;"}, at={@At(value="RETURN")}, cancellable=true)
    private static void complexRaycast(Entity shooter, Vec3 startVec, Vec3 endVec, AABB boundingBox, Predicate<Entity> filter, double distance, CallbackInfoReturnable<EntityHitResult> cir) {
        EntityHitResult baseResult = (EntityHitResult)cir.getReturnValue();
        Level world = shooter.m_9236_();
        double currentHitDistance = distance;
        Entity currentHitEntity = null;
        Vec3 currentHitPoint = null;
        if (baseResult != null) {
            currentHitPoint = baseResult.m_82450_();
            currentHitDistance = startVec.m_82557_(currentHitPoint);
        }
        for (Entity potentialHitEntity : world.m_6249_(shooter, boundingBox, testEntity -> !testEntity.m_5833_() && testEntity instanceof IComplexRaycast)) {
            double hitSquaredDistance;
            Vec3 hit = ComplexEntityRaycastMixin.powerGrid$complexRaycast(potentialHitEntity, startVec, endVec, currentHitDistance);
            if (hit == null || !((hitSquaredDistance = startVec.m_82557_(hit)) < currentHitDistance)) continue;
            currentHitEntity = potentialHitEntity;
            currentHitPoint = hit;
            currentHitDistance = hitSquaredDistance;
        }
        if (currentHitEntity != null) {
            cir.setReturnValue((Object)new EntityHitResult(currentHitEntity, currentHitPoint));
        }
    }
}

