/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.mixin.forge;

import com.simibubi.create.content.kinetics.belt.BeltBlockEntity;
import com.simibubi.create.content.kinetics.belt.BeltHelper;
import com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.content.kinetics.mechanicalArm.AllArmInteractionPointTypes;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmInteractionPoint;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.patryk3211.powergrid.circuits.circuitboard.IncompleteCircuitItem;
import org.patryk3211.powergrid.collections.ModdedItems;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ArmInteractionPoint.class}, remap=false)
public abstract class ArmInteractionPointMixin {
    @Shadow
    @Nullable
    protected abstract IItemHandler getHandler();

    @Shadow
    public abstract Level getLevel();

    @Shadow
    public abstract BlockPos getPos();

    @Unique
    private ItemStack powerGrid$handleDepot(ItemStack componentStack, boolean simulate) {
        IItemHandler handler = this.getHandler();
        if (handler == null) {
            return null;
        }
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack circuitStack = handler.getStackInSlot(i);
            if (circuitStack.m_41619_() || !circuitStack.m_150930_((Item)ModdedItems.INCOMPLETE_CIRCUIT.get())) continue;
            ItemStack newCircuit = IncompleteCircuitItem.insert(circuitStack, componentStack);
            if (newCircuit != null) {
                if (!simulate) {
                    ItemStack extracted = handler.extractItem(i, 1, false);
                    if (handler.insertItem(i, newCircuit, true).m_41619_()) {
                        handler.insertItem(i, newCircuit, false);
                    } else {
                        handler.insertItem(i, extracted, false);
                        return componentStack;
                    }
                }
                return ItemHandlerHelper.copyStackWithSize((ItemStack)componentStack, (int)(componentStack.m_41613_() - 1));
            }
            return componentStack;
        }
        return null;
    }

    @Unique
    private ItemStack powerGrid$handleBelt(ItemStack stack, boolean simulate) {
        BeltBlockEntity beltBE = BeltHelper.getSegmentBE((LevelAccessor)this.getLevel(), (BlockPos)this.getPos());
        if (beltBE == null) {
            return null;
        }
        TransportedItemStackHandlerBehaviour transport = (TransportedItemStackHandlerBehaviour)beltBE.getBehaviour(TransportedItemStackHandlerBehaviour.TYPE);
        if (transport == null) {
            return null;
        }
        MutableBoolean found = new MutableBoolean(false);
        MutableBoolean inserted = new MutableBoolean(false);
        transport.handleCenteredProcessingOnAllItems(0.05f, tis -> {
            if (found.isFalse() && ModdedItems.INCOMPLETE_CIRCUIT.isIn(tis.stack)) {
                found.setTrue();
                ItemStack newCircuit = IncompleteCircuitItem.insert(tis.stack, stack);
                if (newCircuit != null) {
                    inserted.setTrue();
                    if (!simulate) {
                        TransportedItemStack result = new TransportedItemStack(newCircuit);
                        result.lockedExternally = newCircuit.m_150930_((Item)ModdedItems.INCOMPLETE_CIRCUIT.get());
                        transport.handleProcessingOnItem(tis, TransportedItemStackHandlerBehaviour.TransportedResult.convertToAndLeaveHeld(List.of(), (TransportedItemStack)result));
                    }
                }
            }
            return TransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
        });
        if (found.isFalse()) {
            return null;
        }
        if (inserted.isFalse()) {
            return stack;
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.m_41613_() - 1));
    }

    @Inject(method={"insert"}, at={@At(value="INVOKE", target="Lnet/minecraftforge/items/ItemHandlerHelper;insertItem(Lnet/minecraftforge/items/IItemHandler;Lnet/minecraft/world/item/ItemStack;Z)Lnet/minecraft/world/item/ItemStack;")}, cancellable=true)
    private void insertAssembleCircuit(ItemStack stack, boolean simulate, CallbackInfoReturnable<ItemStack> cir) {
        ItemStack remainder = null;
        if (this instanceof AllArmInteractionPointTypes.BeltPoint) {
            remainder = this.powerGrid$handleBelt(stack, simulate);
        } else if (this instanceof AllArmInteractionPointTypes.DepotPoint) {
            remainder = this.powerGrid$handleDepot(stack, simulate);
        }
        if (remainder != null) {
            cir.setReturnValue((Object)remainder);
        }
    }
}

