/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.network.packets;

import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.patryk3211.powergrid.electricity.GlobalElectricNetworks;
import org.patryk3211.powergrid.electricity.sim.node.OwnedFloatingNode;
import org.patryk3211.powergrid.electricity.wire.IWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.WireEndpointType;
import org.patryk3211.powergrid.network.SimplePacket;

public class EndpointTrackingC2SPacket
implements SimplePacket {
    private final IWireEndpoint endpoint;
    private final boolean end;

    public EndpointTrackingC2SPacket(OwnedFloatingNode node, boolean end) {
        this.endpoint = node.endpoint;
        this.end = end;
    }

    public EndpointTrackingC2SPacket(FriendlyByteBuf buf) {
        this.endpoint = WireEndpointType.deserialize(buf.m_130260_());
        this.end = buf.readBoolean();
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130079_(this.endpoint.serialize());
        buf.writeBoolean(this.end);
    }

    @Override
    public void handle(Supplier<NetworkManager.PacketContext> context) {
        NetworkManager.PacketContext ctx = context.get();
        ctx.queue(() -> {
            Player sender = ctx.getPlayer();
            if (!(sender instanceof ServerPlayer)) {
                return;
            }
            Level level = sender.m_9236_();
            GlobalElectricNetworks.getWorldNetworks(level).tracking((ServerPlayer)sender, this.endpoint, this.end);
        });
    }
}

