/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.network.packets;

import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import org.patryk3211.powergrid.electricity.wire.BlockWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.IWire;
import org.patryk3211.powergrid.electricity.wire.IWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.WireEndpointType;
import org.patryk3211.powergrid.network.SimplePacket;

public class TransformerWindingC2SPacket
implements SimplePacket {
    private final int nTurns;
    private final InteractionHand hand;

    public TransformerWindingC2SPacket(int nTurns, InteractionHand hand) {
        this.nTurns = nTurns;
        this.hand = hand;
    }

    public TransformerWindingC2SPacket(FriendlyByteBuf buf) {
        this.nTurns = buf.readInt();
        this.hand = (InteractionHand)buf.m_130066_(InteractionHand.class);
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.nTurns);
        buf.m_130068_((Enum)this.hand);
    }

    @Override
    public void handle(Supplier<NetworkManager.PacketContext> context) {
        NetworkManager.PacketContext ctx = context.get();
        ctx.queue(() -> {
            ItemStack stack = ctx.getPlayer().m_21120_(this.hand);
            if (!(stack.m_41720_() instanceof IWire) || !stack.m_41782_()) {
                return;
            }
            if (stack.m_41783_().m_128441_("Turns")) {
                stack.m_41783_().m_128405_("Turns", this.nTurns);
            } else {
                IWireEndpoint endpoint = WireEndpointType.deserialize(stack.m_41783_());
                if (endpoint == null || endpoint.type() != WireEndpointType.BLOCK) {
                    return;
                }
                BlockWireEndpoint blockEndpoint = (BlockWireEndpoint)endpoint;
                CompoundTag nbt = new CompoundTag();
                nbt.m_128405_("Turns", this.nTurns);
                BlockPos pos = blockEndpoint.getPos();
                nbt.m_128385_("Initiator", new int[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()});
                nbt.m_128405_("Terminal", blockEndpoint.getTerminal());
                stack.m_41751_(nbt);
            }
        });
    }
}

