/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.network.packets;

import dev.architectury.networking.NetworkManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Math;
import org.joml.Vector3f;
import org.patryk3211.powergrid.electricity.particles.SparkParticleData;
import org.patryk3211.powergrid.electricity.particles.ZapParticleData;
import org.patryk3211.powergrid.network.SimplePacket;
import org.patryk3211.powergrid.utility.ClientSideAccess;

public class ZapProjectileS2CPacket
implements SimplePacket {
    private final Type type;
    private Vector3f pos;
    private Direction dir;
    private int targetEntity;
    private List<Integer> affectedEntities;

    public ZapProjectileS2CPacket(BlockHitResult hit) {
        this.type = Type.BLOCK_HIT;
        this.pos = hit.m_82450_().m_252839_();
        this.dir = hit.m_82434_();
    }

    public ZapProjectileS2CPacket(Entity target, Collection<Entity> affected) {
        this.type = Type.ENTITY_HIT;
        this.targetEntity = target.m_19879_();
        this.affectedEntities = affected.stream().map(Entity::m_19879_).collect(Collectors.toList());
    }

    public ZapProjectileS2CPacket(FriendlyByteBuf buf) {
        this.type = (Type)buf.m_130066_(Type.class);
        switch (this.type.ordinal()) {
            case 0: {
                this.pos = buf.m_269394_();
                this.dir = (Direction)buf.m_130066_(Direction.class);
                break;
            }
            case 1: {
                this.targetEntity = buf.readInt();
                int len = buf.readInt();
                this.affectedEntities = new ArrayList<Integer>();
                for (int i = 0; i < len; ++i) {
                    this.affectedEntities.add(buf.readInt());
                }
                break;
            }
        }
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130068_((Enum)this.type);
        switch (this.type.ordinal()) {
            case 0: {
                buf.m_269582_(this.pos);
                buf.m_130068_((Enum)this.dir);
                break;
            }
            case 1: {
                buf.writeInt(this.targetEntity);
                buf.writeInt(this.affectedEntities.size());
                for (Integer i : this.affectedEntities) {
                    buf.writeInt(i.intValue());
                }
                break;
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handle(Supplier<NetworkManager.PacketContext> context) {
        context.get().queue(() -> {
            Level world = ClientSideAccess.world();
            switch (this.type.ordinal()) {
                case 0: {
                    SparkParticleData.explodeParticles(world, this.pos.x, this.pos.y, this.pos.z, this.dir, 20);
                    break;
                }
                case 1: {
                    Entity target = world.m_6815_(this.targetEntity);
                    if (target == null) {
                        return;
                    }
                    Vec3 origin = target.m_20191_().m_82399_();
                    for (Integer id : this.affectedEntities) {
                        Entity entity = world.m_6815_(id.intValue());
                        if (entity == null) continue;
                        Vec3 end = entity.m_20191_().m_82399_();
                        world.m_6485_((ParticleOptions)new ZapParticleData((float)end.f_82479_, (float)end.f_82480_, (float)end.f_82481_, true), true, origin.f_82479_, origin.f_82480_, origin.f_82481_, 0.0, 0.0, 0.0);
                        RandomSource r = world.f_46441_;
                        for (int i = 0; i < 10; ++i) {
                            float pos = r.m_188501_();
                            double x = Math.lerp((double)pos, (double)origin.f_82479_, (double)end.f_82479_);
                            double y = Math.lerp((double)pos, (double)origin.f_82480_, (double)end.f_82480_);
                            double z = Math.lerp((double)pos, (double)origin.f_82481_, (double)end.f_82481_);
                            world.m_7106_((ParticleOptions)SparkParticleData.INSTANCE, x, y, z, (double)(r.m_188501_() - 0.5f), (double)(r.m_188501_() - 0.5f), (double)(r.m_188501_() - 0.5f));
                        }
                    }
                    break;
                }
            }
        });
    }

    private static enum Type {
        BLOCK_HIT,
        ENTITY_HIT;

    }
}

