/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.utility;

import com.google.common.collect.Sets;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Collection;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.electricity.GlobalElectricNetworks;
import org.patryk3211.powergrid.electricity.sim.special.TransmissionLine;
import org.patryk3211.powergrid.utility.forge.PlayerUtilitiesImpl;

public class PlayerUtilities {
    public static boolean hasEnoughItems(Player player, Item item, int requiredCount) {
        if (player.m_7500_()) {
            return true;
        }
        Inventory inv = player.m_150109_();
        return inv.m_18947_(item) >= requiredCount;
    }

    public static boolean hasEnoughItems(@Nullable Player player, ItemStack usedStack, int requiredCount) {
        if (player != null) {
            return PlayerUtilities.hasEnoughItems(player, usedStack.m_41720_(), requiredCount);
        }
        return usedStack.m_41613_() >= requiredCount;
    }

    public static void removeItems(Player player, Item item, int count) {
        if (player.m_7500_()) {
            return;
        }
        Inventory inv = player.m_150109_();
        ContainerHelper.m_18956_((Container)inv, stack -> stack.m_150930_(item), (int)count, (boolean)false);
    }

    public static void removeItems(@Nullable Player player, ItemStack usedStack, int count) {
        if (player != null) {
            PlayerUtilities.removeItems(player, usedStack.m_41720_(), count);
            return;
        }
        usedStack.m_41774_(Math.min(count, usedStack.m_41613_()));
    }

    @NotNull
    public static Collection<ServerPlayer> partialTracking(@NotNull ServerLevel world, @NotNull TransmissionLine line) {
        Set<ServerPlayer> players1 = GlobalElectricNetworks.getWorldNetworks((Level)world).getTrackers(line.getNode1().endpoint);
        Set<ServerPlayer> players2 = GlobalElectricNetworks.getWorldNetworks((Level)world).getTrackers(line.getNode2().endpoint);
        return Sets.symmetricDifference(players1, players2);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isFake(Player player) {
        return PlayerUtilitiesImpl.isFake(player);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean cancelBreak(Level world, BlockPos pos, Player player) {
        void var2_2;
        void var1_1;
        return PlayerUtilitiesImpl.cancelBreak(world, (BlockPos)var1_1, (Player)var2_2);
    }
}

