/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.circuits.components;

import com.google.common.collect.ImmutableCollection;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.patryk3211.powergrid.PowerGrid;
import org.patryk3211.powergrid.circuits.circuitboard.CircuitBoardBlockEntity;
import org.patryk3211.powergrid.circuits.circuitboard.ComponentCircuitBuilder;
import org.patryk3211.powergrid.circuits.components.IGoggleLabel;
import org.patryk3211.powergrid.circuits.components.IInteractableComponent;
import org.patryk3211.powergrid.circuits.components.OrientableComponent;
import org.patryk3211.powergrid.circuits.components.properties.ComponentProperty;
import org.patryk3211.powergrid.circuits.components.properties.IntProperty;
import org.patryk3211.powergrid.circuits.schematic.ComponentFootprint;
import org.patryk3211.powergrid.circuits.schematic.PlacedComponent;
import org.patryk3211.powergrid.collections.ModdedSoundEvents;
import org.patryk3211.powergrid.electricity.sim.SwitchedWire;

public class ButtonComponent
extends OrientableComponent
implements IInteractableComponent,
IGoggleLabel {
    public static final IntProperty STATE = (IntProperty)new IntProperty("powergrid", "button_state", 0, 0, 10).hidden();

    public ButtonComponent(ComponentFootprint footprint) {
        super(footprint);
    }

    @Override
    protected void addProperties(ImmutableCollection.Builder<ComponentProperty<?>> properties) {
        super.addProperties(properties);
        properties.add((Object[])new ComponentProperty[]{STATE, LABEL, ButtonComponent.current(16.0f)});
    }

    @Override
    public void bake(@NotNull PlacedComponent placed, @NotNull ComponentCircuitBuilder builder,  @NotNull ThermalBuilder.IEmitter thermals) {
        SwitchedWire wire = builder.connectSwitch(0.1f, builder.terminalNode(0), builder.terminalNode(1), false);
        placed.add(wire);
        thermals.builder().setMaxCurrent(16.0f, 0.1f, 150.0f).setThermalMass(0.01f).addHeatSource(wire);
    }

    @Override
    public boolean tick(@NotNull PlacedComponent placed) {
        Integer state = placed.get(STATE);
        if (state > 0) {
            state = state - 1;
            placed.set(STATE, state);
            if (state == 0) {
                placed.onServerWorld(() -> world -> ModdedSoundEvents.MICROBUTTON_OFF.playOnServer(world, (Vec3i)placed.getPos()));
                placed.onClientWorld(() -> world -> ButtonComponent.modelChanged(placed.getPos()));
            }
        }
        if (!placed.wires.isEmpty()) {
            SwitchedWire wire = (SwitchedWire)placed.wires.get(0);
            wire.setState(state != 0);
        }
        return true;
    }

    @Override
    @NotNull
    public ResourceLocation getModelId(@NotNull PlacedComponent component) {
        if (component.get(STATE) == 0) {
            return PowerGrid.asResource("button");
        }
        return PowerGrid.asResource("button_on");
    }

    @Override
    @NotNull
    public Collection<ResourceLocation> requestedModels() {
        return List.of(PowerGrid.asResource("button"), PowerGrid.asResource("button_on"));
    }

    @Override
    public VoxelShape getShape(@NotNull PlacedComponent placed) {
        return IInteractableComponent.extrudedFootprint(placed, 0.125f);
    }

    @Override
    public InteractionResult use(CircuitBoardBlockEntity be, PlacedComponent component, Player player) {
        if (component.get(STATE) == 0) {
            component.onServerWorld(() -> world -> ModdedSoundEvents.MICROBUTTON_ON.playOnServer(world, (Vec3i)component.getPos()));
            component.onClientWorld(() -> world -> ButtonComponent.modelChanged(component.getPos()));
        }
        component.set(STATE, 10);
        return InteractionResult.SUCCESS;
    }
}

