/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.circuits.editor;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.menu.AbstractSimiContainerScreen;
import com.simibubi.create.foundation.gui.widget.IconButton;
import java.util.List;
import java.util.UUID;
import net.createmod.catnip.gui.element.ScreenElement;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.patryk3211.powergrid.PowerGrid;
import org.patryk3211.powergrid.circuits.components.properties.Orientation;
import org.patryk3211.powergrid.circuits.editor.CircuitDesignTableBlockEntity;
import org.patryk3211.powergrid.circuits.editor.CircuitEditMenu;
import org.patryk3211.powergrid.circuits.gui.CircuitEditWidget;
import org.patryk3211.powergrid.circuits.gui.ComponentPropertiesWidget;
import org.patryk3211.powergrid.circuits.schematic.CircuitLayer;
import org.patryk3211.powergrid.circuits.schematic.CircuitSchematic;
import org.patryk3211.powergrid.circuits.schematic.CircuitSchematicRender;
import org.patryk3211.powergrid.circuits.schematic.ComponentFootprint;
import org.patryk3211.powergrid.circuits.schematic.ISchematicHolder;
import org.patryk3211.powergrid.circuits.schematic.Line;
import org.patryk3211.powergrid.circuits.schematic.PlacedComponent;
import org.patryk3211.powergrid.collections.ModIcons;
import org.patryk3211.powergrid.collections.ModdedKeys;
import org.patryk3211.powergrid.collections.ModdedPackets;
import org.patryk3211.powergrid.collections.ModdedSoundEvents;
import org.patryk3211.powergrid.network.packets.ChangeScreenC2SPacket;
import org.patryk3211.powergrid.network.packets.SaveSchematicC2SPacket;
import org.patryk3211.powergrid.utility.Lang;

public class CircuitDesignTableEditScreen<T extends CircuitEditMenu<?>>
extends AbstractSimiContainerScreen<T> {
    private static final ResourceLocation BACKGROUND = PowerGrid.texture("gui/circuit_design_table_edit");
    private static final int WIDTH = 182;
    private static final int HEIGHT = 160;
    public static final int CIRCUIT_SCALE = 8;
    private static final Component TOOLTIP_SAVE = Lang.translateDirect("gui.circuit_designer.save", new Object[0]);
    private static final Component TOOLTIP_DISCARD = Lang.translateDirect("gui.circuit_designer.discard", new Object[0]);
    private static final Component TOOLTIP_CONNECT = Lang.translateDirect("gui.circuit_designer.connect", new Object[0]);
    private static final Component TOOLTIP_DELETE = Lang.translateDirect("gui.circuit_designer.delete", new Object[0]);
    private static final Component TOOLTIP_SELECT = Lang.translateDirect("gui.circuit_designer.select", new Object[0]);
    private static final Component TOOLTIP_LAYER = Lang.translateDirect("gui.circuit_designer.layer", new Object[0]);
    private static final Component TOOLTIP_PLACEABLE = Lang.translate("gui.circuit_designer.placeable", new Object[0]).style(ChatFormatting.DARK_GREEN).style(ChatFormatting.ITALIC).component();
    private static final Component TEXT_SAVING = Lang.translateDirect("gui.circuit_designer.saving", new Object[0]);
    private static final Component TEXT_NOT_SAVED = Lang.translateDirect("gui.circuit_designer.not_saved", new Object[0]);
    private final CircuitSchematic schematic;
    private List<Line> fgLines;
    private List<Line> bgLines;
    private boolean tracesChanged = false;
    private Tool currentTool = Tool.SELECT;
    private PlacedComponent currentComponent = null;
    private Slot selectedSlot = null;
    private PlacedComponent selectedComponent = null;
    private CircuitEditWidget editWidget;
    private boolean backLayer = false;
    private EditBox nameField;
    private IconButton acceptBtn;
    private IconButton cancelBtn;
    private IconButton connectBtn;
    private IconButton deleteBtn;
    private IconButton selectBtn;
    private IconButton layerBtn;
    private ComponentPropertiesWidget propertiesWidget;
    private boolean changed = false;
    private boolean saving = false;
    private int unsavedPopupTimeout = 0;

    public CircuitDesignTableEditScreen(T container, Inventory inv, Component title) {
        super(container, inv, title);
        this.schematic = new CircuitSchematic(((ISchematicHolder)((SmartBlockEntity)((CircuitEditMenu)((Object)container)).contentHolder)).getSchematic());
        this.fgLines = this.schematic.front().calculateLines();
        this.bgLines = this.schematic.back().calculateLines();
    }

    private static SoundManager soundManager() {
        return Minecraft.m_91087_().m_91106_();
    }

    private static void playSound(AllSoundEvents.SoundEntry sound) {
        CircuitDesignTableEditScreen.soundManager().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)sound.getMainEvent(), (float)1.0f));
    }

    public void save() {
        ModdedPackets.getChannel().sendToServer((Object)new SaveSchematicC2SPacket((SmartBlockEntity)((CircuitEditMenu)this.f_97732_).contentHolder, this.nameField.m_94155_(), this.schematic));
        Object object = ((CircuitEditMenu)this.f_97732_).contentHolder;
        if (object instanceof CircuitDesignTableBlockEntity) {
            CircuitDesignTableBlockEntity table = (CircuitDesignTableBlockEntity)object;
            ((ISchematicHolder)((SmartBlockEntity)((CircuitEditMenu)this.f_97732_).contentHolder)).setSchematic(this.schematic);
            this.saving = true;
        } else {
            this.m_7379_();
        }
    }

    public void discard() {
        Object object = ((CircuitEditMenu)this.f_97732_).contentHolder;
        if (object instanceof CircuitDesignTableBlockEntity) {
            CircuitDesignTableBlockEntity table = (CircuitDesignTableBlockEntity)object;
            ModdedPackets.getChannel().sendToServer((Object)new ChangeScreenC2SPacket(table, 0));
        } else {
            this.m_7379_();
        }
    }

    protected void flipLayer() {
        if (this.tracesChanged) {
            if (this.backLayer) {
                this.bgLines = this.schematic.back().calculateLines();
            } else {
                this.fgLines = this.schematic.front().calculateLines();
            }
            this.tracesChanged = false;
        }
        this.backLayer = !this.backLayer;
        this.layerBtn.setIcon((ScreenElement)(this.backLayer ? ModIcons.I_LAYER_BACK : ModIcons.I_LAYER_FRONT));
    }

    protected void m_7856_() {
        this.setWindowSize(182, 164 + AllGuiTextures.PLAYER_INVENTORY.getHeight());
        this.setWindowOffset(11, 0);
        super.m_7856_();
        this.editWidget = new CircuitEditWidget(this.f_96547_, this.schematic, this.f_97735_ + 13 - 11, this.f_97736_ + 22, 128, 128);
        this.propertiesWidget = new ComponentPropertiesWidget(this.f_96547_, this.f_97735_ - 15, this.f_97736_ + 12);
        String name = ((ISchematicHolder)((SmartBlockEntity)((CircuitEditMenu)this.f_97732_).contentHolder)).getSchematicName();
        this.nameField = new EditBox(this.f_96547_, this.f_97735_ + 4 - 11, this.f_97736_ + 3, 148, 9, (Component)Component.m_237119_());
        this.nameField.m_94144_(name);
        this.nameField.m_94202_(-1);
        this.nameField.m_94205_(-1);
        this.nameField.m_94182_(false);
        this.nameField.m_94199_(35);
        this.nameField.m_94186_(true);
        this.selectedComponent = null;
        this.currentComponent = null;
        this.selectedSlot = null;
        int BUTTONS_X = this.f_97735_ + 154 - 11;
        this.acceptBtn = new IconButton(BUTTONS_X, this.f_97736_ + 43, (ScreenElement)AllIcons.I_CONFIRM);
        this.cancelBtn = new IconButton(BUTTONS_X, this.f_97736_ + 63, (ScreenElement)ModIcons.I_CANCEL);
        this.connectBtn = new IconButton(BUTTONS_X, this.f_97736_ + 83, (ScreenElement)ModIcons.I_CONNECT);
        this.deleteBtn = new IconButton(BUTTONS_X, this.f_97736_ + 101, (ScreenElement)AllIcons.I_TRASH);
        this.selectBtn = new IconButton(BUTTONS_X, this.f_97736_ + 119, (ScreenElement)AllIcons.I_TARGET);
        this.layerBtn = new IconButton(BUTTONS_X, this.f_97736_ + 139, (ScreenElement)ModIcons.I_LAYER_FRONT);
        this.acceptBtn.setToolTip(TOOLTIP_SAVE);
        this.cancelBtn.setToolTip(TOOLTIP_DISCARD);
        this.connectBtn.setToolTip(TOOLTIP_CONNECT);
        this.deleteBtn.setToolTip(TOOLTIP_DELETE);
        this.selectBtn.setToolTip(TOOLTIP_SELECT);
        this.layerBtn.setToolTip(TOOLTIP_LAYER);
        this.acceptBtn.withCallback(this::save);
        this.cancelBtn.withCallback(this::discard);
        this.connectBtn.withCallback(() -> this.toolSelect(Tool.CONNECT));
        this.deleteBtn.withCallback(() -> this.toolSelect(Tool.DELETE));
        this.selectBtn.withCallback(() -> this.toolSelect(Tool.SELECT));
        this.layerBtn.withCallback(this::flipLayer);
        this.editWidget.setSelectionCancelledCallback(() -> this.toolSelect(Tool.SELECT));
        this.toolSelect(Tool.SELECT);
        this.m_142416_((GuiEventListener)this.nameField);
        this.m_142416_((GuiEventListener)this.editWidget);
        this.m_142416_((GuiEventListener)this.propertiesWidget);
        this.m_142416_((GuiEventListener)this.acceptBtn);
        this.m_142416_((GuiEventListener)this.cancelBtn);
        this.m_142416_((GuiEventListener)this.connectBtn);
        this.m_142416_((GuiEventListener)this.deleteBtn);
        this.m_142416_((GuiEventListener)this.selectBtn);
        this.m_142416_((GuiEventListener)this.layerBtn);
    }

    public Rect2i ghostTarget() {
        return new Rect2i(this.editWidget.m_252754_(), this.editWidget.m_252907_(), this.editWidget.m_5711_(), this.editWidget.m_93694_());
    }

    protected List<Component> m_280553_(ItemStack stack) {
        List lines = super.m_280553_(stack);
        if (org.patryk3211.powergrid.circuits.components.Component.forItem(stack.m_41720_()) != null) {
            lines.add(TOOLTIP_PLACEABLE);
        }
        return lines;
    }

    private void toolSelect(Tool tool) {
        if (this.currentComponent != null) {
            this.currentComponent = null;
            this.selectedSlot = null;
            this.editWidget.stopComponentPlacement();
        }
        if (this.selectedComponent != null) {
            this.propertiesWidget.setComponent(null);
            this.selectedComponent = null;
        }
        this.currentTool = tool;
        switch (tool.ordinal()) {
            case 0: {
                this.editWidget.requestSelection(CircuitEditWidget.SelectMode.LINE, -2130706433, this::placeTrace);
                break;
            }
            case 1: {
                this.editWidget.requestSelection(CircuitEditWidget.SelectMode.AREA, -2130739072, this::deleteArea);
                break;
            }
            case 2: {
                this.editWidget.requestSelection(CircuitEditWidget.SelectMode.POINT, -2130706433, this::selectComponent);
            }
        }
    }

    private void toolSelect(Slot slot) {
        org.patryk3211.powergrid.circuits.components.Component component = org.patryk3211.powergrid.circuits.components.Component.forItem(slot.m_7993_().m_41720_());
        if (component == null) {
            return;
        }
        this.editWidget.cancelSelection();
        if (this.selectedComponent != null) {
            this.selectedComponent = null;
            this.propertiesWidget.setComponent(null);
        }
        PlacedComponent placed = new PlacedComponent(component, 0, 0, UUID.randomUUID());
        this.editWidget.componentPlacement(placed, this::placeComponent);
        this.currentComponent = placed;
        this.selectedSlot = slot;
    }

    public void toolSelect(Item item) {
        org.patryk3211.powergrid.circuits.components.Component component = org.patryk3211.powergrid.circuits.components.Component.forItem(item);
        if (component == null) {
            return;
        }
        this.editWidget.cancelSelection();
        if (this.selectedComponent != null) {
            this.selectedComponent = null;
            this.propertiesWidget.setComponent(null);
        }
        PlacedComponent placed = new PlacedComponent(component, 0, 0, UUID.randomUUID());
        this.editWidget.componentPlacement(placed, this::placeComponent);
        this.currentComponent = placed;
        this.selectedSlot = null;
    }

    private CircuitEditWidget.SelectionResult placeTrace(int x1, int y1, int x2, int y2, int clickX, int clickY) {
        CircuitLayer layer = this.backLayer ? this.schematic.back() : this.schematic.front();
        boolean isTrace = layer.get(clickX, clickY);
        layer.fill(x1, y1, x2, y2);
        Line line = x1 == x2 ? new Line(true, x1, y1, y2 + 1) : new Line(false, y1, x1, x2 + 1);
        this.tracesChanged = true;
        if (this.backLayer) {
            this.bgLines.add(line);
        } else {
            this.fgLines.add(line);
        }
        this.changed = true;
        CircuitDesignTableEditScreen.playSound(ModdedSoundEvents.UI_PLACE_TRACE);
        if (this.schematic.isPad(clickX, clickY) || isTrace) {
            return CircuitEditWidget.SelectionResult.BEGIN_NEW;
        }
        return CircuitEditWidget.SelectionResult.CONTINUE;
    }

    public CircuitEditWidget.SelectionResult deleteArea(int x1, int y1, int x2, int y2, int clickX, int clickY) {
        CircuitLayer layer = this.backLayer ? this.schematic.back() : this.schematic.front();
        layer.clear(x1, y1, x2, y2);
        if (this.backLayer) {
            this.bgLines = layer.calculateLines();
        } else {
            this.fgLines = layer.calculateLines();
        }
        CircuitDesignTableEditScreen.playSound(ModdedSoundEvents.UI_DELETE_AREA);
        this.changed = true;
        return CircuitEditWidget.SelectionResult.BEGIN_NEW;
    }

    public CircuitEditWidget.SelectionResult selectComponent(int x1, int y1, int x2, int y2, int clickX, int clickY) {
        PlacedComponent placed = this.schematic.getComponent(x1 / 1, y1 / 1);
        if (placed == null) {
            CircuitDesignTableEditScreen.playSound(ModdedSoundEvents.UI_FAIL);
            return CircuitEditWidget.SelectionResult.IGNORE;
        }
        this.selectedComponent = placed;
        this.propertiesWidget.setComponent(this.selectedComponent);
        CircuitDesignTableEditScreen.playSound(ModdedSoundEvents.UI_SELECT_COMPONENT);
        this.changed = true;
        return CircuitEditWidget.SelectionResult.BEGIN_NEW;
    }

    public void placeComponent(int x, int y) {
        if (this.schematic.canPlace(this.currentComponent, x, y)) {
            CircuitDesignTableEditScreen.playSound(ModdedSoundEvents.UI_PLACE_COMPONENT);
            this.schematic.placeComponent(this.currentComponent, x, y);
            this.changed = true;
        } else {
            CircuitDesignTableEditScreen.playSound(ModdedSoundEvents.UI_FAIL);
        }
    }

    protected void m_7286_(GuiGraphics ctx, float delta, int mouseX, int mouseY) {
        int bgX = this.getLeftOfCentered(182);
        int invY = this.f_97736_ + 160 + 4;
        this.renderPlayerInventory(ctx, bgX + 182 - AllGuiTextures.PLAYER_INVENTORY.getWidth(), invY);
        for (int k = 0; k < ((CircuitEditMenu)this.f_97732_).f_38839_.size(); ++k) {
            Slot slot = (Slot)((CircuitEditMenu)this.f_97732_).f_38839_.get(k);
            if (!slot.m_6659_() || !slot.m_6657_()) continue;
            if (slot == this.selectedSlot) {
                ctx.m_280218_(BACKGROUND, this.f_97735_ + slot.f_40220_ - 1, this.f_97736_ + slot.f_40221_ - 1, 232, 18, 18, 18);
                continue;
            }
            if (org.patryk3211.powergrid.circuits.components.Component.forItem(slot.m_7993_().m_41720_()) == null) continue;
            ctx.m_280218_(BACKGROUND, this.f_97735_ + slot.f_40220_ - 1, this.f_97736_ + slot.f_40221_ - 1, 232, 0, 18, 18);
        }
        ctx.m_280218_(BACKGROUND, bgX, this.f_97736_, 0, 0, 182, 160);
        int bpX = bgX + 13;
        int bpY = this.f_97736_ + 22;
        if (!this.backLayer) {
            CircuitSchematicRender.renderLayer(this.bgLines, ctx, bpX, bpY, 8, -2130706433);
            CircuitSchematicRender.renderLayer(this.fgLines, ctx, bpX, bpY, 8, -1);
        } else {
            CircuitSchematicRender.renderLayer(this.fgLines, ctx, bpX, bpY, 8, -2130706433);
            CircuitSchematicRender.renderLayer(this.bgLines, ctx, bpX, bpY, 8, -1);
        }
        CircuitSchematicRender.renderComponents(this.schematic, ctx, bpX, bpY, 8, mouseX, mouseY);
        if (this.currentTool.y > 0) {
            ctx.m_280218_(BACKGROUND, this.f_97735_ + 173 - 11, this.f_97736_ + this.currentTool.y, 250, 0, 6, 18);
        }
        if (this.selectedComponent != null) {
            ComponentFootprint footprint = this.selectedComponent.footprint();
            ctx.m_280637_(bpX + this.selectedComponent.x * 8 * 1 - 1, bpY + this.selectedComponent.y * 8 * 1 - 1, footprint.getWidth() * 8 * 1 + 2, footprint.getHeight() * 8 * 1 + 2, -2132035020);
        }
        if (this.unsavedPopupTimeout > 0) {
            int color = 0xFF6060;
            int alpha = Math.min(this.unsavedPopupTimeout, 20) * 255 / 20;
            ctx.m_280653_(this.f_96547_, TEXT_NOT_SAVED, this.f_96543_ / 2, this.f_97736_ - 12, color |= alpha << 24);
        }
    }

    protected void m_181908_() {
        super.m_181908_();
        if (!((CircuitEditMenu)this.f_97732_).m_142621_().m_41619_()) {
            this.toolSelect(((CircuitEditMenu)this.f_97732_).m_142621_().m_41720_());
            ((CircuitEditMenu)this.f_97732_).m_142503_(ItemStack.f_41583_);
        }
        if (this.unsavedPopupTimeout > 0) {
            --this.unsavedPopupTimeout;
        }
    }

    protected void m_280072_(GuiGraphics context, int mouseX, int mouseY) {
        super.m_280072_(context, mouseX, mouseY);
        int x = this.editWidget.m_252754_();
        int y = this.editWidget.m_252907_();
        int gridX = (mouseX - x) / 8;
        int gridY = (mouseY - y) / 8;
        for (PlacedComponent placed : this.schematic.components()) {
            Component tooltip;
            ComponentFootprint footprint;
            int localX = gridX - placed.x * 1;
            int localY = gridY - placed.y * 1;
            if (localX < 0 || localY < 0 || localX >= (footprint = placed.footprint()).getWidth() * 1 || localY >= footprint.getHeight() * 1 || (tooltip = footprint.getTooltip(localX, localY)) == null) continue;
            context.m_280557_(this.f_96547_, tooltip, mouseX, mouseY);
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        boolean handled;
        if (keyCode == 256) {
            if (!this.changed || this.saving) {
                this.m_7379_();
            } else {
                CircuitDesignTableEditScreen.playSound(ModdedSoundEvents.UI_FAIL);
                this.unsavedPopupTimeout = 60;
            }
            return true;
        }
        GuiEventListener focused = this.m_7222_();
        boolean bl = handled = focused != null && focused.m_7933_(keyCode, scanCode, modifiers);
        if (handled) {
            return true;
        }
        if (this.selectedComponent != null || focused instanceof EditBox) {
            return false;
        }
        KeyMapping[] hotbar = this.f_96541_.f_91066_.f_92056_;
        for (int i = 0; i < hotbar.length; ++i) {
            if (!hotbar[i].m_90832_(keyCode, scanCode)) continue;
            this.toolSelect(((CircuitEditMenu)this.f_97732_).m_38853_(i + 27));
            return true;
        }
        if (ModdedKeys.ROTATE_COMPONENT.matchesKey(keyCode, scanCode)) {
            if (this.currentComponent != null && this.currentComponent.has(Orientation.PROPERTY)) {
                Orientation current = this.currentComponent.get(Orientation.PROPERTY);
                current = Screen.m_96638_() ? current.getCounterClockwise() : current.getClockwise();
                this.currentComponent.set(Orientation.PROPERTY, current);
                CircuitDesignTableEditScreen.playSound(ModdedSoundEvents.UI_COMPONENT_ROTATE);
                return true;
            }
        } else {
            if (ModdedKeys.PLACE_TRACE.matchesKey(keyCode, scanCode)) {
                this.toolSelect(Tool.CONNECT);
                CircuitDesignTableEditScreen.playSound(ModdedSoundEvents.UI_PLACE_TRACE);
                return true;
            }
            if (ModdedKeys.DELETE_AREA.matchesKey(keyCode, scanCode)) {
                this.toolSelect(Tool.DELETE);
                CircuitDesignTableEditScreen.playSound(ModdedSoundEvents.UI_DELETE_AREA);
                return true;
            }
            if (ModdedKeys.PICK_COMPONENT.matchesKey(keyCode, scanCode)) {
                this.toolSelect(Tool.SELECT);
                CircuitDesignTableEditScreen.playSound(ModdedSoundEvents.UI_SELECT_COMPONENT);
                return true;
            }
            if (ModdedKeys.SWITCH_LAYER.matchesKey(keyCode, scanCode)) {
                this.flipLayer();
                CircuitDesignTableEditScreen.playSound(ModdedSoundEvents.UI_CLICK);
                return true;
            }
        }
        return false;
    }

    public void m_88315_(@NotNull GuiGraphics ctx, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(ctx, mouseX, mouseY, partialTicks);
        if (this.saving) {
            RenderSystem.disableDepthTest();
            PoseStack ms = ctx.m_280168_();
            ms.m_85836_();
            ms.m_252880_(0.0f, 0.0f, 10.0f);
            ctx.m_280024_(0, 0, this.f_96543_, this.f_96544_, -1072689136, -804253680);
            AllIcons.I_CONFIG_SAVE.render(ctx, this.f_96543_ / 2 - 8, this.f_96544_ / 2 - 8);
            ctx.m_280653_(this.f_96547_, TEXT_SAVING, this.f_96543_ / 2, this.f_96544_ / 2 + 12, -1);
            ms.m_85849_();
        }
    }

    protected void m_6597_(Slot slot, int slotId, int button, ClickType actionType) {
        if (slot == null || !slot.m_6657_() || actionType != ClickType.PICKUP) {
            return;
        }
        this.toolSelect(slot);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 1) {
            if (this.currentComponent == null && this.currentTool == Tool.SELECT) {
                int gridX = (int)((mouseX - (double)this.editWidget.m_252754_()) / 8.0);
                int gridY = (int)((mouseY - (double)this.editWidget.m_252907_()) / 8.0);
                if (gridX >= 0 && gridY >= 0 && gridX < 16 && gridY < 16) {
                    this.schematic.removeComponents(gridX, gridY, 1, 1);
                }
            }
            if (this.currentComponent != null) {
                this.currentComponent = null;
                this.selectedSlot = null;
                this.editWidget.stopComponentPlacement();
            }
            if (this.selectedComponent != null) {
                this.selectedComponent = null;
                this.propertiesWidget.setComponent(null);
            }
            this.editWidget.cancelSelection();
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    private static enum Tool {
        CONNECT(83),
        DELETE(101),
        SELECT(119);

        public final int y;

        private Tool(int y) {
            this.y = y;
        }
    }
}

