/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.circuits.editor;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.menu.AbstractSimiContainerScreen;
import com.simibubi.create.foundation.gui.widget.IconButton;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import net.createmod.catnip.gui.element.ScreenElement;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.NotNull;
import org.patryk3211.powergrid.PowerGrid;
import org.patryk3211.powergrid.circuits.editor.CircuitDesignTableBlockEntity;
import org.patryk3211.powergrid.circuits.editor.CircuitDesignTableLoadMenu;
import org.patryk3211.powergrid.circuits.gui.CircuitFileBox;
import org.patryk3211.powergrid.circuits.schematic.CircuitSchematic;
import org.patryk3211.powergrid.collections.ModIcons;
import org.patryk3211.powergrid.collections.ModdedPackets;
import org.patryk3211.powergrid.collections.ModdedSoundEvents;
import org.patryk3211.powergrid.network.packets.ChangeScreenC2SPacket;
import org.patryk3211.powergrid.network.packets.SaveSchematicC2SPacket;
import org.patryk3211.powergrid.utility.Lang;

public class CircuitDesignTableLoadScreen
extends AbstractSimiContainerScreen<CircuitDesignTableLoadMenu> {
    private static final ResourceLocation BACKGROUND = PowerGrid.texture("gui/circuit_design_table_load");
    private static final int WIDTH = 214;
    private static final int HEIGHT = 85;
    private static final Component NO_NAME = Lang.translateDirect("gui.circuit_designer.no_name", new Object[0]);
    private static final Component CONFIRM_OVERWRITE = Lang.translateDirect("gui.circuit_designer.confirm_overwrite", new Object[0]);
    private static final Component DOESNT_EXIST = Lang.translateDirect("gui.circuit_designer.doesnt_exist", new Object[0]);
    private static final Component INVALID_FILE = Lang.translateDirect("gui.circuit_designer.invalid_file", new Object[0]);
    private static final Component FILE_DIALOG = Lang.translateDirect("gui.circuit_designer.file_dialog", new Object[0]);
    private static final Component CANCEL = Lang.translateDirect("gui.circuit_designer.cancel", new Object[0]);
    private static final Component FILE_SAVE = Lang.translateDirect("gui.circuit_designer.file_save", new Object[0]);
    private static final Component FILE_LOAD = Lang.translateDirect("gui.circuit_designer.file_load", new Object[0]);
    private IconButton cancelBtn;
    private IconButton saveBtn;
    private IconButton loadBtn;
    private IconButton folderBtn;
    private CircuitFileBox fileNameInput;
    private Component popupText;
    private int popupTimeout;
    private boolean confirm;

    public CircuitDesignTableLoadScreen(CircuitDesignTableLoadMenu container, Inventory inv, Component title) {
        super((AbstractContainerMenu)container, inv, title);
    }

    private static SoundManager soundManager() {
        return Minecraft.m_91087_().m_91106_();
    }

    private static void playSound(AllSoundEvents.SoundEntry sound) {
        CircuitDesignTableLoadScreen.soundManager().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)sound.getMainEvent(), (float)1.0f));
    }

    private void save() {
        if (this.fileNameInput.m_94155_().isEmpty()) {
            this.popup(NO_NAME);
            return;
        }
        try {
            Path file = Path.of("circuits", this.fileNameInput.m_94155_());
            if (!file.toString().endsWith(".nbt")) {
                file = Path.of(String.valueOf(file) + ".nbt", new String[0]);
            }
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            if (Files.exists(file, new LinkOption[0]) && !this.confirm) {
                this.confirm = true;
                this.popup(CONFIRM_OVERWRITE);
                return;
            }
            Files.deleteIfExists(file);
            try (OutputStream out = Files.newOutputStream(file, StandardOpenOption.CREATE);){
                NbtIo.m_128947_((CompoundTag)((CircuitDesignTableBlockEntity)((CircuitDesignTableLoadMenu)this.f_97732_).contentHolder).schematic.serializeNbt(), (OutputStream)out);
            }
            this.back();
        }
        catch (IOException e) {
            PowerGrid.LOGGER.error("Failed to save circuit schematic", (Throwable)e);
        }
        this.confirm = false;
    }

    private void load() {
        Path file = Path.of("circuits", this.fileNameInput.m_94155_());
        if (!file.toString().endsWith(".nbt")) {
            file = Path.of(String.valueOf(file) + ".nbt", new String[0]);
        }
        if (!Files.exists(file, new LinkOption[0])) {
            this.popup(DOESNT_EXIST);
            return;
        }
        try (InputStream in = Files.newInputStream(file, StandardOpenOption.READ);){
            CompoundTag nbt = NbtIo.m_128939_((InputStream)in);
            CircuitSchematic schematic = CircuitSchematic.fromNbt(nbt);
            ModdedPackets.getChannel().sendToServer((Object)new SaveSchematicC2SPacket((CircuitDesignTableBlockEntity)((CircuitDesignTableLoadMenu)this.f_97732_).contentHolder, null, schematic));
        }
        catch (IOException e) {
            PowerGrid.LOGGER.error("Failed to load circuit schematic", (Throwable)e);
        }
        catch (RuntimeException e) {
            this.popup(INVALID_FILE);
        }
    }

    private void back() {
        ModdedPackets.getChannel().sendToServer((Object)new ChangeScreenC2SPacket((CircuitDesignTableBlockEntity)((CircuitDesignTableLoadMenu)this.f_97732_).contentHolder, 0));
    }

    protected void m_7856_() {
        this.setWindowSize(214, 85);
        super.m_7856_();
        this.fileNameInput = new CircuitFileBox(this.f_96547_, this.f_97735_ + 48, this.f_97736_ + 28, 135, 10, (Component)Component.m_237119_());
        this.cancelBtn = new IconButton(this.f_97735_ + 20, this.f_97736_ + 58, (ScreenElement)ModIcons.I_CANCEL);
        this.cancelBtn.withCallback(this::back);
        this.cancelBtn.setToolTip(CANCEL);
        this.saveBtn = new IconButton(this.f_97735_ + 146, this.f_97736_ + 58, (ScreenElement)AllIcons.I_CONFIG_SAVE);
        this.saveBtn.withCallback(this::save);
        this.saveBtn.setToolTip(FILE_SAVE);
        this.loadBtn = new IconButton(this.f_97735_ + 168, this.f_97736_ + 58, (ScreenElement)ModIcons.I_UPLOAD);
        this.loadBtn.withCallback(this::load);
        this.loadBtn.setToolTip(FILE_LOAD);
        this.folderBtn = new IconButton(this.f_97735_ + 20, this.f_97736_ + 23, (ScreenElement)AllIcons.I_OPEN_FOLDER);
        this.folderBtn.withCallback(() -> Util.m_137581_().m_137644_(Paths.get("circuits/", new String[0]).toFile()));
        this.m_142416_((GuiEventListener)this.cancelBtn);
        this.m_142416_((GuiEventListener)this.saveBtn);
        this.m_142416_((GuiEventListener)this.loadBtn);
        this.m_142416_((GuiEventListener)this.folderBtn);
        this.m_142416_((GuiEventListener)this.fileNameInput);
    }

    protected void m_181908_() {
        super.m_181908_();
        this.fileNameInput.m_94120_();
        if (this.popupTimeout > 0) {
            --this.popupTimeout;
        }
    }

    private void popup(Component text) {
        CircuitDesignTableLoadScreen.playSound(ModdedSoundEvents.UI_FAIL);
        this.popupText = text;
        this.popupTimeout = 60;
    }

    protected void m_7286_(GuiGraphics ctx, float partialTick, int mouseX, int mouseY) {
        int bgX = this.getLeftOfCentered(214);
        ctx.m_280218_(BACKGROUND, bgX, this.f_97736_, 0, 0, 214, 85);
        ctx.m_280614_(this.f_96547_, FILE_DIALOG, this.f_97735_ + 5, this.f_97736_ + 4, 0x404040, false);
        if (this.popupTimeout > 0) {
            int color = 0xFF6060;
            int alpha = Math.min(this.popupTimeout, 20) * 255 / 20;
            ctx.m_280653_(this.f_96547_, this.popupText, this.f_96543_ / 2, this.f_97736_ - 12, color |= alpha << 24);
        }
    }

    protected void renderForeground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderForeground(graphics, mouseX, mouseY, partialTicks);
        if (this.fileNameInput != null && this.fileNameInput.m_5953_(mouseX, mouseY)) {
            List<Component> tooltip = this.fileNameInput.getToolTip();
            if (tooltip.isEmpty()) {
                return;
            }
            graphics.m_280666_(this.f_96547_, tooltip, mouseX, mouseY);
        }
    }
}

