/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.circuits.schematic;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import net.minecraft.nbt.LongArrayTag;
import org.patryk3211.powergrid.circuits.schematic.Line;
import org.patryk3211.powergrid.circuits.schematic.Point;

public class CircuitLayer {
    public static final int GRID_SIZE = 16;
    public static final int GRID_TO_GRID_SCALE = 1;
    public static final int TOTAL_SIZE = 256;
    private BitSet map = new BitSet(256);

    public void from(CircuitLayer other) {
        this.map = (BitSet)other.map.clone();
    }

    public LongArrayTag serializeNbt() {
        return new LongArrayTag(this.map.toLongArray());
    }

    public void deserialize(long[] tag) {
        this.map = BitSet.valueOf(tag);
    }

    public void set(int x, int y) {
        this.map.set(x + y * 16);
    }

    public boolean get(int x, int y) {
        return this.map.get(x + y * 16);
    }

    public List<Line> calculateLines() {
        ArrayList<Line> lines = new ArrayList<Line>();
        BitSet visited = new BitSet(256);
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                int i;
                boolean bit = this.map.get(x + y * 16);
                if (!bit || visited.get(x + y * 16)) continue;
                int len = 1;
                for (i = y + 1; i < 16 && this.map.get(x + i * 16) && !visited.get(x + i * 16); ++i) {
                    visited.set(x + i * 16);
                    ++len;
                }
                if (len > 1) {
                    lines.add(new Line(true, x, y, y + len));
                    continue;
                }
                for (i = x + 1; i < 16 && this.map.get(i + y * 16) && !visited.get(i + y * 16); ++i) {
                    visited.set(i + y * 16);
                    ++len;
                }
                lines.add(new Line(false, y, x, x + len));
            }
        }
        return lines;
    }

    public List<Point> calculatePoints() {
        ArrayList<Point> points = new ArrayList<Point>();
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                if (!this.map.get(x + y * 16)) continue;
                points.add(new Point(x, y));
            }
        }
        return points;
    }

    public void fill(int x1, int y1, int x2, int y2) {
        for (int x = x1; x <= x2; ++x) {
            for (int y = y1; y <= y2; ++y) {
                this.map.set(x + y * 16);
            }
        }
    }

    public void clear(int x1, int y1, int x2, int y2) {
        for (int x = x1; x <= x2; ++x) {
            for (int y = y1; y <= y2; ++y) {
                this.map.clear(x + y * 16);
            }
        }
    }

    public void clear() {
        this.map.clear();
    }
}

