/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.circuits.schematic;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.patryk3211.powergrid.circuits.schematic.CircuitSchematic;
import org.patryk3211.powergrid.circuits.schematic.Line;
import org.patryk3211.powergrid.circuits.schematic.PlacedComponent;
import org.patryk3211.powergrid.circuits.schematic.Point;

@OnlyIn(value=Dist.CLIENT)
public class CircuitSchematicRender {
    public static final int COLOR_TERMINAL = -215549;
    public static final int COLOR_TRACE_FRONT = -1;
    public static final int COLOR_TRACE_BACK = -2130706433;
    public static final int COLOR_COMPONENT_OUTLINE = -2131724050;
    public static final int COLOR_SELECT_OUTLINE = -2132035020;

    public static void render(CircuitSchematic schematic, GuiGraphics context, int x, int y, int scale) {
    }

    public static void renderLayer(List<Line> lines, GuiGraphics ctx, int x, int y, int scale, int color) {
        for (Line line : lines) {
            int y2;
            int y1;
            int x2;
            int x1;
            if (line.vertical()) {
                x1 = line.position() * scale + x;
                x2 = line.position() * scale + scale + x;
                y1 = line.start() * scale + y;
                y2 = line.end() * scale + y;
            } else {
                x1 = line.start() * scale + x;
                x2 = line.end() * scale + x;
                y1 = line.position() * scale + y;
                y2 = line.position() * scale + scale + y;
            }
            ctx.m_280509_(x1, y1, x2, y2, color);
        }
    }

    public static void renderPoints(List<Point> points, GuiGraphics ctx, int x, int y, int scale, int color) {
        for (Point point : points) {
            int x1 = x + point.x() * scale;
            int y1 = y + point.y() * scale;
            ctx.m_280509_(x1, y1, x1 + scale, y1 + scale, color);
        }
    }

    public static void renderComponents(CircuitSchematic schematic, GuiGraphics ctx, int x, int y, int scale) {
        PoseStack ms = ctx.m_280168_();
        ms.m_85836_();
        ms.m_252880_((float)x, (float)y, 0.0f);
        ms.m_85841_((float)scale, (float)scale, (float)scale);
        for (PlacedComponent placed : schematic.components()) {
            placed.footprint().render(ctx, placed.x * 1, placed.y * 1, false);
        }
        ms.m_85849_();
    }

    public static void renderComponents(CircuitSchematic schematic, GuiGraphics ctx, int x, int y, int scale, int mouseX, int mouseY) {
        PoseStack ms = ctx.m_280168_();
        ms.m_85836_();
        ms.m_252880_((float)x, (float)y, 0.0f);
        ms.m_85841_((float)scale, (float)scale, (float)scale);
        int mX = (mouseX - x) / scale;
        int mY = (mouseY - y) / scale;
        for (PlacedComponent placed : schematic.components()) {
            boolean hovering = mX >= placed.x && mY >= placed.y && mX < placed.x + placed.footprint().getWidth() && mY < placed.y + placed.footprint().getHeight();
            placed.footprint().render(ctx, placed.x * 1, placed.y * 1, hovering);
        }
        ms.m_85849_();
    }
}

