/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.circuits.schematic;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.patryk3211.powergrid.circuits.circuitboard.CircuitBoardBlockEntity;
import org.patryk3211.powergrid.circuits.components.Component;
import org.patryk3211.powergrid.circuits.components.ComponentRegistry;
import org.patryk3211.powergrid.circuits.components.properties.ComponentProperty;
import org.patryk3211.powergrid.circuits.components.properties.PropertyEntry;
import org.patryk3211.powergrid.circuits.schematic.ComponentFootprint;
import org.patryk3211.powergrid.collections.ModdedPackets;
import org.patryk3211.powergrid.electricity.sim.AbstractElectricWire;
import org.patryk3211.powergrid.electricity.sim.node.INode;
import org.patryk3211.powergrid.network.packets.UpdateComponentBiPacket;

public class PlacedComponent {
    public final Component component;
    public final int x;
    public final int y;
    public final UUID uuid;
    private final List<PropertyEntry<?>> properties = new ArrayList();
    private Supplier<Level> worldSupplier;
    private BlockPos pos;
    public final List<INode> nodes = new ArrayList<INode>();
    public final List<AbstractElectricWire> wires = new ArrayList<AbstractElectricWire>();
    public Object customData;
    public boolean destroyed;

    public PlacedComponent(CompoundTag tag) {
        this(PlacedComponent.get(tag.m_128461_("Id")), tag.m_128451_("X"), tag.m_128451_("Y"), tag.m_128342_("UUID"));
        CompoundTag propertyMap = tag.m_128469_("Properties");
        for (PropertyEntry<?> entry : this.properties) {
            entry.read(propertyMap);
        }
    }

    public PlacedComponent(PlacedComponent placed) {
        this(placed.component, placed.x, placed.y, placed.uuid);
        this.worldSupplier = placed.worldSupplier;
        this.pos = placed.pos;
        this.destroyed = placed.destroyed;
        this.customData = placed.customData;
        for (PropertyEntry<?> property : this.properties) {
            property.setValueRaw(placed.get(property.property));
        }
    }

    public PlacedComponent(PlacedComponent placed, int x, int y) {
        this(placed.component, x, y, UUID.randomUUID());
        this.worldSupplier = placed.worldSupplier;
        for (PropertyEntry<?> property : this.properties) {
            property.setValueRaw(placed.get(property.property));
        }
    }

    private static Component get(String id) {
        return ComponentRegistry.get(new ResourceLocation(id));
    }

    public PlacedComponent(Component component, int x, int y, UUID uuid) {
        this.component = component;
        this.x = x;
        this.y = y;
        this.uuid = uuid;
        for (ComponentProperty property : component.getProperties()) {
            this.properties.add(PropertyEntry.makeFor(property, this));
        }
    }

    public void withWorld(Supplier<Level> worldSupplier, BlockPos pos) {
        this.worldSupplier = worldSupplier;
        this.pos = pos;
    }

    public Level getWorld() {
        return this.worldSupplier.get();
    }

    public void onClientWorld(Supplier<Consumer<Level>> callback) {
        Level world = this.getWorld();
        if (world.f_46443_) {
            callback.get().accept(world);
        }
    }

    public void onServerWorld(Supplier<Consumer<Level>> callback) {
        Level world = this.getWorld();
        if (!world.f_46443_) {
            callback.get().accept(world);
        }
    }

    public CompoundTag serializeNbt() {
        CompoundTag tag = new CompoundTag();
        ResourceLocation id = ComponentRegistry.getId(this.component);
        tag.m_128359_("Id", id.toString());
        tag.m_128405_("X", this.x);
        tag.m_128405_("Y", this.y);
        tag.m_128362_("UUID", this.uuid);
        if (!this.properties.isEmpty()) {
            CompoundTag propertyMap = new CompoundTag();
            for (PropertyEntry<?> entry : this.properties) {
                entry.write(propertyMap);
            }
            tag.m_128365_("Properties", (Tag)propertyMap);
        }
        return tag;
    }

    public ComponentFootprint footprint() {
        return this.component.footprint(this);
    }

    public boolean canPlace(int x, int y) {
        return this.component.canPlace(this, x, y);
    }

    public boolean tick() {
        return this.component.tick(this);
    }

    public void stateUpdated() {
        this.component.stateUpdated(this);
    }

    public void notifyClients(ComponentProperty<?> property) {
        this.onServerWorld(() -> world -> {
            CircuitBoardBlockEntity circuit = (CircuitBoardBlockEntity)world.m_7702_(this.pos);
            if (circuit == null) {
                return;
            }
            ModdedPackets.sendToClientsTracking(new UpdateComponentBiPacket(circuit, this, property), (BlockEntity)circuit);
        });
    }

    public void notifyClients(ResourceLocation propertyId) {
        this.onServerWorld(() -> world -> {
            CircuitBoardBlockEntity circuit = (CircuitBoardBlockEntity)world.m_7702_(this.pos);
            if (circuit == null) {
                return;
            }
            ModdedPackets.sendToClientsTracking(new UpdateComponentBiPacket(circuit, this, propertyId), (BlockEntity)circuit);
        });
    }

    public <T> T get(ComponentProperty<T> property) {
        for (PropertyEntry<?> entry : this.properties) {
            if (entry.property != property) continue;
            return (T)entry.get();
        }
        throw new IllegalArgumentException("Placed components doesn't have the requested property");
    }

    public boolean has(ComponentProperty<?> property) {
        for (PropertyEntry<?> entry : this.properties) {
            if (entry.property != property) continue;
            return true;
        }
        return false;
    }

    public PropertyEntry<?> getEntry(ResourceLocation id) {
        for (PropertyEntry<?> entry : this.properties) {
            if (!entry.property.id().equals((Object)id)) continue;
            return entry;
        }
        throw new IllegalArgumentException("Placed components doesn't have the requested property");
    }

    public <T> PropertyEntry<T> getEntry(ComponentProperty<T> property) {
        for (PropertyEntry<?> entry : this.properties) {
            if (entry.property != property) continue;
            return entry;
        }
        throw new IllegalArgumentException("Placed components doesn't have the requested property");
    }

    public <T> void set(ComponentProperty<T> property, T value) {
        for (PropertyEntry<?> entry : this.properties) {
            if (entry.property != property) continue;
            entry.setValueRaw(value);
            return;
        }
        throw new IllegalArgumentException("Placed components doesn't have the requested property");
    }

    public String getString(ComponentProperty<?> property) {
        for (PropertyEntry<?> entry : this.properties) {
            if (entry.property != property) continue;
            return entry.stringValue();
        }
        throw new IllegalArgumentException("Placed components doesn't have the requested property");
    }

    public void setString(ComponentProperty<?> property, String value) {
        for (PropertyEntry<?> entry : this.properties) {
            if (entry.property != property) continue;
            entry.setValue(value);
            return;
        }
        throw new IllegalArgumentException("Placed components doesn't have the requested property");
    }

    public boolean intersects(int x, int y, int width, int height) {
        ComponentFootprint footprint = this.footprint();
        return this.x < x + width && this.x + footprint.getWidth() > x && this.y < y + height && this.y + footprint.getHeight() > y;
    }

    public boolean intersects32(int x, int y, int width, int height) {
        ComponentFootprint footprint = this.footprint();
        return this.x * 1 < x + width && this.x * 1 + footprint.getWidth() * 1 > x && this.y * 1 < y + height && this.y * 1 + footprint.getHeight() * 1 > y;
    }

    public void add(INode node) {
        this.nodes.add(node);
    }

    public void add(AbstractElectricWire wire) {
        this.wires.add(wire);
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public BlockPos getPos() {
        return this.pos;
    }
}

