/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.circuits.thermal;

import java.util.Collection;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.electricity.sim.AbstractElectricWire;

public class ThermalUnit {
    private final UUID componentUUID;
    private final int index;
    private final float thermalMass;
    private final float dissipationFactor;
    private final float overheatTemperature;
    private final Collection<AbstractElectricWire> heatSources;
    @Nullable
    private final Consumer<Float> temperatureCallback;
    @Nullable
    private final Runnable overheatCallback;
    private float temperature = 22.0f;
    private int overheatTicks;
    private Vec3 position;

    public ThermalUnit(UUID componentUUID, int index, float thermalMass, float dissipationFactor, float overheatTemperature, Collection<AbstractElectricWire> heatSources, @Nullable Consumer<Float> temperatureCallback, @Nullable Runnable overheatCallback) {
        this.componentUUID = componentUUID;
        this.index = index;
        this.thermalMass = thermalMass;
        this.dissipationFactor = dissipationFactor;
        this.overheatTemperature = overheatTemperature;
        this.heatSources = heatSources;
        this.temperatureCallback = temperatureCallback;
        this.overheatCallback = overheatCallback;
    }

    private void temperatureChanged() {
        if (this.hasOverheated()) {
            this.heatSources.forEach(AbstractElectricWire::remove);
            if (this.overheatCallback != null) {
                this.overheatCallback.run();
            }
        }
        if (this.temperatureCallback != null) {
            this.temperatureCallback.accept(Float.valueOf(this.temperature));
        }
    }

    public boolean hasOverheated() {
        return this.temperature >= this.overheatTemperature && this.overheatTicks >= 2;
    }

    public void tick(float dissipationMultiplier) {
        if (this.hasOverheated()) {
            return;
        }
        float power = -this.dissipationFactor * (this.temperature - 22.0f) * dissipationMultiplier;
        for (AbstractElectricWire source : this.heatSources) {
            if (!source.isConverged()) continue;
            power += source.power();
        }
        this.temperature += power / 20.0f / this.thermalMass;
        if (!Float.isFinite(this.temperature)) {
            this.temperature = 22.0f;
        }
        if (this.temperature > this.overheatTemperature + 10.0f) {
            this.temperature = this.overheatTemperature + 10.0f;
        }
        if (power < 0.0f && this.temperature < 22.0f) {
            this.temperature = 22.0f;
        }
        if (this.temperature >= this.overheatTemperature && power > 0.0f) {
            ++this.overheatTicks;
        } else if (power < 0.0f) {
            this.overheatTicks = 0;
        }
        this.temperatureChanged();
    }

    public ThermalUnit withPosition(Vec3 position) {
        this.position = position;
        return this;
    }

    public Vec3 getPosition() {
        return this.position;
    }

    public float getTemperature() {
        return this.temperature;
    }

    public float getOverheatTemperature() {
        return this.overheatTemperature;
    }

    public String getKey() {
        return this.componentUUID.toString() + "-" + this.index;
    }

    public void read(CompoundTag nbt) {
        this.temperature = nbt.m_128457_(this.getKey());
        this.temperatureChanged();
    }

    public void write(CompoundTag nbt) {
        nbt.m_128350_(this.getKey(), this.temperature);
    }

    public UUID getId() {
        return this.componentUUID;
    }
}

