/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.compat.rei;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.Create;
import com.simibubi.create.compat.rei.ConversionRecipe;
import com.simibubi.create.compat.rei.CreateREI;
import com.simibubi.create.compat.rei.DoubleItemIcon;
import com.simibubi.create.compat.rei.EmptyBackground;
import com.simibubi.create.compat.rei.ItemIcon;
import com.simibubi.create.compat.rei.category.CreateRecipeCategory;
import com.simibubi.create.compat.rei.category.MysteriousItemConversionCategory;
import com.simibubi.create.compat.rei.display.CreateDisplay;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import com.simibubi.create.infrastructure.config.AllConfigs;
import com.simibubi.create.infrastructure.config.CRecipes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.drag.DraggableStack;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackVisitor;
import me.shedaniel.rei.api.client.gui.drag.DraggedAcceptorResult;
import me.shedaniel.rei.api.client.gui.drag.DraggingContext;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import net.createmod.catnip.config.ConfigBase;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import org.patryk3211.powergrid.PowerGrid;
import org.patryk3211.powergrid.circuits.editor.CircuitDesignTableEditScreen;
import org.patryk3211.powergrid.collections.ModdedBlocks;
import org.patryk3211.powergrid.collections.ModdedItems;
import org.patryk3211.powergrid.compat.HiddenItems;
import org.patryk3211.powergrid.compat.rei.CircuitAssemblyCategory;
import org.patryk3211.powergrid.compat.rei.CircuitAssemblyDisplay;
import org.patryk3211.powergrid.compat.rei.CircuitDesignCategory;
import org.patryk3211.powergrid.compat.rei.CircuitDesignDisplay;
import org.patryk3211.powergrid.compat.rei.MagnetizingCategory;
import org.patryk3211.powergrid.electricity.electromagnet.recipe.MagnetizingRecipe;
import org.patryk3211.powergrid.utility.Lang;

public class PowerGridREI
implements REIClientPlugin {
    private static final ResourceLocation ID = PowerGrid.asResource("rei_plugin");
    private final List<CreateRecipeCategory<?>> allCategories = new ArrayList();

    public String getPluginProviderName() {
        return ID.toString();
    }

    public void registerScreens(ScreenRegistry registry) {
        super.registerScreens(registry);
        registry.registerDraggableStackVisitor((DraggableStackVisitor)new DraggableStackVisitor<CircuitDesignTableEditScreen>(){

            public <R extends Screen> boolean isHandingScreen(R screen) {
                return screen instanceof CircuitDesignTableEditScreen;
            }

            public Stream<DraggableStackVisitor.BoundsProvider> getDraggableAcceptingBounds(DraggingContext<CircuitDesignTableEditScreen> context, DraggableStack stack) {
                return Stream.of(() -> {
                    Rect2i r = ((CircuitDesignTableEditScreen)context.getScreen()).ghostTarget();
                    return DraggableStackVisitor.BoundsProvider.fromRectangle((Rectangle)new Rectangle(r.m_110085_(), r.m_110086_(), r.m_110090_(), r.m_110091_()));
                });
            }

            public DraggedAcceptorResult acceptDraggedStack(DraggingContext<CircuitDesignTableEditScreen> context, DraggableStack stack) {
                if (stack.get().getType() == VanillaEntryTypes.ITEM) {
                    ItemStack itemStack = (ItemStack)stack.get().getValue();
                    ((CircuitDesignTableEditScreen)context.getScreen()).toolSelect(itemStack.m_41720_());
                    return DraggedAcceptorResult.ACCEPTED;
                }
                return DraggedAcceptorResult.PASS;
            }
        });
    }

    public void registerCategories(CategoryRegistry registry) {
        CircuitDesignCategory circuitDesignCategory = new CircuitDesignCategory();
        CircuitAssemblyCategory circuitAssemblyCategory = new CircuitAssemblyCategory();
        registry.add((DisplayCategory)circuitDesignCategory);
        registry.addWorkstations(CircuitDesignCategory.IDENTIFIER, new EntryStack[]{EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)ModdedBlocks.CIRCUIT_DESIGN_TABLE.asStack())});
        registry.add((DisplayCategory)circuitAssemblyCategory);
        registry.addWorkstations(CircuitAssemblyCategory.IDENTIFIER, new EntryStack[]{EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)AllBlocks.MECHANICAL_ARM.asStack())});
        CreateRecipeCategory<MagnetizingRecipe> magnetizing = new CategoryBuilder<MagnetizingRecipe>(MagnetizingRecipe.class).addTypedRecipes(MagnetizingRecipe.TYPE_INFO).catalyst(() -> ModdedBlocks.ELECTROMAGNET.get()).itemIcon((ItemLike)ModdedBlocks.ELECTROMAGNET.get()).emptyBackground(177, 88).build("magnetizing", (CreateRecipeCategory.Factory<MagnetizingRecipe>)((CreateRecipeCategory.Factory)MagnetizingCategory::new));
        this.allCategories.forEach(category -> {
            registry.add((DisplayCategory)category);
            category.registerCatalysts(registry);
        });
    }

    public void registerDisplays(DisplayRegistry registry) {
        registry.add((Display)new CircuitDesignDisplay());
        registry.add((Display)new CircuitAssemblyDisplay());
        this.allCategories.forEach(c -> c.registerRecipes(registry));
    }

    public void registerEntries(EntryRegistry registry) {
        MysteriousItemConversionCategory.RECIPES.add(ConversionRecipe.create((ItemStack)new ItemStack((ItemLike)Items.f_42416_), (ItemStack)ModdedItems.MAGNET.asStack()));
        registry.removeEntryIf(entryStack -> {
            if (entryStack.getType() == VanillaEntryTypes.ITEM) {
                ItemStack itemStack = (ItemStack)entryStack.castValue();
                return HiddenItems.getHiddenPredicate().test(itemStack.m_41720_());
            }
            return false;
        });
    }

    private class CategoryBuilder<T extends Recipe<?>> {
        private final Class<? extends T> recipeClass;
        private Predicate<CRecipes> predicate = cRecipes -> true;
        private Renderer background;
        private Renderer icon;
        private int width;
        private int height;
        private Function<T, ? extends CreateDisplay<T>> displayFactory;
        private final List<Consumer<List<T>>> recipeListConsumers = new ArrayList<Consumer<List<T>>>();
        private final List<Supplier<? extends ItemStack>> catalysts = new ArrayList<Supplier<? extends ItemStack>>();

        public CategoryBuilder(Class<? extends T> recipeClass) {
            this.recipeClass = recipeClass;
        }

        public CategoryBuilder<T> enableIf(Predicate<CRecipes> predicate) {
            this.predicate = predicate;
            return this;
        }

        public CategoryBuilder<T> enableWhen(Function<CRecipes, ConfigBase.ConfigBool> configValue) {
            this.predicate = c -> (Boolean)((ConfigBase.ConfigBool)configValue.apply((CRecipes)c)).get();
            return this;
        }

        public CategoryBuilder<T> addRecipeListConsumer(Consumer<List<T>> consumer) {
            this.recipeListConsumers.add(consumer);
            return this;
        }

        public CategoryBuilder<T> addRecipes(Supplier<Collection<? extends T>> collection) {
            return this.addRecipeListConsumer(recipes -> recipes.addAll((Collection)collection.get()));
        }

        public CategoryBuilder<T> addAllRecipesIf(Predicate<Recipe<?>> pred) {
            return this.addRecipeListConsumer(recipes -> CreateREI.consumeAllRecipes(recipe -> {
                if (pred.test((Recipe<?>)recipe)) {
                    recipes.add(recipe);
                }
            }));
        }

        public CategoryBuilder<T> addAllRecipesIf(Predicate<Recipe<?>> pred, Function<Recipe<?>, T> converter) {
            return this.addRecipeListConsumer(recipes -> CreateREI.consumeAllRecipes(recipe -> {
                if (pred.test((Recipe<?>)recipe)) {
                    recipes.add((Recipe)converter.apply((Recipe<?>)recipe));
                }
            }));
        }

        public CategoryBuilder<T> addTypedRecipes(IRecipeTypeInfo recipeTypeEntry) {
            return this.addTypedRecipes(() -> ((IRecipeTypeInfo)recipeTypeEntry).getType());
        }

        public CategoryBuilder<T> addTypedRecipes(Supplier<RecipeType<? extends T>> recipeType) {
            return this.addRecipeListConsumer(recipes -> CreateREI.consumeTypedRecipes(recipes::add, (RecipeType)((RecipeType)recipeType.get())));
        }

        public CategoryBuilder<T> addTypedRecipes(Supplier<RecipeType<? extends T>> recipeType, Function<Recipe<?>, T> converter) {
            return this.addRecipeListConsumer(recipes -> CreateREI.consumeTypedRecipes(recipe -> recipes.add((Recipe)converter.apply((Recipe<?>)recipe)), (RecipeType)((RecipeType)recipeType.get())));
        }

        public CategoryBuilder<T> addTypedRecipesIf(Supplier<RecipeType<? extends T>> recipeType, Predicate<Recipe<?>> pred) {
            return this.addRecipeListConsumer(recipes -> CreateREI.consumeTypedRecipes(recipe -> {
                if (pred.test((Recipe<?>)recipe)) {
                    recipes.add(recipe);
                }
            }, (RecipeType)((RecipeType)recipeType.get())));
        }

        public CategoryBuilder<T> addTypedRecipesExcluding(Supplier<RecipeType<? extends T>> recipeType, Supplier<RecipeType<? extends T>> excluded) {
            return this.addRecipeListConsumer(recipes -> {
                List excludedRecipes = CreateREI.getTypedRecipes((RecipeType)((RecipeType)excluded.get()));
                CreateREI.consumeTypedRecipes(recipe -> {
                    for (Recipe excludedRecipe : excludedRecipes) {
                        if (!CreateREI.doInputsMatch((Recipe)recipe, (Recipe)excludedRecipe)) continue;
                        return;
                    }
                    recipes.add(recipe);
                }, (RecipeType)((RecipeType)recipeType.get()));
            });
        }

        public CategoryBuilder<T> removeRecipes(Supplier<RecipeType<? extends T>> recipeType) {
            return this.addRecipeListConsumer(recipes -> {
                List excludedRecipes = CreateREI.getTypedRecipes((RecipeType)((RecipeType)recipeType.get()));
                recipes.removeIf(recipe -> {
                    for (Recipe excludedRecipe : excludedRecipes) {
                        if (!CreateREI.doInputsMatch((Recipe)recipe, (Recipe)excludedRecipe)) continue;
                        return true;
                    }
                    return false;
                });
            });
        }

        public CategoryBuilder<T> catalystStack(Supplier<ItemStack> supplier) {
            this.catalysts.add(supplier);
            return this;
        }

        public CategoryBuilder<T> catalyst(Supplier<ItemLike> supplier) {
            return this.catalystStack(() -> new ItemStack((ItemLike)((ItemLike)supplier.get()).m_5456_()));
        }

        public CategoryBuilder<T> icon(Renderer icon) {
            this.icon = icon;
            return this;
        }

        public CategoryBuilder<T> itemIcon(ItemLike item) {
            this.icon((Renderer)new ItemIcon(() -> new ItemStack(item)));
            return this;
        }

        public CategoryBuilder<T> doubleItemIcon(ItemLike item1, ItemLike item2) {
            this.icon((Renderer)new DoubleItemIcon(() -> new ItemStack(item1), () -> new ItemStack(item2)));
            return this;
        }

        public CategoryBuilder<T> background(Renderer background) {
            this.background = background;
            return this;
        }

        public CategoryBuilder<T> emptyBackground(int width, int height) {
            this.background((Renderer)new EmptyBackground(width, height));
            this.dimensions(width, height);
            return this;
        }

        public CategoryBuilder<T> width(int width) {
            this.width = width;
            return this;
        }

        public CategoryBuilder<T> height(int height) {
            this.height = height;
            return this;
        }

        public CategoryBuilder<T> dimensions(int width, int height) {
            this.width(width);
            this.height(height);
            return this;
        }

        public CategoryBuilder<T> displayFactory(Function<T, ? extends CreateDisplay<T>> factory) {
            this.displayFactory = factory;
            return this;
        }

        public CreateRecipeCategory<T> build(String name, CreateRecipeCategory.Factory<T> factory) {
            Supplier<List> recipesSupplier = this.predicate.test(AllConfigs.server().recipes) ? () -> {
                ArrayList recipes = new ArrayList();
                if (this.predicate.test(AllConfigs.server().recipes)) {
                    for (Consumer consumer : this.recipeListConsumers) {
                        consumer.accept(recipes);
                    }
                }
                return recipes;
            } : Collections::emptyList;
            if (this.width <= 0 || this.height <= 0) {
                Create.LOGGER.warn("Create REI category [{}] has weird dimensions: {}x{}", new Object[]{name, this.width, this.height});
            }
            CreateRecipeCategory.Info info = new CreateRecipeCategory.Info(CategoryIdentifier.of((ResourceLocation)Create.asResource((String)name)), (Component)Lang.translateDirect("recipe." + name, new Object[0]), this.background, this.icon, recipesSupplier, this.catalysts, this.width, this.height, this.displayFactory == null ? recipe -> new CreateDisplay(recipe, CategoryIdentifier.of((ResourceLocation)Create.asResource((String)name))) : this.displayFactory);
            CreateRecipeCategory category = factory.create(info);
            PowerGridREI.this.allCategories.add(category);
            return category;
        }
    }
}

