/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.base.terminals;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.patryk3211.powergrid.electricity.base.TerminalBoundingBox;
import org.patryk3211.powergrid.electricity.base.terminals.TerminalCollectionBuilder;

public class BlockStateTerminalCollection {
    private final Map<PartialState, TerminalBoundingBox[]> terminals;
    private final List<Property<?>> checkedProperties;
    private Function<BlockState, VoxelShape> shapeMapper;
    private final int count;

    private BlockStateTerminalCollection(Map<PartialState, TerminalBoundingBox[]> terminals, List<Property<?>> checkedProperties, int count) {
        this.terminals = terminals;
        this.checkedProperties = checkedProperties;
        this.count = count;
    }

    public TerminalBoundingBox get(BlockState state, int index) {
        TerminalBoundingBox[] value = this.terminals.get(PartialState.of(state, this.checkedProperties));
        if (value == null) {
            return null;
        }
        if (index < 0 || index >= value.length) {
            return null;
        }
        return value[index];
    }

    public int count() {
        return this.count;
    }

    public Function<BlockState, VoxelShape> shapeMapper() {
        if (this.shapeMapper == null) {
            return null;
        }
        return state -> {
            TerminalBoundingBox[] terminals;
            VoxelShape baseShape = this.shapeMapper.apply((BlockState)state);
            for (TerminalBoundingBox terminal : terminals = this.terminals.get(PartialState.of(state, this.checkedProperties))) {
                if (terminal == null) continue;
                baseShape = Shapes.m_83110_((VoxelShape)baseShape, (VoxelShape)terminal.getShape());
            }
            return baseShape;
        };
    }

    public static TerminalBoundingBox[] each(TerminalBoundingBox[] input, UnaryOperator<TerminalBoundingBox> func) {
        TerminalBoundingBox[] copy = new TerminalBoundingBox[input.length];
        for (int i = 0; i < input.length; ++i) {
            copy[i] = input[i] == null ? null : (TerminalBoundingBox)func.apply(input[i]);
        }
        return copy;
    }

    public static Builder builder(Block block) {
        return new Builder(block);
    }

    public static class PartialState
    implements Predicate<BlockState> {
        private final Block block;
        private final Map<Property<?>, Comparable<?>> states;

        public PartialState(Block block, Map<Property<?>, Comparable<?>> states) {
            this.block = block;
            this.states = states;
        }

        @Override
        public boolean test(BlockState state) {
            if (!state.m_60713_(this.block)) {
                return false;
            }
            for (Map.Entry<Property<?>, Comparable<?>> property : this.states.entrySet()) {
                if (state.m_61143_(property.getKey()) == property.getValue()) continue;
                return false;
            }
            return true;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof PartialState) {
                PartialState state = (PartialState)obj;
                return this.block == state.block && this.states.equals(state.states);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.block, this.states);
        }

        public static PartialState of(BlockState state, Collection<Property<?>> properties) {
            HashMap map = new HashMap();
            for (Property<?> property : properties) {
                map.put(property, state.m_61143_(property));
            }
            return new PartialState(state.m_60734_(), map);
        }
    }

    public static class Builder
    implements TerminalCollectionBuilder<BlockStateTerminalCollection> {
        private final Block block;
        private final Map<PartialState, TerminalBoundingBox[]> terminals;
        private Function<BlockState, VoxelShape> shapeMapper = null;

        private Builder(Block block) {
            this.block = block;
            this.terminals = new HashMap<PartialState, TerminalBoundingBox[]>();
        }

        public Builder forAllStates(Function<BlockState, TerminalBoundingBox[]> mapper) {
            return this.forAllStatesExcept(mapper, new Property[0]);
        }

        public Builder forAllStatesExcept(Function<BlockState, TerminalBoundingBox[]> mapper, Property<?> ... ignored) {
            HashSet<PartialState> seen = new HashSet<PartialState>();
            ImmutableList states = this.block.m_49965_().m_61056_();
            for (BlockState state : states) {
                LinkedHashMap properties = Maps.newLinkedHashMap((Map)state.m_61148_());
                for (Property<?> prop : ignored) {
                    properties.remove(prop);
                }
                PartialState partial = new PartialState(this.block, properties);
                if (!seen.add(partial)) continue;
                this.terminals.put(partial, mapper.apply(state));
            }
            return this;
        }

        public Builder withShapeMapper(Function<BlockState, VoxelShape> mapper) {
            this.shapeMapper = mapper;
            return this;
        }

        @Override
        public BlockStateTerminalCollection build() {
            Set<Property<?>> checkedProperties = null;
            int count = 0;
            for (PartialState state : this.terminals.keySet()) {
                if (checkedProperties == null) {
                    checkedProperties = state.states.keySet();
                    count = this.terminals.get(state).length;
                    continue;
                }
                if (!checkedProperties.equals(state.states.keySet())) {
                    throw new IllegalStateException("All partial states must check the same property set");
                }
                if (this.terminals.get(state).length == count) continue;
                throw new IllegalStateException("All states must map the same number of terminals");
            }
            BlockStateTerminalCollection collection = checkedProperties != null ? new BlockStateTerminalCollection(this.terminals, Lists.newArrayList(checkedProperties), count) : new BlockStateTerminalCollection(this.terminals, List.of(), count);
            collection.shapeMapper = this.shapeMapper;
            return collection;
        }
    }
}

