/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.deviceconnector;

import com.simibubi.create.foundation.block.IBE;
import dev.architectury.injectables.annotations.ExpectPlatform;
import net.createmod.catnip.math.VoxelShaper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.patryk3211.powergrid.base.CustomProperties;
import org.patryk3211.powergrid.collections.ModdedBlockEntities;
import org.patryk3211.powergrid.electricity.base.ElectricBlock;
import org.patryk3211.powergrid.electricity.base.IDecoratedTerminal;
import org.patryk3211.powergrid.electricity.base.TerminalBoundingBox;
import org.patryk3211.powergrid.electricity.base.terminals.BlockStateTerminalCollection;
import org.patryk3211.powergrid.electricity.deviceconnector.DeviceConnectorBlockEntity;
import org.patryk3211.powergrid.electricity.deviceconnector.IAcceptConnector;
import org.patryk3211.powergrid.electricity.deviceconnector.forge.DeviceConnectorBlockImpl;
import org.patryk3211.powergrid.electricity.wire.powercord.AutoCordEndpoint;
import org.patryk3211.powergrid.electricity.wire.powercord.IAcceptCord;
import org.patryk3211.powergrid.utility.proxy.ProxyProvider;
import org.patryk3211.powergrid.utility.proxy.TFMGProxy;

public class DeviceConnectorBlock
extends ElectricBlock
implements IBE<DeviceConnectorBlockEntity>,
IAcceptCord {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final IntegerProperty ROTATION = CustomProperties.ROTATION_4;
    public static final BooleanProperty POLARIZED = BooleanProperty.m_61465_((String)"polarized");
    private final TerminalBoundingBox[] TERMINALS_DOWN = new TerminalBoundingBox[]{new TerminalBoundingBox(IDecoratedTerminal.CONNECTOR, 5.5, 1.0, 1.5, 10.5, 4.0, 4.5), new TerminalBoundingBox(IDecoratedTerminal.CONNECTOR, 5.5, 1.0, 11.5, 10.5, 4.0, 14.5)};
    private final TerminalBoundingBox[] POLARIZED_TERMINALS_DOWN = new TerminalBoundingBox[]{new TerminalBoundingBox(IDecoratedTerminal.POSITIVE, 5.5, 1.0, 1.5, 10.5, 4.0, 4.5).withColor(0xFF3B3B), new TerminalBoundingBox(IDecoratedTerminal.NEGATIVE, 5.5, 1.0, 11.5, 10.5, 4.0, 14.5).withColor(3899647)};
    private static final VoxelShape SHAPE_DOWN = DeviceConnectorBlock.m_49796_((double)4.5, (double)0.0, (double)3.5, (double)11.5, (double)4.0, (double)12.5);
    private static final VoxelShape SHAPE_DOWN_2 = DeviceConnectorBlock.m_49796_((double)3.5, (double)0.0, (double)4.5, (double)12.5, (double)4.0, (double)11.5);

    public DeviceConnectorBlock(BlockBehaviour.Properties settings) {
        super(settings);
        VoxelShaper shaper = VoxelShaper.forDirectional((VoxelShape)SHAPE_DOWN, (Direction)Direction.DOWN);
        VoxelShaper shaper2 = VoxelShaper.forDirectional((VoxelShape)SHAPE_DOWN_2, (Direction)Direction.DOWN);
        this.setTerminalCollection(BlockStateTerminalCollection.builder(this).forAllStates(state -> BlockStateTerminalCollection.each((Boolean)state.m_61143_((Property)POLARIZED) != false ? this.POLARIZED_TERMINALS_DOWN : this.TERMINALS_DOWN, terminal -> {
            Direction facing = (Direction)state.m_61143_((Property)FACING);
            terminal = switch (facing) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.DOWN -> terminal;
                case Direction.UP -> terminal.rotateAroundX(180);
                case Direction.EAST -> terminal.rotateAroundZ(-90);
                case Direction.WEST -> terminal.rotateAroundZ(90);
                case Direction.NORTH -> terminal.rotateAroundZ(90).rotateAroundY(90);
                case Direction.SOUTH -> terminal.rotateAroundZ(90).rotateAroundY(-90);
            };
            Integer rotation = (Integer)state.m_61143_((Property)ROTATION);
            terminal = terminal.rotate(facing.m_122434_(), 90 * rotation - 90);
            return terminal;
        })).withShapeMapper(state -> {
            Direction facing = (Direction)state.m_61143_((Property)FACING);
            Integer rotation = (Integer)state.m_61143_((Property)ROTATION);
            boolean axis_along = rotation % 2 == 1;
            VoxelShaper prov = axis_along ^ facing.m_122434_() == Direction.Axis.Y ? shaper2 : shaper;
            return prov.get(facing);
        }).build());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING, ROTATION, POLARIZED});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        IAcceptConnector acceptor;
        boolean polarized;
        Direction facing = ctx.m_43719_().m_122424_();
        int rotation = 0;
        if (facing.m_122434_() == Direction.Axis.Y) {
            Direction player = ctx.m_8125_();
            rotation = player.m_122416_();
        } else {
            rotation = 1;
        }
        BlockState neighbor = ctx.m_43725_().m_8055_(ctx.m_8083_().m_121945_(facing));
        Block block = neighbor.m_60734_();
        boolean bl = polarized = block instanceof IAcceptConnector && (acceptor = (IAcceptConnector)block).isPolarized();
        if (ctx.m_43723_() != null && ctx.m_43723_().m_6144_()) {
            rotation = (rotation + 2) % 3;
        }
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing)).m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(rotation))).m_61124_((Property)POLARIZED, (Comparable)Boolean.valueOf(polarized));
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean hasEnergyStorage(Level world, BlockPos pos, Direction side) {
        void var2_2;
        void var1_1;
        return DeviceConnectorBlockImpl.hasEnergyStorage(world, (BlockPos)var1_1, (Direction)var2_2);
    }

    public static VoxelShape makeCheckShape(Direction side) {
        Vector3f min = new Vector3f(0.375f);
        Vector3f max = new Vector3f(0.625f);
        switch (side.m_122434_()) {
            case X: {
                min.x = 0.0f;
                max.x = 1.0f;
                break;
            }
            case Y: {
                min.y = 0.0f;
                max.y = 1.0f;
                break;
            }
            case Z: {
                min.z = 0.0f;
                max.z = 1.0f;
            }
        }
        return Shapes.m_83048_((double)min.x, (double)min.y, (double)min.z, (double)max.x, (double)max.y, (double)max.z);
    }

    public static boolean canSupport(LevelReader world, BlockPos pos, BlockState state, Direction side) {
        VoxelShape connectorShape = DeviceConnectorBlock.makeCheckShape(side);
        VoxelShape shape = state.m_60812_((BlockGetter)world, pos);
        return Shapes.m_83117_((VoxelShape)connectorShape, (VoxelShape)shape, (Direction)side.m_122424_());
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        Level world1;
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BlockPos neighborPos = pos.m_121945_(facing);
        BlockState neighbor = world.m_8055_(neighborPos);
        if (neighbor.m_60734_() == this) {
            return false;
        }
        if (world instanceof Level && DeviceConnectorBlock.hasEnergyStorage(world1 = (Level)world, neighborPos, facing.m_122424_())) {
            return DeviceConnectorBlock.canSupport(world, neighborPos, neighbor, facing.m_122424_());
        }
        if (ProxyProvider.get(TFMGProxy.class).map(proxy -> proxy.canConnect(world, neighborPos, facing.m_122424_())).orElse(false).booleanValue()) {
            return true;
        }
        Block block = neighbor.m_60734_();
        if (!(block instanceof IAcceptConnector)) {
            return false;
        }
        IAcceptConnector acceptor = (IAcceptConnector)block;
        return acceptor.canConnect(world, neighborPos, neighbor, facing.m_122424_());
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block sourceBlock, BlockPos sourcePos, boolean notify) {
        super.m_6861_(state, world, pos, sourceBlock, sourcePos, notify);
        if (!this.m_7898_(state, (LevelReader)world, pos)) {
            world.m_46961_(pos, true);
        }
    }

    public Class<DeviceConnectorBlockEntity> getBlockEntityClass() {
        return DeviceConnectorBlockEntity.class;
    }

    public BlockEntityType<? extends DeviceConnectorBlockEntity> getBlockEntityType() {
        return (BlockEntityType)ModdedBlockEntities.DEVICE_CONNECTOR.get();
    }

    public BlockState getRotatedBlockState(BlockState originalState, Direction targetedFace) {
        if (targetedFace.m_122434_() == ((Direction)originalState.m_61143_((Property)FACING)).m_122434_()) {
            return (BlockState)originalState.m_61122_((Property)ROTATION);
        }
        return super.getRotatedBlockState(originalState, targetedFace);
    }

    @Override
    @Nullable
    public AutoCordEndpoint getEndpoint(UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState state = level.m_8055_(pos);
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        Vec3 center = Vec3.m_82512_((Vec3i)pos);
        Vec3i normal = facing.m_122436_();
        Vec3 point = center.m_82520_((double)normal.m_123341_() * 0.3125, (double)normal.m_123342_() * 0.3125, (double)normal.m_123343_() * 0.3125);
        return new AutoCordEndpoint(context.m_8083_(), 0, 1, point, this.renderPlug() ? context.m_43719_() : null);
    }
}

