/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.light.fixture;

import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.electricity.base.ElectricBlockEntity;
import org.patryk3211.powergrid.electricity.base.IElectricEntity;
import org.patryk3211.powergrid.electricity.light.bulb.ILightBulb;
import org.patryk3211.powergrid.electricity.light.bulb.LightBulbState;
import org.patryk3211.powergrid.electricity.light.fixture.LightFixtureBlock;
import org.patryk3211.powergrid.electricity.sim.SwitchedWire;

public class LightFixtureBlockEntity
extends ElectricBlockEntity {
    private SwitchedWire filament;
    @Nullable
    private LightBulbState bulbState = null;

    public LightFixtureBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void tick() {
        super.tick();
        if (this.bulbState != null) {
            this.bulbState.tick();
            this.m_6596_();
        }
    }

    private void lightBulbChanged() {
        if (this.bulbState == null) {
            this.filament.setState(false);
        } else {
            this.filament.setResistance(this.bulbState.resistance());
            this.filament.setState(!this.bulbState.isBurned());
        }
        this.notifyUpdate();
    }

    @Nullable
    public LightBulbState getBulbState() {
        return this.bulbState;
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        if (this.bulbState != null) {
            this.bulbState.write(tag);
        }
    }

    public void writeSafe(CompoundTag tag) {
        super.writeSafe(tag);
        if (this.bulbState != null) {
            this.bulbState.write(tag);
        }
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        Item currentItem = this.bulbState != null ? this.bulbState.getItem() : null;
        Item nbtItem = LightBulbState.getBulbItem(tag);
        if (currentItem != nbtItem) {
            this.bulbState = nbtItem == null ? null : ((ILightBulb)nbtItem).createState(this);
        }
        if (this.bulbState != null) {
            this.bulbState.read(tag);
        }
        this.lightBulbChanged();
    }

    @Override
    public void buildCircuit(IElectricEntity.CircuitBuilder builder) {
        builder.setTerminalCount(2);
        this.filament = builder.connectSwitch(1.0f, builder.terminalNode(0), builder.terminalNode(1), false);
    }

    public boolean replaceBulb(Player player, InteractionHand hand, ItemStack usedStack) {
        assert (this.f_58857_ != null);
        boolean result = this.replaceBulbInternal(player, hand, usedStack);
        if (result) {
            this.lightBulbChanged();
            if (!this.f_58857_.f_46443_ && this.bulbState == null) {
                this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)LightFixtureBlock.POWER, (Comparable)Integer.valueOf(0)), 3);
            }
        }
        return result;
    }

    private boolean replaceBulbInternal(Player player, InteractionHand hand, ItemStack usedStack) {
        assert (this.f_58857_ != null);
        if (usedStack == null || usedStack.m_41619_()) {
            if (this.bulbState == null) {
                return false;
            }
            if (!this.f_58857_.f_46443_) {
                if (!this.bulbState.isBurned()) {
                    player.m_21008_(hand, this.bulbState.toStack());
                }
                this.bulbState = null;
            }
            return true;
        }
        if (this.bulbState == null) {
            Item item;
            if (!this.f_58857_.f_46443_ && (item = usedStack.m_41720_()) instanceof ILightBulb) {
                ILightBulb bulb = (ILightBulb)item;
                this.bulbState = bulb.createState(this);
                if (!player.m_7500_()) {
                    usedStack.m_41774_(1);
                }
            }
            return true;
        }
        if (this.bulbState.isBurned()) {
            if (!this.f_58857_.f_46443_) {
                this.bulbState = null;
            }
            return true;
        }
        if (this.bulbState.isOf(usedStack.m_41720_()) && usedStack.m_41613_() < usedStack.m_41741_()) {
            if (!this.f_58857_.f_46443_) {
                if (!player.m_7500_()) {
                    usedStack.m_41769_(1);
                }
                this.bulbState = null;
            }
            return true;
        }
        if (player.m_7500_()) {
            this.bulbState = null;
            return true;
        }
        return false;
    }

    public SwitchedWire getFilament() {
        return this.filament;
    }

    protected AABB createRenderBoundingBox() {
        return new AABB(this.f_58858_);
    }

    public ItemRequirement getRequiredItems(BlockState state) {
        if (this.bulbState != null) {
            return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, this.bulbState.getItem());
        }
        return ItemRequirement.NONE;
    }
}

